/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.device.endpoints;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceTokenStoreProvider;
import org.keycloak.models.OAuth2DeviceUserCodeModel;
import org.keycloak.models.OAuth2DeviceUserCodeProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequestParserProcessor;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.OAuth2DeviceAuthorizationResponse;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;

public class DeviceEndpoint
extends AuthorizationEndpointBase
implements RealmResourceProvider {
    protected static final Logger logger = Logger.getLogger(DeviceEndpoint.class);

    public DeviceEndpoint(RealmModel realm, EventBuilder event) {
        super(realm, event);
    }

    @Path(value="")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response handleDeviceRequest() {
        logger.trace((Object)"Processing @POST request");
        this.event.event(EventType.OAUTH2_DEVICE_AUTH);
        this.checkSsl();
        this.checkRealm();
        ClientModel client = this.authenticateClient();
        AuthorizationEndpointRequest request = AuthorizationEndpointRequestParserProcessor.parseRequest(this.event, this.session, client, (MultivaluedMap<String, String>)this.httpRequest.getDecodedFormParameters());
        if (!TokenUtil.isOIDCRequest((String)request.getScope())) {
            ServicesLogger.LOGGER.oidcScopeMissing();
        }
        CacheControlUtil.noBackButtonCacheControlHeader();
        if (!this.realm.getOAuth2DeviceConfig().isOAuth2DeviceAuthorizationGrantEnabled(client)) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed for OAuth 2.0 Device Authorization Grant", Response.Status.BAD_REQUEST);
        }
        int expiresIn = this.realm.getOAuth2DeviceConfig().getLifespan(client);
        int interval = this.realm.getOAuth2DeviceConfig().getPoolingInterval(client);
        OAuth2DeviceCodeModel deviceCode = OAuth2DeviceCodeModel.create((RealmModel)this.realm, (ClientModel)client, (String)Base64Url.encode((byte[])KeycloakModelUtils.generateSecret()), (String)request.getScope(), (String)request.getNonce(), (int)expiresIn, (int)interval, null, null, request.getAdditionalReqParams());
        OAuth2DeviceUserCodeProvider userCodeProvider = (OAuth2DeviceUserCodeProvider)this.session.getProvider(OAuth2DeviceUserCodeProvider.class);
        String secret = userCodeProvider.generate();
        OAuth2DeviceUserCodeModel userCode = new OAuth2DeviceUserCodeModel(this.realm, deviceCode.getDeviceCode(), secret);
        int lifespanSeconds = expiresIn + interval + 10;
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        store.put(deviceCode, userCode, lifespanSeconds);
        try {
            String deviceUrl = DeviceGrantType.oauth2DeviceVerificationUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString();
            OAuth2DeviceAuthorizationResponse response = new OAuth2DeviceAuthorizationResponse();
            response.setDeviceCode(deviceCode.getDeviceCode());
            response.setUserCode(userCodeProvider.display(secret));
            response.setExpiresIn((long)expiresIn);
            response.setInterval((long)interval);
            response.setVerificationUri(deviceUrl);
            response.setVerificationUriComplete(deviceUrl + "?user_code=" + response.getUserCode());
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)response)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating OAuth 2.0 Device Authorization Response.", e);
        }
    }

    @GET
    public Response verifyUserCode(@QueryParam(value="user_code") String userCode) {
        OAuth2DeviceUserCodeProvider userCodeProvider;
        String formattedUserCode;
        this.event.event(EventType.OAUTH2_DEVICE_VERIFY_USER_CODE);
        this.checkSsl();
        this.checkRealm();
        CacheControlUtil.noBackButtonCacheControlHeader();
        if (StringUtil.isNullOrEmpty((String)userCode)) {
            return this.createVerificationPage(null);
        }
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        OAuth2DeviceCodeModel deviceCode = store.getByUserCode(this.realm, formattedUserCode = (userCodeProvider = (OAuth2DeviceUserCodeProvider)this.session.getProvider(OAuth2DeviceUserCodeProvider.class)).format(userCode));
        if (deviceCode == null) {
            this.event.error("invalid_oauth2_user_code");
            return this.createVerificationPage("oauth2DeviceInvalidUserCodeMessage");
        }
        if (deviceCode.isExpired()) {
            this.event.error("invalid_oauth2_user_code");
            return this.createVerificationPage("oauth2DeviceExpiredUserCodeMessage");
        }
        return this.processVerification(deviceCode, formattedUserCode);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response verifyUserCode() {
        MultivaluedMap formData = this.httpRequest.getDecodedFormParameters();
        return this.verifyUserCode((String)formData.getFirst((Object)"device_user_code"));
    }

    @Path(value="status")
    @GET
    public Response status(@QueryParam(value="error") String error) {
        if (!StringUtil.isNullOrEmpty((String)error)) {
            String message;
            switch (error) {
                case "access_denied": {
                    message = "oauth2DeviceConsentDeniedMessage";
                    break;
                }
                case "expired_token": {
                    message = "oauth2DeviceExpiredUserCodeMessage";
                    break;
                }
                default: {
                    message = "oauth2DeviceVerificationFailedMessage";
                }
            }
            LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
            String restartUri = DeviceGrantType.oauth2DeviceVerificationUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString();
            return forms.setAttribute("messageHeader", (Object)forms.getMessage("oauth2DeviceVerificationFailedHeader")).setAttribute("actionUri", (Object)restartUri).setError(message, new Object[0]).createInfoPage();
        }
        LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        return forms.setAttribute("messageHeader", (Object)forms.getMessage("oauth2DeviceVerificationCompleteHeader")).setAttribute("skipLink", (Object)true).setSuccess("oauth2DeviceVerificationCompleteMessage", new Object[0]).createInfoPage();
    }

    private Response createVerificationPage(String errorMessage) {
        String execution = CommonClientSessionModel.Action.USER_CODE_VERIFICATION.name();
        LoginFormsProvider provider = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setExecution(execution);
        if (errorMessage != null) {
            provider = provider.setError(errorMessage, new Object[0]);
        }
        return provider.createOAuth2DeviceVerifyUserCodePage();
    }

    private Response processVerification(OAuth2DeviceCodeModel deviceCode, String userCode) {
        long expiresIn = deviceCode.getExpiration() - Time.currentTime();
        if (expiresIn < 0L) {
            this.event.error("expired_oauth2_user_code");
            return this.createVerificationPage("oauth2DeviceInvalidUserCodeMessage");
        }
        ClientModel client = this.realm.getClientByClientId(deviceCode.getClientId());
        AuthenticationSessionModel authenticationSession = this.createAuthenticationSession(client);
        authenticationSession.setClientNote("OAUTH2_DEVICE_VERIFIED_USER_CODE", userCode);
        this.event.client(deviceCode.getClientId()).detail("scope", deviceCode.getScope()).success();
        OIDCLoginProtocol protocol = new OIDCLoginProtocol(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.headers, this.event);
        return this.handleBrowserAuthenticationRequest(authenticationSession, protocol, false, true);
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    private ClientModel authenticateClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, null);
        ClientModel client = clientAuth.getClient();
        if (client == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "missingParameterMessage", "client_id");
        }
        this.checkClient(client.getClientId());
        return client;
    }

    private ClientModel checkClient(String clientId) {
        if (clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "missingParameterMessage", "client_id");
        }
        this.event.client(clientId);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
        }
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "clientDisabledMessage", new Object[0]);
        }
        if (!this.realm.getOAuth2DeviceConfig().isOAuth2DeviceAuthorizationGrantEnabled(client)) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "oauth2DeviceAuthorizationGrantDisabledMessage", new Object[0]);
        }
        if (client.isBearerOnly()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, null, Response.Status.FORBIDDEN, "bearerOnlyMessage", new Object[0]);
        }
        String protocol = client.getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)clientId);
            protocol = "openid-connect";
        }
        if (!protocol.equals("openid-connect")) {
            this.event.error("invalid_client");
            throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "Wrong client protocol.", new Object[0]);
        }
        this.session.getContext().setClient(client);
        return client;
    }

    protected AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        AuthenticationSessionModel authenticationSession = super.createAuthenticationSession(client, null);
        authenticationSession.setProtocol("openid-connect");
        authenticationSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authenticationSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        return authenticationSession;
    }
}

