/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class ConsentRequiredExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        ClientCRUDContext clientUpdateContext = null;
        switch (context.getEvent()) {
            case REGISTERED: {
                clientUpdateContext = (ClientCRUDContext)context;
                this.afterRegister(clientUpdateContext.getTargetClient());
                break;
            }
            case UPDATE: {
                clientUpdateContext = (ClientCRUDContext)context;
                this.beforeUpdate(clientUpdateContext.getTargetClient(), clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            default: {
                return;
            }
        }
    }

    public String getProviderId() {
        return "consent-required";
    }

    private void afterRegister(ClientModel clientModel) {
        clientModel.setConsentRequired(true);
    }

    public void beforeUpdate(ClientModel clientToBeUpdated, ClientRepresentation proposedClient) throws ClientPolicyException {
        if (proposedClient.isConsentRequired() == null) {
            return;
        }
        if (clientToBeUpdated == null) {
            return;
        }
        boolean isConsentRequired = clientToBeUpdated.isConsentRequired();
        boolean newConsentRequired = proposedClient.isConsentRequired();
        if (isConsentRequired && !newConsentRequired) {
            throw new ClientPolicyException("invalid_registration", "Not permitted to update consentRequired to false");
        }
    }
}

