/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureClientUrisExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private static final Logger logger = Logger.getLogger(SecureClientUrisExecutor.class);
    private final KeycloakSession session;

    public SecureClientUrisExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-client-uris";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (!(context instanceof AdminClientRegisterContext) && !(context instanceof DynamicClientRegisterContext)) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.confirmSecureUris(((ClientCRUDContext)context).getProposedClientRepresentation());
                return;
            }
            case UPDATE: {
                if (!(context instanceof AdminClientUpdateContext) && !(context instanceof DynamicClientUpdateContext)) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.confirmSecureUris(((ClientCRUDContext)context).getProposedClientRepresentation());
                return;
            }
            case AUTHORIZATION_REQUEST: {
                this.confirmSecureRedirectUri(((AuthorizationRequestContext)context).getRedirectUri());
                return;
            }
        }
    }

    private void confirmSecureUris(ClientRepresentation clientRep) throws ClientPolicyException {
        String clientNotificationEndpoint;
        List<String> requestUris;
        String jwksUri;
        List redirectUris;
        String logoutUrl;
        List webOrigins;
        String baseUrl;
        String adminUrl;
        String rootUrl = clientRep.getRootUrl();
        if (rootUrl != null) {
            this.confirmSecureUris(Arrays.asList(rootUrl), "rootUrl");
        }
        if ((adminUrl = clientRep.getAdminUrl()) != null) {
            this.confirmSecureUris(Arrays.asList(adminUrl), "adminUrl");
        }
        if ((baseUrl = clientRep.getBaseUrl()) != null) {
            this.confirmSecureUris(Arrays.asList(baseUrl), "baseUrl");
        }
        if ((webOrigins = clientRep.getWebOrigins()) != null) {
            this.confirmSecureUris(webOrigins, "webOrigins");
        }
        if ((logoutUrl = (String)Optional.ofNullable(clientRep.getAttributes()).orElse(Collections.emptyMap()).get("backchannel.logout.url")) != null) {
            this.confirmSecureUris(Arrays.asList(logoutUrl), "logoutUrl");
        }
        if ((redirectUris = clientRep.getRedirectUris()) != null) {
            this.confirmSecureUris(redirectUris, "redirectUris");
        }
        if ((jwksUri = (String)Optional.ofNullable(clientRep.getAttributes()).orElse(Collections.emptyMap()).get("jwks.url")) != null) {
            this.confirmSecureUris(Arrays.asList(jwksUri), "jwksUri");
        }
        if ((requestUris = this.getAttributeMultivalued(clientRep, "request.uris")) != null) {
            this.confirmSecureUris(requestUris, "requestUris");
        }
        if ((clientNotificationEndpoint = (String)Optional.ofNullable(clientRep.getAttributes()).orElse(Collections.emptyMap()).get("ciba.backchannel.client.notification.endpoint")) != null) {
            this.confirmSecureUris(Arrays.asList(clientNotificationEndpoint), "cibaClientNotificationEndpoint");
        }
    }

    private List<String> getAttributeMultivalued(ClientRepresentation clientRep, String attrKey) {
        String attrValue = (String)Optional.ofNullable(clientRep.getAttributes()).orElse(Collections.emptyMap()).get(attrKey);
        if (attrValue == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(attrValue));
    }

    private void confirmSecureUris(List<String> uris, String uriType) throws ClientPolicyException {
        if (uris == null || uris.isEmpty()) {
            return;
        }
        for (String uri : uris) {
            logger.tracev("{0} = {1}", (Object)uriType, (Object)uri);
            if (uri.startsWith("https://") && !uri.contains("*")) continue;
            throw new ClientPolicyException("invalid_client_metadata", "Invalid " + uriType);
        }
    }

    private void confirmSecureRedirectUri(String redirectUri) throws ClientPolicyException {
        if (redirectUri == null || redirectUri.isEmpty()) {
            throw new ClientPolicyException("invalid_request", "no redirect_uri specified.");
        }
        logger.tracev("Redirect URI = {0}", (Object)redirectUri);
        if (!redirectUri.startsWith("https://") || redirectUri.contains("*")) {
            throw new ClientPolicyException("invalid_request", "Invalid redirect_uri");
        }
    }
}

