/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster.impl.selector;

import io.vertx.core.Promise;
import io.vertx.core.spi.cluster.impl.selector.RoundRobinSelector;
import io.vertx.core.spi.cluster.impl.selector.SimpleRoundRobinSelector;
import io.vertx.core.spi.cluster.impl.selector.WeightedRoundRobinSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SelectorEntry {
    final RoundRobinSelector selector;
    final Promise<RoundRobinSelector> selectorPromise;
    final int counter;

    SelectorEntry() {
        this.selector = null;
        this.selectorPromise = Promise.promise();
        this.counter = 0;
    }

    private SelectorEntry(RoundRobinSelector selector, Promise<RoundRobinSelector> selectorPromise, int counter) {
        this.selector = selector;
        this.selectorPromise = selectorPromise;
        this.counter = counter;
    }

    SelectorEntry increment() {
        return new SelectorEntry(null, this.selectorPromise, this.counter + 1);
    }

    SelectorEntry data(List<String> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return null;
        }
        Map<String, Integer> weights = this.computeWeights(nodeIds);
        RoundRobinSelector selector = this.isEvenlyDistributed(weights) ? new SimpleRoundRobinSelector(new ArrayList<String>(weights.keySet())) : new WeightedRoundRobinSelector(weights);
        return new SelectorEntry(selector, this.selectorPromise, this.counter);
    }

    private Map<String, Integer> computeWeights(List<String> nodeIds) {
        HashMap<String, Integer> weights = new HashMap<String, Integer>();
        for (String nodeId : nodeIds) {
            weights.merge(nodeId, 1, Math::addExact);
        }
        return weights;
    }

    private boolean isEvenlyDistributed(Map<String, Integer> weights) {
        return weights.values().stream().distinct().count() == 1L;
    }

    boolean shouldInitialize() {
        return this.counter == 0;
    }

    boolean isNotReady() {
        return this.selector == null;
    }
}

