/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import org.jboss.aerogear.keycloak.metrics.PrometheusExporter;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;

public class MetricsEventListener
implements EventListenerProvider {
    public static final String ID = "metrics-listener";
    private static final Logger logger = Logger.getLogger(MetricsEventListener.class);

    public void onEvent(Event event) {
        this.logEventDetails(event);
        switch (event.getType()) {
            case LOGIN: {
                PrometheusExporter.instance().recordLogin(event);
                break;
            }
            case CLIENT_LOGIN: {
                PrometheusExporter.instance().recordClientLogin(event);
                break;
            }
            case REGISTER: {
                PrometheusExporter.instance().recordRegistration(event);
                break;
            }
            case REFRESH_TOKEN: {
                PrometheusExporter.instance().recordRefreshToken(event);
                break;
            }
            case CODE_TO_TOKEN: {
                PrometheusExporter.instance().recordCodeToToken(event);
                break;
            }
            case REGISTER_ERROR: {
                PrometheusExporter.instance().recordRegistrationError(event);
                break;
            }
            case LOGIN_ERROR: {
                PrometheusExporter.instance().recordLoginError(event);
                break;
            }
            case CLIENT_LOGIN_ERROR: {
                PrometheusExporter.instance().recordClientLoginError(event);
                break;
            }
            case REFRESH_TOKEN_ERROR: {
                PrometheusExporter.instance().recordRefreshTokenError(event);
                break;
            }
            case CODE_TO_TOKEN_ERROR: {
                PrometheusExporter.instance().recordCodeToTokenError(event);
                break;
            }
            default: {
                PrometheusExporter.instance().recordGenericEvent(event);
            }
        }
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        this.logAdminEventDetails(event);
        PrometheusExporter.instance().recordGenericAdminEvent(event);
    }

    private void logEventDetails(Event event) {
        logger.debugf("Received user event of type %s in realm %s", (Object)event.getType().name(), (Object)event.getRealmId());
    }

    private void logAdminEventDetails(AdminEvent event) {
        logger.debugf("Received admin event of type %s (%s) in realm %s", (Object)event.getOperationType().name(), (Object)event.getResourceType().name(), (Object)event.getRealmId());
    }

    public void close() {
    }
}

