/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;

class ResourceExtractor {
    private static final Logger logger = Logger.getLogger(ResourceExtractor.class);
    private static final boolean IS_RESOURCE_SCRAPING_DISABLED = Boolean.getBoolean("RESOURCE_SCRAPING_DISABLED");
    private static final boolean URI_METRICS_ENABLED = Boolean.getBoolean("URI_METRICS_ENABLED");
    private static final boolean URI_METRICS_DETAILED = Boolean.getBoolean("URI_METRICS_DETAILED");

    private ResourceExtractor() {
    }

    static String getResource(UriInfo uriInfo) {
        List matchedURIs;
        if (!IS_RESOURCE_SCRAPING_DISABLED && (matchedURIs = uriInfo.getMatchedURIs()).size() >= 2) {
            if ("resources".equals(matchedURIs.get(matchedURIs.size() - 1))) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append((String)matchedURIs.get(matchedURIs.size() - 1));
            sb.append(",");
            sb.append((String)matchedURIs.get(matchedURIs.size() - 2));
            return sb.toString();
        }
        return "";
    }

    static String getURI(UriInfo uriInfo) {
        if (URI_METRICS_ENABLED) {
            List matchedURIs = uriInfo.getMatchedURIs();
            StringBuilder sb = new StringBuilder();
            if (((String)matchedURIs.get(0)).contains("/token")) {
                String uri = (String)matchedURIs.get(0);
                if (URI_METRICS_DETAILED) {
                    sb.append(uri);
                } else {
                    String[] realm = uri.split("/");
                    uri = uri.replace(realm[1], "{realm}");
                    sb.append(uri);
                }
            }
            return sb.toString();
        }
        return "";
    }
}

