"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiNavDrawer = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _list_group = require("../list_group");

var _nav_drawer_flyout = require("./nav_drawer_flyout");

var _nav_drawer_group = require("./nav_drawer_group");

var _outside_click_detector = require("../outside_click_detector");

var _i18n = require("../i18n");

var _flex = require("../flex");

var _utils = require("../color_picker/utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var MENU_ELEMENT_ID = 'navDrawerMenu';

var EuiNavDrawer = /*#__PURE__*/function (_Component) {
  _inherits(EuiNavDrawer, _Component);

  var _super = _createSuper(EuiNavDrawer);

  function EuiNavDrawer() {
    var _this;

    _classCallCheck(this, EuiNavDrawer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      flyoutIsCollapsed: true,
      flyoutListItems: null,
      focusReturnRef: null,
      isCollapsed: !_this.props.isLocked,
      isLocked: Boolean(_this.props.isLocked),
      isManagingFocus: false,
      navFlyoutTitle: undefined,
      outsideClickDisabled: true,
      toolTipsEnabled: true
    });

    _defineProperty(_assertThisInitialized(_this), "expandButtonRef", /*#__PURE__*/(0, _react.createRef)());

    _defineProperty(_assertThisInitialized(_this), "returnOnIsLockedUpdate", function (isLockedState) {
      if (_this.props.onIsLockedUpdate) {
        _this.props.onIsLockedUpdate(isLockedState);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "functionToCallOnWindowResize", (0, _utils.throttle)(function () {
      if (window.innerWidth < 1200) {
        _this.collapseDrawer();

        _this.collapseFlyout();
      } // reacts every 50ms to resize changes and always gets the final update

    }, 50));

    _defineProperty(_assertThisInitialized(_this), "sideNavLockClicked", function () {
      var isLocked = _this.state.isLocked;

      if (isLocked) {
        window.removeEventListener('resize', _this.functionToCallOnWindowResize);
      } else {
        window.addEventListener('resize', _this.functionToCallOnWindowResize);
      }

      _this.returnOnIsLockedUpdate(!isLocked);

      _this.setState({
        isLocked: !isLocked,
        isCollapsed: false,
        outsideClickDisabled: !isLocked
      });
    });

    _defineProperty(_assertThisInitialized(_this), "toggleOpen", function () {
      _this.setState(function (_ref) {
        var isCollapsed = _ref.isCollapsed;
        return {
          isCollapsed: !isCollapsed
        };
      }, function () {
        _this.setState(function (_ref2) {
          var isCollapsed = _ref2.isCollapsed;
          return {
            outsideClickDisabled: isCollapsed,
            toolTipsEnabled: isCollapsed
          };
        });
      });
    });

    _defineProperty(_assertThisInitialized(_this), "collapseButtonClick", function () {
      if (_this.state.isCollapsed) {
        _this.expandDrawer();
      } else {
        _this.collapseDrawer();
      }

      _this.collapseFlyout();

      requestAnimationFrame(function () {
        if (_this.expandButtonRef.current) {
          _this.expandButtonRef.current.focus();
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "expandDrawer", function () {
      _this.setState({
        isCollapsed: false,
        outsideClickDisabled: false
      });

      setTimeout(function () {
        _this.setState({
          toolTipsEnabled: false
        });
      }, 150);
    });

    _defineProperty(_assertThisInitialized(_this), "collapseDrawer", function () {
      _this.setState({
        isCollapsed: true,
        outsideClickDisabled: _this.state.flyoutIsCollapsed ? true : false,
        toolTipsEnabled: true,
        isLocked: false
      });

      _this.returnOnIsLockedUpdate(false); // Scrolls the menu and flyout back to top when the nav drawer collapses


      setTimeout(function () {
        var element = document.getElementById('navDrawerMenu');

        if (element) {
          element.scrollTop = 0;
        }
      }, 50); // In case it was locked before, remove the window resize listener

      window.removeEventListener('resize', _this.functionToCallOnWindowResize);
    });

    _defineProperty(_assertThisInitialized(_this), "expandFlyout", function (links, title, item) {
      if (_this.state.navFlyoutTitle === title) {
        _this.collapseFlyout();
      } else {
        _this.setState(function (_ref3) {
          var isLocked = _ref3.isLocked;
          return {
            flyoutIsCollapsed: false,
            flyoutListItems: links,
            focusReturnRef: item.label,
            isCollapsed: isLocked ? false : true,
            navFlyoutTitle: title,
            outsideClickDisabled: false,
            toolTipsEnabled: false
          };
        }, function () {
          // Ideally this uses React `ref` instead of `querySelector`, but the menu composition
          // does not allow for deep `ref` element management at present
          var element = document.querySelector("#".concat(MENU_ELEMENT_ID, " [").concat(_nav_drawer_group.ATTR_SELECTOR, "='").concat(item.label, "']"));
          if (!element) return;
          element.setAttribute('aria-expanded', 'true');
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "collapseFlyout", function () {
      var shouldReturnFocus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var focusReturn = _this.state.focusReturnRef;

      _this.setState({
        flyoutIsCollapsed: true,
        navFlyoutTitle: undefined,
        flyoutListItems: null,
        toolTipsEnabled: _this.state.isLocked ? false : true,
        focusReturnRef: null
      }, function () {
        // Ideally this uses React `ref` instead of `querySelector`, but the menu composition
        // does not allow for deep `ref` element management at present
        var element = document.querySelector("#".concat(MENU_ELEMENT_ID, " [").concat(_nav_drawer_group.ATTR_SELECTOR, "='").concat(focusReturn, "']"));

        if (!element) {
          return;
        }

        requestAnimationFrame(function () {
          element.setAttribute('aria-expanded', 'false');
        });
        if (!shouldReturnFocus) return;
        requestAnimationFrame(function () {
          element.focus();
        });
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeBoth", function () {
      if (!_this.state.isLocked) _this.collapseDrawer();

      _this.collapseFlyout(false);
    });

    _defineProperty(_assertThisInitialized(_this), "handleDrawerMenuClick", function (event) {
      // walk up e.target until either:
      // 1. a[href] - close the menu
      // 2. document.body - do nothing
      var element = event.target;

      while (element !== null && element !== document.body && (element.tagName !== 'A' || element.getAttribute('href') === undefined)) {
        element = element.parentElement;
      }

      if (element !== document.body) {
        // this is an anchor with an href
        _this.closeBoth();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "modifyChildren", function (children) {
      // Loop through the EuiNavDrawer children (EuiListGroup, EuiHorizontalRules, etc)
      // Filter out falsy items
      var filteredChildren = _react.default.Children.toArray(children);

      return _react.default.Children.map(filteredChildren, function (child) {
        if ( /*#__PURE__*/(0, _react.isValidElement)(child)) {
          // Allow for Fragments by recursive modification
          if (child.type === _react.default.Fragment) {
            return _this.modifyChildren(child.props.children);
          } // Check if child is an EuiNavDrawerGroup and if it does have a flyout, add the expand function


          if (child.type === _nav_drawer_group.EuiNavDrawerGroup) {
            return /*#__PURE__*/_react.default.cloneElement(child, {
              flyoutMenuButtonClick: _this.expandFlyout,
              showToolTips: _this.state.toolTipsEnabled && _this.props.showToolTips
            });
          }
        }

        return child;
      });
    });

    return _this;
  }

  _createClass(EuiNavDrawer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.isLocked) {
        window.addEventListener('resize', this.functionToCallOnWindowResize);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this.functionToCallOnWindowResize);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          showExpandButton = _this$props.showExpandButton,
          showToolTips = _this$props.showToolTips,
          isLocked = _this$props.isLocked,
          onIsLockedUpdate = _this$props.onIsLockedUpdate,
          rest = _objectWithoutProperties(_this$props, ["children", "className", "showExpandButton", "showToolTips", "isLocked", "onIsLockedUpdate"]);

      var classes = (0, _classnames.default)('euiNavDrawer', {
        'euiNavDrawer-isCollapsed': this.state.isCollapsed,
        'euiNavDrawer-isExpanded': !this.state.isCollapsed,
        'euiNavDrawer-isLocked': this.state.isLocked,
        'euiNavDrawer-flyoutIsCollapsed': this.state.flyoutIsCollapsed,
        'euiNavDrawer-flyoutIsExpanded': !this.state.flyoutIsCollapsed
      }, className);
      var footerContent;

      if (showExpandButton) {
        footerContent = /*#__PURE__*/_react.default.createElement(_list_group.EuiListGroup, {
          className: "euiNavDrawer__expandButton",
          flush: true
        }, /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
          tokens: ['euiNavDrawer.sideNavCollapse', 'euiNavDrawer.sideNavExpand', 'euiNavDrawer.sideNavLockAriaLabel', 'euiNavDrawer.sideNavLockExpanded', 'euiNavDrawer.sideNavLockCollapsed'],
          defaults: ['Collapse', 'Expand', 'Dock navigation', 'Navigation is docked', 'Navigation is undocked']
        }, function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 5),
              sideNavCollapse = _ref5[0],
              sideNavExpand = _ref5[1],
              sideNavLockAriaLabel = _ref5[2],
              sideNavLockExpanded = _ref5[3],
              sideNavLockCollapsed = _ref5[4];

          return /*#__PURE__*/_react.default.createElement(_list_group.EuiListGroupItem, {
            buttonRef: _this2.expandButtonRef,
            className: _this2.state.isCollapsed ? 'navDrawerExpandButton-isCollapsed' : 'navDrawerExpandButton-isExpanded',
            "data-test-subj": _this2.state.isCollapsed ? 'navDrawerExpandButton-isCollapsed' : 'navDrawerExpandButton-isExpanded',
            extraAction: {
              'aria-label': sideNavLockAriaLabel,
              'aria-pressed': _this2.state.isLocked ? true : false,
              className: 'euiNavDrawer__expandButtonLockAction',
              color: 'text',
              iconType: _this2.state.isLocked ? 'lock' : 'lockOpen',
              iconSize: 's',
              onClick: _this2.sideNavLockClicked,
              title: _this2.state.isLocked ? sideNavLockExpanded : sideNavLockCollapsed
            },
            iconType: _this2.state.isCollapsed ? 'menuRight' : 'menuLeft',
            label: _this2.state.isCollapsed ? sideNavExpand : sideNavCollapse,
            onClick: _this2.collapseButtonClick,
            showToolTip: _this2.state.isCollapsed,
            size: "s"
          });
        }));
      }

      var flyoutContent = /*#__PURE__*/_react.default.createElement(_nav_drawer_flyout.EuiNavDrawerFlyout, {
        id: "navDrawerFlyout",
        isCollapsed: this.state.flyoutIsCollapsed,
        listItems: this.state.flyoutListItems,
        onClose: this.collapseFlyout,
        title: this.state.navFlyoutTitle,
        wrapText: true
      }); // Add an onClick that expands the flyout sub menu for any list items (links) that have a flyoutMenu prop (sub links)


      var modifiedChildren = children;
      modifiedChildren = this.modifyChildren(this.props.children);
      var menuClasses = (0, _classnames.default)('euiNavDrawerMenu', {
        'euiNavDrawerMenu-hasFooter': footerContent
      });
      return /*#__PURE__*/_react.default.createElement(_outside_click_detector.EuiOutsideClickDetector, {
        onOutsideClick: function onOutsideClick() {
          return _this2.closeBoth();
        },
        isDisabled: this.state.outsideClickDisabled
      }, /*#__PURE__*/_react.default.createElement("nav", _extends({
        className: classes
      }, rest), /*#__PURE__*/_react.default.createElement(_flex.EuiFlexGroup, {
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: MENU_ELEMENT_ID,
        className: menuClasses,
        onClick: this.handleDrawerMenuClick
      }, footerContent, modifiedChildren)), flyoutContent)));
    }
  }]);

  return EuiNavDrawer;
}(_react.Component);

exports.EuiNavDrawer = EuiNavDrawer;

_defineProperty(EuiNavDrawer, "defaultProps", {
  showExpandButton: true,
  showToolTips: true
});

EuiNavDrawer.propTypes = {
  /**
     * One or more ReactNodes to render as this component's content
     */
  children: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),

  /**
     * Keep drawer locked open by default
     */
  isLocked: _propTypes.default.bool,

  /**
     * Returns the current state of isLocked
     */
  onIsLockedUpdate: _propTypes.default.func,

  /**
     * Adds fixed toggle button to bottom of menu area
     */
  showExpandButton: _propTypes.default.bool,

  /**
     * Display tooltips on side nav items
     */
  showToolTips: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};