/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Pattern;
import morfologik.tools.DictDecompile;
import morfologik.tools.FSADecompile;
import org.apache.commons.cli.CommandLine;
import org.languagetool.tools.BuilderOptions;
import org.languagetool.tools.DictionaryBuilder;

final class DictionaryExporter
extends DictionaryBuilder {
    protected DictionaryExporter(File infoFile) throws IOException {
        super(infoFile);
    }

    public static void main(String[] args) throws Exception {
        BuilderOptions builderOptions = new BuilderOptions();
        builderOptions.addOption("i", true, "binary Morfologik dictionary file (.dict)", true);
        builderOptions.addOption("info", true, "*.info properties file, see https://dev.languagetool.org/developing-a-tagger-dictionary", true);
        CommandLine cmdLine = builderOptions.parseArguments(args, DictionaryExporter.class);
        File binaryDictFile = new File(cmdLine.getOptionValue("i"));
        File infoFile = new File(cmdLine.getOptionValue("info"));
        DictionaryExporter builder = new DictionaryExporter(infoFile);
        builder.setOutputFilename(cmdLine.getOptionValue("o"));
        builder.build(binaryDictFile);
    }

    private void build(File binaryDictFile) throws RuntimeException, IOException {
        String inputPath = binaryDictFile.toString();
        File tmpOutputFile = File.createTempFile(DictionaryExporter.class.getSimpleName() + "_separator", ".txt");
        tmpOutputFile.deleteOnExit();
        if (inputPath.contains("hunspell") || inputPath.contains("spelling")) {
            Object[] buildOptions = new String[]{"--exit", "false", "-i", binaryDictFile.toString(), "-o", tmpOutputFile.toString()};
            System.out.println("Running Morfologik FSADecompile.main with these options: " + Arrays.toString(buildOptions));
            FSADecompile.main((String[])buildOptions);
        } else {
            Object[] buildOptions = new String[]{"--exit", "false", "-i", binaryDictFile.toString(), "-o", tmpOutputFile.toString()};
            System.out.println("Running Morfologik DictDecompile.main with these options: " + Arrays.toString(buildOptions));
            DictDecompile.main((String[])buildOptions);
        }
        this.outputSeparatorToTab(tmpOutputFile);
        System.out.println("Done. The dictionary export has been written to " + this.getOutputFilename());
    }

    protected void outputSeparatorToTab(File inputFile) throws RuntimeException, IOException {
        File outputFile = new File(this.getOutputFilename());
        String separator = this.getOption("fsa.dict.separator");
        if (separator == null || separator.trim().isEmpty()) {
            throw new IOException("A separator character (fsa.dict.separator) must be defined in the dictionary info file.");
        }
        boolean hasFrequency = this.isOptionTrue("fsa.dict.frequency-included");
        String encoding = this.getOption("fsa.dict.encoding");
        try (Scanner scanner = new Scanner(inputFile, encoding);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split(Pattern.quote(separator));
                if (parts.length == 3) {
                    if (hasFrequency) {
                        parts[2] = parts[2].substring(0, parts[2].length() - 1);
                    }
                    out.write(parts[1] + "\t" + parts[0] + "\t" + parts[2] + "\n");
                    continue;
                }
                if (parts.length == 2) {
                    if (hasFrequency) {
                        out.write(parts[1] + "\n");
                    }
                    out.write(parts[1] + "\t" + parts[0] + "\n");
                    continue;
                }
                if (parts.length == 1) {
                    out.write(parts[0]);
                    continue;
                }
                System.err.println("Invalid input, expected one, two or three columns separated with " + separator + " in " + inputFile + ": " + line + " => ignoring");
            }
        }
    }
}

