// D import file generated from 'src/core/sync/config.d'
module core.sync.config;
version (Posix)
{
	import core.sys.posix.pthread;
	import core.sys.posix.time;
	import core.sys.posix.sys.time;
	import core.time;
	nothrow @nogc void mktspec(ref timespec t)
	{
		static if (is(typeof(pthread_condattr_setclock)))
		{
			clock_gettime(CLOCK_MONOTONIC, &t);
		}
		else
		{
			timeval tv;
			gettimeofday(&tv, null);
			(cast(byte*)&t)[0..t.sizeof] = 0;
			t.tv_sec = cast(typeof(t.tv_sec))tv.tv_sec;
			t.tv_nsec = cast(typeof(t.tv_nsec))tv.tv_usec * 1000;
		}
	}
	nothrow @nogc void mktspec(ref timespec t, Duration delta)
	{
		mktspec(t);
		mvtspec(t, delta);
	}
	nothrow @nogc void mvtspec(ref timespec t, Duration delta)
	{
		auto val = delta;
		val += dur!"seconds"(t.tv_sec);
		val += dur!"nsecs"(t.tv_nsec);
		if (val.total!"seconds" > t.tv_sec.max)
		{
			t.tv_sec = t.tv_sec.max;
			t.tv_nsec = cast(typeof(t.tv_nsec))val.split!("seconds", "nsecs")().nsecs;
		}
		else
			val.split!("seconds", "nsecs")(t.tv_sec, t.tv_nsec);
	}
}
