/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import org.snmp4j.SecureTarget;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class UserTarget
extends SecureTarget {
    private static final long serialVersionUID = -1426511355567423746L;
    private OctetString authoritativeEngineID = new OctetString();

    public UserTarget() {
        this.setSecurityModel(3);
    }

    public UserTarget(Address address, OctetString securityName, byte[] authoritativeEngineID) {
        super(address, securityName);
        this.setAuthoritativeEngineID(authoritativeEngineID);
        this.setSecurityModel(3);
    }

    public UserTarget(Address address, OctetString securityName, byte[] authoritativeEngineID, int securityLevel) {
        super(address, securityName);
        this.setAuthoritativeEngineID(authoritativeEngineID);
        this.setSecurityLevel(securityLevel);
        this.setSecurityModel(3);
    }

    @Override
    public Target duplicate() {
        UserTarget copy = new UserTarget(this.getAddress(), this.securityName, this.authoritativeEngineID.getValue(), this.securityLevel);
        copy.setRetries(this.getRetries());
        copy.setTimeout(this.getTimeout());
        copy.setMaxSizeRequestPDU(this.getMaxSizeRequestPDU());
        copy.setSecurityModel(this.getSecurityModel());
        copy.setVersion(this.getVersion());
        copy.setPreferredTransports(this.getPreferredTransports());
        return copy;
    }

    public void setAuthoritativeEngineID(byte[] authoritativeEngineID) {
        this.authoritativeEngineID.setValue(authoritativeEngineID);
    }

    public byte[] getAuthoritativeEngineID() {
        return this.authoritativeEngineID.getValue();
    }

    @Override
    public String toString() {
        return "UserTarget[" + this.toStringAbstractTarget() + ", authoritativeEngineID=" + this.authoritativeEngineID + ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserTarget that = (UserTarget)o;
        return !(this.authoritativeEngineID != null ? !this.authoritativeEngineID.equals(that.authoritativeEngineID) : that.authoritativeEngineID != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.authoritativeEngineID != null ? this.authoritativeEngineID.hashCode() : 0);
        return result;
    }
}

