/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.DummyX509TrustManager;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.jsse.provider.SSLEngineUtil;
import org.bouncycastle.jsse.provider.X509KeyManagerUtil;
import org.bouncycastle.jsse.provider.X509TrustManagerUtil;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Logger LOG = Logger.getLogger(ProvSSLContextSpi.class.getName());
    private static final String PROPERTY_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String PROPERTY_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
    private static final Map<String, Integer> SUPPORTED_CIPHERSUITE_MAP = ProvSSLContextSpi.createSupportedCipherSuiteMap();
    private static final Map<String, Integer> SUPPORTED_CIPHERSUITE_MAP_FIPS = ProvSSLContextSpi.createSupportedCipherSuiteMapFips(SUPPORTED_CIPHERSUITE_MAP);
    private static final Map<String, ProtocolVersion> supportedProtocols = ProvSSLContextSpi.createSupportedProtocols();
    private static final List<String> DEFAULT_CIPHERSUITE_LIST = ProvSSLContextSpi.createDefaultCipherSuiteList(SUPPORTED_CIPHERSUITE_MAP.keySet());
    private static final List<String> DEFAULT_CIPHERSUITE_LIST_FIPS = ProvSSLContextSpi.createDefaultCipherSuiteListFips(DEFAULT_CIPHERSUITE_LIST);
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"TLSv1.2"};
    protected final boolean isInFipsMode;
    protected final TlsCryptoProvider cryptoProvider;
    protected final String[] defaultProtocolsClient;
    protected final String[] defaultProtocolsServer;
    protected final Map<String, Integer> supportedCipherSuites;
    protected final String[] defaultCipherSuites;
    protected boolean initialized = false;
    private TlsCrypto crypto;
    private X509ExtendedKeyManager x509KeyManager;
    private BCX509ExtendedTrustManager x509TrustManager;
    private ProvSSLSessionContext clientSessionContext;
    private ProvSSLSessionContext serverSessionContext;

    private static List<String> createDefaultCipherSuiteList(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        arrayList.retainAll(set);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static List<String> createDefaultCipherSuiteListFips(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        FipsUtils.removeNonFipsCipherSuites(arrayList);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static Map<String, Integer> createSupportedCipherSuiteMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(){

            @Override
            public Integer put(String string, Integer n) {
                if (null != super.put(string, n)) {
                    throw new IllegalStateException("Duplicate names in supported-cipher-suites");
                }
                return null;
            }
        };
        hashMap.put("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
        hashMap.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
        hashMap.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
        hashMap.put("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        hashMap.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
        hashMap.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
        hashMap.put("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        hashMap.put("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CCM", 49310);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CCM", 49311);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM", 49324);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM", 49325);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", 49327);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
        hashMap.put("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        hashMap.put("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        hashMap.put("TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
        hashMap.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10);
        hashMap.put("TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        hashMap.put("TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        hashMap.put("TLS_RSA_WITH_AES_128_CCM", 49308);
        hashMap.put("TLS_RSA_WITH_AES_128_CCM_8", 49312);
        hashMap.put("TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        hashMap.put("TLS_RSA_WITH_AES_256_CBC_SHA", 53);
        hashMap.put("TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
        hashMap.put("TLS_RSA_WITH_AES_256_CCM", 49309);
        hashMap.put("TLS_RSA_WITH_AES_256_CCM_8", 49313);
        hashMap.put("TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        hashMap.put("TLS_RSA_WITH_NULL_SHA", 2);
        hashMap.put("TLS_RSA_WITH_NULL_SHA256", 59);
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, Integer> createSupportedCipherSuiteMapFips(Map<String, Integer> map) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(map);
        FipsUtils.removeNonFipsCipherSuites(hashMap.keySet());
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocols() {
        HashMap<String, ProtocolVersion> hashMap = new HashMap<String, ProtocolVersion>();
        hashMap.put("TLSv1", ProtocolVersion.TLSv10);
        hashMap.put("TLSv1.1", ProtocolVersion.TLSv11);
        hashMap.put("TLSv1.2", ProtocolVersion.TLSv12);
        return Collections.unmodifiableMap(hashMap);
    }

    private static String[] getDefaultProtocols(String[] stringArray, String string) {
        if (stringArray != null) {
            return stringArray;
        }
        String[] stringArray2 = ProvSSLContextSpi.getJdkTlsProtocols(string);
        if (stringArray2 != null) {
            return stringArray2;
        }
        return DEFAULT_PROTOCOLS;
    }

    private static String[] getDefaultProtocolsClient(String[] stringArray) {
        return ProvSSLContextSpi.getDefaultProtocols(stringArray, PROPERTY_CLIENT_PROTOCOLS);
    }

    private static String[] getDefaultProtocolsServer(String[] stringArray) {
        return ProvSSLContextSpi.getDefaultProtocols(stringArray, PROPERTY_SERVER_PROTOCOLS);
    }

    private static String[] getJdkTlsProtocols(String string) {
        String string2 = PropertyUtils.getStringSystemProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = JsseUtils.stripDoubleQuotes(string2.trim()).split(",");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string3 : stringArray) {
            String string4 = string3.trim();
            if (string4.length() < 1) continue;
            if (!supportedProtocols.containsKey(string4)) {
                LOG.warning("'" + string + "' contains unsupported protocol: " + string4);
                continue;
            }
            if (JsseUtils.contains(stringArray2, string4)) continue;
            stringArray2[n++] = string4;
        }
        if (n < 1) {
            LOG.severe("'" + string + "' contained no usable protocol values (ignoring)");
            return null;
        }
        if (n < stringArray2.length) {
            stringArray2 = JsseUtils.copyOf(stringArray2, n);
        }
        return stringArray2;
    }

    private static String[] getArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private static String[] getKeysArray(Map<String, ?> map) {
        return ProvSSLContextSpi.getArray(map.keySet());
    }

    static KeyManager[] getDefaultKeyManagers() throws Exception {
        KeyStoreConfig keyStoreConfig = ProvKeyManagerFactorySpi.getDefaultKeyStore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStoreConfig.keyStore, keyStoreConfig.password);
        return keyManagerFactory.getKeyManagers();
    }

    static TrustManager[] getDefaultTrustManagers() throws Exception {
        KeyStore keyStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    ProvSSLContextSpi(boolean bl, TlsCryptoProvider tlsCryptoProvider, String[] stringArray) {
        this.isInFipsMode = bl;
        this.cryptoProvider = tlsCryptoProvider;
        this.defaultProtocolsClient = ProvSSLContextSpi.getDefaultProtocolsClient(stringArray);
        this.defaultProtocolsServer = ProvSSLContextSpi.getDefaultProtocolsServer(stringArray);
        this.supportedCipherSuites = bl ? SUPPORTED_CIPHERSUITE_MAP_FIPS : SUPPORTED_CIPHERSUITE_MAP;
        List<String> list = bl ? DEFAULT_CIPHERSUITE_LIST_FIPS : DEFAULT_CIPHERSUITE_LIST;
        this.defaultCipherSuites = ProvSSLContextSpi.getArray(list);
    }

    int[] convertCipherSuites(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.supportedCipherSuites.get(stringArray[i]);
        }
        return nArray;
    }

    ProvSSLSessionContext createSSLSessionContext() {
        return new ProvSSLSessionContext(this, this.crypto);
    }

    String getCipherSuiteString(int n) {
        if (0 == n) {
            return "TLS_NULL_WITH_NULL_NULL";
        }
        if (TlsUtils.isValidUint16(n)) {
            for (Map.Entry<String, Integer> entry : this.supportedCipherSuites.entrySet()) {
                if (entry.getValue() != n) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getDefaultCipherSuites() {
        return (String[])this.defaultCipherSuites.clone();
    }

    ProvSSLParameters getDefaultParameters(boolean bl) {
        return new ProvSSLParameters(this, this.defaultCipherSuites, this.getDefaultProtocols(bl));
    }

    String[] getDefaultProtocols(boolean bl) {
        return bl ? this.getDefaultProtocolsServer() : this.getDefaultProtocolsClient();
    }

    String[] getDefaultProtocolsClient() {
        return this.defaultProtocolsClient;
    }

    String[] getDefaultProtocolsServer() {
        return this.defaultProtocolsServer;
    }

    String getProtocolString(ProtocolVersion protocolVersion) {
        if (protocolVersion != null) {
            for (Map.Entry<String, ProtocolVersion> entry : supportedProtocols.entrySet()) {
                if (!protocolVersion.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    ProtocolVersion[] getSupportedVersions(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        TreeSet<ProtocolVersion> treeSet = new TreeSet<ProtocolVersion>(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2) {
                return protocolVersion.isLaterVersionOf(protocolVersion2) ? -1 : (protocolVersion2.isLaterVersionOf(protocolVersion) ? 1 : 0);
            }
        });
        for (String string : stringArray) {
            ProtocolVersion protocolVersion;
            if (string == null || (protocolVersion = supportedProtocols.get(string)) == null) continue;
            treeSet.add(protocolVersion);
        }
        return treeSet.toArray(new ProtocolVersion[treeSet.size()]);
    }

    boolean isDefaultProtocols(String[] stringArray) {
        return stringArray == this.getDefaultProtocolsClient() || stringArray == this.getDefaultProtocolsServer();
    }

    String[] getSupportedCipherSuites() {
        return ProvSSLContextSpi.getKeysArray(this.supportedCipherSuites);
    }

    String[] getSupportedProtocols() {
        return ProvSSLContextSpi.getKeysArray(supportedProtocols);
    }

    String[] getSupportedCipherSuites(String[] stringArray) {
        if (null == stringArray) {
            throw new NullPointerException("'cipherSuites' cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (null == string || string.length() < 1) {
                throw new IllegalArgumentException("'cipherSuites' cannot contain null or empty string elements");
            }
            if (!this.supportedCipherSuites.containsKey(string)) continue;
            arrayList.add(string);
        }
        return ProvSSLContextSpi.getArray(arrayList);
    }

    boolean isFips() {
        return this.isInFipsMode;
    }

    boolean isSupportedProtocols(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null && supportedProtocols.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    void updateDefaultProtocols(ProvSSLParameters provSSLParameters, boolean bl) {
        if (this.isDefaultProtocols(provSSLParameters.getProtocolsArray())) {
            provSSLParameters.setProtocolsArray(this.getDefaultProtocols(bl));
        }
    }

    void validateNegotiatedCipherSuite(int n) {
        String string = this.getCipherSuiteString(n);
        if (string == null || !this.supportedCipherSuites.containsKey(string) || this.isInFipsMode && !FipsUtils.isFipsCipherSuite(string)) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + n);
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        this.checkInitialized();
        return SSLEngineUtil.create(this, this.createContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String string, int n) {
        this.checkInitialized();
        return SSLEngineUtil.create(this, this.createContextData(), string, n);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        this.checkInitialized();
        return new ProvSSLServerSocketFactory(this);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        this.checkInitialized();
        return new ProvSSLSocketFactory(this);
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setCipherSuites(this.getSupportedCipherSuites());
        sSLParameters.setProtocols(this.getSupportedProtocols());
        return sSLParameters;
    }

    @Override
    protected synchronized void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.initialized = false;
        this.crypto = this.cryptoProvider.create(secureRandom);
        this.x509KeyManager = this.selectX509KeyManager(keyManagerArray);
        this.x509TrustManager = this.selectX509TrustManager(trustManagerArray);
        this.clientSessionContext = this.createSSLSessionContext();
        this.serverSessionContext = this.createSSLSessionContext();
        this.crypto.getSecureRandom().nextInt();
        this.initialized = true;
    }

    protected ContextData createContextData() {
        return new ContextData(this.crypto, this.x509KeyManager, this.x509TrustManager, this.clientSessionContext, this.serverSessionContext);
    }

    protected X509ExtendedKeyManager selectX509KeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        if (keyManagerArray != null) {
            for (KeyManager keyManager : keyManagerArray) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                return X509KeyManagerUtil.importX509KeyManager((X509KeyManager)keyManager);
            }
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected BCX509ExtendedTrustManager selectX509TrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        if (trustManagerArray == null) {
            try {
                TrustManager[] trustManagerArray2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerArray2.init((KeyStore)null);
                trustManagerArray = trustManagerArray2.getTrustManagers();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", exception);
            }
        }
        if (trustManagerArray != null) {
            for (TrustManager trustManager : trustManagerArray) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return X509TrustManagerUtil.importX509TrustManager((X509TrustManager)trustManager);
            }
        }
        return DummyX509TrustManager.INSTANCE;
    }
}

