/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsEdDSAVerifier
implements TlsVerifier {
    protected final JcaTlsCrypto crypto;
    protected final PublicKey publicKey;
    protected final short algorithmType;
    protected final String algorithmName;

    public JcaTlsEdDSAVerifier(JcaTlsCrypto jcaTlsCrypto, PublicKey publicKey, short s, String string) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = jcaTlsCrypto;
        this.publicKey = publicKey;
        this.algorithmType = s;
        this.algorithmName = string;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.algorithmType || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        final byte[] byArray = digitallySigned.getSignature();
        try {
            final Signature signature = this.crypto.getHelper().createSignature(this.algorithmName);
            signature.initVerify(this.publicKey);
            final OutputStream outputStream = OutputStreamFactory.createStream((Signature)signature);
            return new TlsStreamVerifier(){

                public OutputStream getOutputStream() throws IOException {
                    return outputStream;
                }

                public boolean isVerified() throws IOException {
                    try {
                        return signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new IOException(signatureException.getMessage());
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException(this.algorithmName + " verification failed", generalSecurityException);
        }
    }
}

