interface UserActivityMetadata {
    /**
     * The user is active in "private" rooms. Undefined if not.
     */
    private?: true;
    /**
     * The user was previously active, so we don't have a grace period.
     */
    active?: true;
}
export interface UserActivitySet {
    users: {
        [userId: string]: UserActivity;
    };
}
export declare namespace UserActivitySet {
    const DEFAULT: UserActivitySet;
}
export interface UserActivity {
    ts: number[];
    metadata: UserActivityMetadata;
}
export interface UserActivityTrackerConfig {
    inactiveAfterDays: number;
    minUserActiveDays: number;
}
export declare namespace UserActivityTrackerConfig {
    const DEFAULT: UserActivityTrackerConfig;
}
export interface UserActivityState {
    dataSet: UserActivitySet;
    changed: string[];
    activeUsers: number;
}
declare type ChangesCallback = (state: UserActivityState) => void;
export declare class UserActivityTracker {
    private readonly config;
    private readonly dataSet;
    private readonly onChanges?;
    constructor(config: UserActivityTrackerConfig, dataSet: UserActivitySet, onChanges?: ChangesCallback | undefined);
    updateUserActivity(userId: string, metadata?: UserActivityMetadata, dateOverride?: Date): void;
    countActiveUsers(dateNow?: Date): {
        allUsers: number;
        privateUsers: number;
    };
    getUserData(userId: string): UserActivity;
}
export {};
