# [![Mattermost](https://user-images.githubusercontent.com/33878967/33095422-7c8aa7a4-ceb8-11e7-810a-4b261fdff6d6.png)](https://mattermost.org)

Mattermost is an open source, private cloud, Slack-alternative from [https://mattermost.com](https://mattermost.com).

It's written in Golang and React and runs as a single Linux binary with MySQL or PostgreSQL. Every month on the 16th [a new compiled version is released under an MIT license](https://www.mattermost.com/download/).

- [Review product documentation](http://docs.mattermost.com/).
- [Review developer documentation](http://developers.mattermost.com/).
- [Download compiled version](https://mattermost.com/download).

<img width="1006" alt="screenshot at nov 29 14-11-32" src="https://user-images.githubusercontent.com/13119842/56807911-1bf66f00-67fe-11e9-9b7b-96ce9ceab645.png">

Table of Contents
=================

  * [Try out Mattermost](#try-out-mattermost)
  * [Deploy on Heroku](#deploy-on-heroku)
  * [Deploy on a Cloud Platform via Bitnami](#deploy-on-a-cloud-platform-via-bitnami)
  * [Install on Your Own Machine](#install-on-your-own-machine)
  * [Native Mobile and Desktop Apps](#native-mobile-and-desktop-apps)
  * [Get Security Bulletins](#get-security-bulletins)
  * [Get Involved](#get-involved)
  * [Learn More](#learn-more)
  * [Get the Latest News](#get-the-latest-news)
  * [Contributing](#contributing)

## Try out Mattermost

- [Join the Mattermost Contributor's server](https://community.mattermost.com/signup_user_complete/?id=codoy5s743rq5mk18i7u5ksz7e) to join community discussions about contributions, development and more
- [Get started with Mattermost Cloud](https://customers.mattermost.com/cloud/signup) to try out Mattermost

## Deploy on Heroku

[![Deploy a Preview](https://www.herokucdn.com/deploy/button.svg)](https://heroku.com/deploy?template=https://github.com/mattermost/mattermost-heroku)

_Note: Heroku preview does not include email or persistent storage_

## Deploy on a Cloud Platform via Bitnami

[Auto-deploy Mattermost](https://mattermost.com/download/#bitnami) to Amazon Web Services, Azure, Google Cloud Platform, or Oracle Cloud Platform via Bitnami.

## Install on Your Own Machine

- [One-line Docker Preview](http://docs.mattermost.com/install/docker-local-machine.html#one-line-docker-install)
- [Developer Machine Setup](https://developers.mattermost.com/contribute/server/developer-setup)
- [Production Install Guides using Linux Binary](https://mattermost.com/download/)
- [Production Docker Install](https://docs.mattermost.com/install/prod-docker.html)

## Native Mobile and Desktop Apps

In addition to the web interface, you can also download Mattermost clients for [Android](https://play.google.com/store/apps/details?id=com.mattermost.rn), [iOS](https://itunes.apple.com/us/app/mattermost/id1257222717?mt=8), [Windows PC](https://docs.mattermost.com/install/desktop.html#windows-10-windows-8-1-windows-7), [Mac OSX](https://docs.mattermost.com/install/desktop.html#macos-10-9), and [Linux](https://docs.mattermost.com/install/desktop.html#linux).

[![Google Play](https://user-images.githubusercontent.com/33878967/33095356-39b6fbf8-ceb8-11e7-8a61-c3a18fa5e658.png)](https://play.google.com/store/apps/details?id=com.mattermost.rn)  [![App Store](https://user-images.githubusercontent.com/33878967/33095353-397e69b4-ceb8-11e7-8175-f95a97d5274f.png)](https://itunes.apple.com/us/app/mattermost/id1257222717?mt=8)  [![Windows PC](https://user-images.githubusercontent.com/33878967/33095357-39cab8d2-ceb8-11e7-89a6-67dccc571ca3.png)](https://docs.mattermost.com/install/desktop.html#windows-10-windows-8-1-windows-7)  [![Mac OSX](https://user-images.githubusercontent.com/33878967/33095355-39a36f2a-ceb8-11e7-9b33-73d4f6d5d6c1.png)](https://docs.mattermost.com/install/desktop.html#macos-10-9)  [![Linux](https://user-images.githubusercontent.com/33878967/33095354-3990e256-ceb8-11e7-965d-b00a16e578de.png)](https://docs.mattermost.com/install/desktop.html#linux)

## Get Security Bulletins

Receive notifications of critical security updates. The sophistication of online attackers is perpetually increasing. If you are deploying Mattermost it is highly recommended you subscribe to the Mattermost Security Bulletin mailing list for updates on critical security releases.

- [Subscribe here](https://mattermost.com/blog/category/security-updates/)

## Get Involved

- [Contribute Code](https://developers.mattermost.com/contribute/getting-started/)
- [Find "Help Wanted" projects](https://github.com/mattermost/mattermost-server/issues?page=1&q=is%3Aissue+is%3Aopen+%22Help+Wanted%22&utf8=%E2%9C%93)
- [Join Developer Discussion on a Mattermost Server for contributors](https://community.mattermost.com/signup_user_complete/?id=f1924a8db44ff3bb41c96424cdc20676)
- [File Bugs](http://www.mattermost.org/filing-issues/)
- [Share Feature Ideas](https://www.mattermost.org/feature-ideas/)
- [Get Troubleshooting Help](https://forum.mattermost.org/t/how-to-use-the-troubleshooting-forum/150)
- [Help translate Mattermost](https://handbook.mattermost.com/contributors/contributors/localization)

## Learn More

- [API Options - webhooks, slash commands, drivers and web service](https://api.mattermost.com/)
- [See who's using Mattermost](https://mattermost.com/blog/category/customer-stories/)
- [Browse over 700 Mattermost integrations](https://integrations.mattermost.com/)

## License

See the [LICENSE file](LICENSE.txt) for license rights and limitations.

## Get the Latest News

- **Twitter** - Follow [Mattermost](https://twitter.com/mattermost).
- **Blog** - Get the latest updates from the [Mattermost blog](https://mattermost.com/blog/).
- **Facebook** - Follow [Mattermost](https://www.facebook.com/MattermostHQ).
- **LinkedIn** - Follow [Mattermost](https://www.linkedin.com/company/mattermost/).
- **Email** - Subscribe to our [newsletter](http://mattermost.us11.list-manage.com/subscribe?u=6cdba22349ae374e188e7ab8e&id=2add1c8034) (1 or 2 per month).
- **Mattermost** - Join the ~contributors channel on [the Mattermost Community Server](https://community.mattermost.com). 
- **IRC** - Join the #matterbridge channel on [Freenode](https://freenode.net/) (thanks to [matterircd](https://github.com/42wim/matterircd)).

## Contributing
Please see [CONTRIBUTING.md](./CONTRIBUTING.md).

Any other questions, mail us at info@mattermost.com. We’d love to meet you!
