/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class HappinessIndicator
extends Region {
    private static final double PREFERRED_WIDTH = 64.0;
    private static final double PREFERRED_HEIGHT = 64.0;
    private static final double MINIMUM_WIDTH = 16.0;
    private static final double MINIMUM_HEIGHT = 16.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Text text;
    private Canvas canvas;
    private GraphicsContext ctx;
    private ObjectProperty<Happiness> happiness;
    private DoubleProperty value;
    private ObjectProperty<Color> barBackgroundColor;
    private ObjectProperty<Color> textColor;
    private BooleanProperty textVisible;
    private ObjectProperty<Color> happyColor;
    private ObjectProperty<Color> neutralColor;
    private ObjectProperty<Color> unhappyColor;

    public HappinessIndicator() {
        this(Happiness.HAPPY, 0.0);
    }

    public HappinessIndicator(Happiness HAPPINESS) {
        this(HAPPINESS, 0.0);
    }

    public HappinessIndicator(Happiness HAPPINESS, double VALUE) {
        this.happiness = new ObjectPropertyBase<Happiness>(HAPPINESS){

            @Override
            protected void invalidated() {
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "happiness";
            }
        };
        this.value = new DoublePropertyBase(VALUE){

            @Override
            protected void invalidated() {
                double value = Helper.clamp(0.0, 1.0, this.get());
                this.set(value);
                HappinessIndicator.this.text.setText(String.format(Locale.US, "%.0f%%", value * 100.0));
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "value";
            }
        };
        this.barBackgroundColor = new ObjectPropertyBase<Color>(Tile.BACKGROUND.brighter()){

            @Override
            protected void invalidated() {
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "barBackgroundColor";
            }
        };
        this.textColor = new ObjectPropertyBase<Color>(Tile.FOREGROUND){

            @Override
            protected void invalidated() {
                HappinessIndicator.this.text.setFill((Paint)this.get());
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "textColor";
            }
        };
        this.textVisible = new BooleanPropertyBase(true){

            @Override
            protected void invalidated() {
                Helper.enableNode(HappinessIndicator.this.text, this.get());
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "textVisible";
            }
        };
        this.happyColor = new ObjectPropertyBase<Color>(Tile.GREEN){

            @Override
            protected void invalidated() {
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "happyColor";
            }
        };
        this.neutralColor = new ObjectPropertyBase<Color>(Tile.YELLOW_ORANGE){

            @Override
            protected void invalidated() {
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "neutralColor";
            }
        };
        this.unhappyColor = new ObjectPropertyBase<Color>(Tile.RED){

            @Override
            protected void invalidated() {
                HappinessIndicator.this.redraw();
            }

            @Override
            public Object getBean() {
                return HappinessIndicator.this;
            }

            @Override
            public String getName() {
                return "unhappyColor";
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(64.0, 64.0);
            }
        }
        this.canvas = new Canvas(64.0, 64.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.text = new Text(String.format(Locale.US, "%.0f%%", this.getValue() * 100.0));
        this.text.setTextAlignment(TextAlignment.CENTER);
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill(this.getTextColor());
        Helper.enableNode(this.text, this.getTextVisible());
        this.getChildren().setAll((Node[])new Node[]{this.canvas, this.text});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    public double getValue() {
        return this.value.get();
    }

    public void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public Color getBarBackgroundColor() {
        return (Color)this.barBackgroundColor.get();
    }

    public void setBarBackgroundColor(Color COLOR) {
        this.barBackgroundColor.set(COLOR);
    }

    public ObjectProperty<Color> barBackgroundColorProperty() {
        return this.barBackgroundColor;
    }

    public Color getTextColor() {
        return (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        this.textColor.set(COLOR);
    }

    public ObjectProperty<Color> textColorProperty() {
        return this.textColor;
    }

    public boolean getTextVisible() {
        return this.textVisible.get();
    }

    public void setTextVisible(boolean VISIBLE) {
        this.textVisible.set(VISIBLE);
    }

    public BooleanProperty textVisibleProperty() {
        return this.textVisible;
    }

    public Happiness getHappiness() {
        return (Happiness)((Object)this.happiness.get());
    }

    public void setHappiness(Happiness HAPPINESS) {
        this.happiness.set(HAPPINESS);
    }

    public ObjectProperty<Happiness> happinessProperty() {
        return this.happiness;
    }

    public Color getHappyColor() {
        return (Color)this.happyColor.get();
    }

    public void setHappyColor(Color COLOR) {
        this.happyColor.set(COLOR);
    }

    public ObjectProperty<Color> happyColorProperty() {
        return this.happyColor;
    }

    public Color getNeutralColor() {
        return (Color)this.neutralColor.get();
    }

    public void setNeutralColor(Color COLOR) {
        this.neutralColor.set(COLOR);
    }

    public ObjectProperty<Color> neutralColorProperty() {
        return this.neutralColor;
    }

    public Color getUnhappyColor() {
        return (Color)this.unhappyColor.get();
    }

    public void setUnhappyColor(Color COLOR) {
        this.unhappyColor.set(COLOR);
    }

    public ObjectProperty<Color> unhappyColorProperty() {
        return this.unhappyColor;
    }

    @Override
    protected double computeMinWidth(double HEIGHT) {
        return 16.0;
    }

    @Override
    protected double computeMinHeight(double WIDTH) {
        return 16.0;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    @Override
    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    @Override
    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.text.setFont(Fonts.latoBold(this.size * 0.25));
            this.text.relocate((this.getWidth() - this.text.getLayoutBounds().getWidth()) * 0.5, this.height * 0.5 - this.size * 0.54);
            this.redraw();
        }
    }

    private void redraw() {
        double scaling = this.getTextVisible() ? 0.7 : 1.0;
        double offsetY = this.getTextVisible() ? this.size * 0.15 : 0.0;
        double circleSize = this.size * 0.9 * scaling;
        double circleOffset = (this.size - circleSize) / 2.0;
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setLineCap(StrokeLineCap.ROUND);
        this.ctx.setStroke(this.getBarBackgroundColor());
        this.ctx.setLineWidth(this.size * 0.08823529 * scaling);
        this.ctx.strokeOval(circleOffset, circleOffset + offsetY, circleSize, circleSize);
        Color currentColor = Color.TRANSPARENT;
        this.ctx.save();
        this.ctx.translate(offsetY, offsetY + offsetY);
        this.ctx.setLineWidth(this.size * 0.05882353 * scaling);
        switch (this.getHappiness()) {
            case HAPPY: {
                currentColor = this.getHappyColor();
                this.ctx.setStroke(currentColor);
                this.ctx.beginPath();
                this.ctx.moveTo(this.size * 0.26470588 * scaling, this.size * 0.59411765 * scaling);
                this.ctx.bezierCurveTo(this.size * 0.26470588 * scaling, this.size * 0.59411765 * scaling, this.size * 0.33047353 * scaling, this.size * 0.73529412 * scaling, this.size * 0.5 * scaling, this.size * 0.73529412 * scaling);
                this.ctx.bezierCurveTo(this.size * 0.67506176 * scaling, this.size * 0.73529412 * scaling, this.size * 0.73529412 * scaling, this.size * 0.59411765 * scaling, this.size * 0.73529412 * scaling, this.size * 0.59411765 * scaling);
                this.ctx.stroke();
                break;
            }
            case NEUTRAL: {
                currentColor = this.getNeutralColor();
                this.ctx.setStroke(currentColor);
                this.ctx.strokeLine(this.size * 0.26470588 * scaling, this.size * 0.65294118 * scaling, this.size * 0.73529412 * scaling, this.size * 0.65294118 * scaling);
                break;
            }
            case UNHAPPY: {
                currentColor = this.getUnhappyColor();
                this.ctx.setStroke(currentColor);
                this.ctx.beginPath();
                this.ctx.moveTo(this.size * 0.26470588 * scaling, this.size * 0.70588235 * scaling);
                this.ctx.bezierCurveTo(this.size * 0.26470588 * scaling, this.size * 0.70588235 * scaling, this.size * 0.33047353 * scaling, this.size * 0.56803529 * scaling, this.size * 0.5 * scaling, this.size * 0.56803529 * scaling);
                this.ctx.bezierCurveTo(this.size * 0.67506176 * scaling, this.size * 0.56803529 * scaling, this.size * 0.73529412 * scaling, this.size * 0.70588235 * scaling, this.size * 0.73529412 * scaling, this.size * 0.70588235 * scaling);
                this.ctx.stroke();
            }
        }
        this.ctx.setFill(currentColor);
        this.ctx.fillOval(this.size * 0.26470588 * scaling, this.size * 0.3 * scaling, this.size * 0.14705882 * scaling, this.size * 0.14705882 * scaling);
        this.ctx.fillOval(this.size * 0.58823529 * scaling, this.size * 0.3 * scaling, this.size * 0.14705882 * scaling, this.size * 0.14705882 * scaling);
        this.ctx.restore();
        this.ctx.setStroke(currentColor);
        this.ctx.setLineWidth(this.size * 0.08823529 * scaling);
        this.ctx.strokeArc(circleOffset, circleOffset + offsetY, circleSize, circleSize, 90.0, -(this.getValue() * 360.0), ArcType.OPEN);
    }

    public static enum Happiness {
        UNHAPPY,
        NEUTRAL,
        HAPPY;

    }
}

