/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import javafx.beans.NamedArg;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class FlowGridPane
extends GridPane {
    private boolean internalCall = false;
    private int _noOfCols;
    private int _noOfRows;
    private IntegerProperty noOfCols;
    private IntegerProperty noOfRows;

    public FlowGridPane(@NamedArg(value="NO_OF_COLS") int NO_OF_COLS, @NamedArg(value="NO_OF_ROWS") int NO_OF_ROWS) {
        this._noOfCols = NO_OF_COLS;
        this._noOfRows = NO_OF_ROWS;
        this.noOfCols = new IntegerPropertyBase(NO_OF_COLS){

            @Override
            protected void invalidated() {
                ObservableList<ColumnConstraints> constraints = FlowGridPane.this.getColumnConstraints();
                constraints.clear();
                int cols = this.get();
                for (int i = 0; i < cols; ++i) {
                    ColumnConstraints c = new ColumnConstraints();
                    c.setHalignment(HPos.CENTER);
                    c.setHgrow(Priority.ALWAYS);
                    c.setMinWidth(60.0);
                    constraints.add(c);
                }
                this.set(cols);
                FlowGridPane.this.relayout();
                if (FlowGridPane.this.internalCall) {
                    return;
                }
                FlowGridPane.this._noOfCols = cols;
            }

            @Override
            public Object getBean() {
                return FlowGridPane.this;
            }

            @Override
            public String getName() {
                return "noOfCols";
            }
        };
        this.noOfRows = new IntegerPropertyBase(NO_OF_ROWS){

            @Override
            protected void invalidated() {
                ObservableList<RowConstraints> constraints = FlowGridPane.this.getRowConstraints();
                constraints.clear();
                int rows = this.get();
                for (int i = 0; i < rows; ++i) {
                    RowConstraints r = new RowConstraints();
                    r.setValignment(VPos.CENTER);
                    r.setVgrow(Priority.ALWAYS);
                    r.setMinHeight(20.0);
                    constraints.add(r);
                }
                this.set(rows);
                FlowGridPane.this.relayout();
                if (FlowGridPane.this.internalCall) {
                    return;
                }
                FlowGridPane.this._noOfRows = rows;
            }

            @Override
            public Object getBean() {
                return FlowGridPane.this;
            }

            @Override
            public String getName() {
                return "noOfRows";
            }
        };
        this.getChildren().addListener(change -> this.relayout());
        this.registerListeners();
    }

    public FlowGridPane(@NamedArg(value="NO_OF_COLS") int NO_OF_COLS, @NamedArg(value="NO_OF_ROWS") int NO_OF_ROWS, Node ... NODES) {
        this._noOfCols = NO_OF_COLS;
        this._noOfRows = NO_OF_ROWS;
        this.noOfCols = new IntegerPropertyBase(NO_OF_COLS){

            @Override
            protected void invalidated() {
                ObservableList<ColumnConstraints> constraints = FlowGridPane.this.getColumnConstraints();
                constraints.clear();
                int cols = this.get();
                for (int i = 0; i < cols; ++i) {
                    ColumnConstraints c = new ColumnConstraints();
                    c.setHalignment(HPos.CENTER);
                    c.setHgrow(Priority.ALWAYS);
                    c.setMinWidth(60.0);
                    constraints.add(c);
                }
                this.set(cols);
                FlowGridPane.this.relayout();
                if (FlowGridPane.this.internalCall) {
                    return;
                }
                FlowGridPane.this._noOfCols = cols;
            }

            @Override
            public Object getBean() {
                return FlowGridPane.this;
            }

            @Override
            public String getName() {
                return "noOfCols";
            }
        };
        this.noOfRows = new IntegerPropertyBase(NO_OF_ROWS){

            @Override
            protected void invalidated() {
                ObservableList<RowConstraints> constraints = FlowGridPane.this.getRowConstraints();
                constraints.clear();
                int rows = this.get();
                for (int i = 0; i < rows; ++i) {
                    RowConstraints r = new RowConstraints();
                    r.setValignment(VPos.CENTER);
                    r.setVgrow(Priority.ALWAYS);
                    r.setMinHeight(20.0);
                    constraints.add(r);
                }
                this.set(rows);
                FlowGridPane.this.relayout();
                if (FlowGridPane.this.internalCall) {
                    return;
                }
                FlowGridPane.this._noOfRows = rows;
            }

            @Override
            public Object getBean() {
                return FlowGridPane.this;
            }

            @Override
            public String getName() {
                return "noOfRows";
            }
        };
        this.getChildren().addListener(change -> this.relayout());
        this.registerListeners();
        if (null != NODES) {
            this.getChildren().setAll((Node[])NODES);
        }
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.checkAspectRatio());
        this.heightProperty().addListener(o -> this.checkAspectRatio());
    }

    public Integer getNoOfCols() {
        return this.noOfCols.get();
    }

    public void setNoOfCols(Integer COLS) {
        this.noOfCols.set(COLS);
    }

    public IntegerProperty noOfColsProperty() {
        return this.noOfCols;
    }

    public Integer getNoOfRows() {
        return this.noOfRows.get();
    }

    public void setNoOfRows(Integer ROWS) {
        this.noOfRows.set(ROWS);
    }

    public IntegerProperty noOfRowsProperty() {
        return this.noOfRows;
    }

    public void setNoOfColsAndNoOfRows(int COLS, int ROWS) {
        this.setNoOfCols(COLS);
        this.setNoOfRows(ROWS);
    }

    private int coordsToOffset(int COL, int ROW) {
        return ROW * this.noOfCols.get() + COL;
    }

    private int offsetToCol(int OFFSET) {
        return OFFSET % this.noOfCols.get();
    }

    private int offsetToRow(int OFFSET) {
        return OFFSET / this.noOfCols.get();
    }

    private void checkAspectRatio() {
        this.internalCall = true;
        if (this.getWidth() < this.getHeight()) {
            this.setNoOfColsAndNoOfRows(this._noOfRows, this._noOfCols);
        } else {
            this.setNoOfColsAndNoOfRows(this._noOfCols, this._noOfRows);
        }
        this.internalCall = false;
        this.relayout();
    }

    private void relayout() {
        ObservableList<Node> children = this.getChildren();
        int lastColSpan = 0;
        int lastRowSpan = 0;
        for (Node child : children) {
            int offs = children.indexOf(child);
            GridPane.setConstraints(child, this.offsetToCol(offs + lastColSpan), this.offsetToRow(offs + lastRowSpan));
        }
    }
}

