/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.behavior.SnapshotViewBehavior;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewSkin
extends SkinBase<SnapshotView> {
    private Node node;
    private final GridPane gridPane;
    private final Rectangle selectedArea;
    private final Rectangle unselectedArea;
    private final Node mouseNode;
    private final SnapshotViewBehavior snapshotViewBehavior;

    public SnapshotViewSkin(SnapshotView snapshotView) {
        super(snapshotView);
        this.snapshotViewBehavior = new SnapshotViewBehavior(snapshotView);
        this.gridPane = SnapshotViewSkin.createGridPane();
        this.selectedArea = new Rectangle();
        this.unselectedArea = new Rectangle();
        this.mouseNode = this.createMouseNode();
        this.buildSceneGraph();
        this.initializeAreas();
        this.registerChangeListener(snapshotView.nodeProperty(), e -> this.updateNode());
        this.registerChangeListener(snapshotView.selectionProperty(), e -> this.updateSelection());
    }

    private static GridPane createGridPane() {
        GridPane pane = new GridPane();
        pane.setAlignment(Pos.CENTER);
        return pane;
    }

    private Node createMouseNode() {
        Rectangle mouseNode = new Rectangle();
        mouseNode.setFill(Color.TRANSPARENT);
        mouseNode.setManaged(false);
        mouseNode.widthProperty().bind(((SnapshotView)this.getSkinnable()).widthProperty());
        mouseNode.heightProperty().bind(((SnapshotView)this.getSkinnable()).heightProperty());
        mouseNode.addEventHandler(MouseEvent.ANY, this::handleMouseEvent);
        mouseNode.mouseTransparentProperty().bind(((SnapshotView)this.getSkinnable()).selectionMouseTransparentProperty());
        return mouseNode;
    }

    private void buildSceneGraph() {
        this.getChildren().addAll((Node[])new Node[]{this.gridPane, this.unselectedArea, this.selectedArea, this.mouseNode});
        this.updateNode();
    }

    private void initializeAreas() {
        this.styleAreas();
        this.bindAreaCoordinatesTogether();
        this.bindAreaVisibilityToSelection();
    }

    private void styleAreas() {
        this.selectedArea.fillProperty().bind(((SnapshotView)this.getSkinnable()).selectionAreaFillProperty());
        this.selectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).selectionBorderPaintProperty());
        this.selectedArea.strokeWidthProperty().bind(((SnapshotView)this.getSkinnable()).selectionBorderWidthProperty());
        this.selectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.selectedArea.setManaged(false);
        this.selectedArea.setMouseTransparent(true);
        this.unselectedArea.setFill(Color.TRANSPARENT);
        this.unselectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).unselectedAreaFillProperty());
        this.unselectedArea.strokeWidthProperty().bind(Bindings.max((ObservableNumberValue)((SnapshotView)this.getSkinnable()).widthProperty(), (ObservableNumberValue)((SnapshotView)this.getSkinnable()).heightProperty()));
        this.unselectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.unselectedArea.setManaged(false);
        this.unselectedArea.setMouseTransparent(true);
    }

    private void bindAreaCoordinatesTogether() {
        this.unselectedArea.xProperty().bind(this.selectedArea.xProperty());
        this.unselectedArea.yProperty().bind(this.selectedArea.yProperty());
        this.unselectedArea.widthProperty().bind(this.selectedArea.widthProperty());
        this.unselectedArea.heightProperty().bind(this.selectedArea.heightProperty());
    }

    private void bindAreaVisibilityToSelection() {
        ReadOnlyBooleanProperty selectionExists = ((SnapshotView)this.getSkinnable()).hasSelectionProperty();
        BooleanProperty selectionActive = ((SnapshotView)this.getSkinnable()).selectionActiveProperty();
        BooleanBinding existsAndActive = Bindings.and(selectionExists, selectionActive);
        this.selectedArea.visibleProperty().bind(existsAndActive);
        this.unselectedArea.visibleProperty().bind(existsAndActive);
        new Clipper((SnapshotView)this.getSkinnable(), this.unselectedArea, () -> this.unselectedArea.visibleProperty().bind(existsAndActive));
    }

    private void updateNode() {
        if (this.node != null) {
            this.gridPane.getChildren().remove(this.node);
        }
        this.node = ((SnapshotView)this.getSkinnable()).getNode();
        if (this.node != null) {
            this.gridPane.getChildren().add(0, this.node);
        }
    }

    private void updateSelection() {
        boolean showSelection;
        boolean bl = showSelection = ((SnapshotView)this.getSkinnable()).hasSelection() && ((SnapshotView)this.getSkinnable()).isSelectionActive();
        if (showSelection) {
            Rectangle2D selection = ((SnapshotView)this.getSkinnable()).getSelection();
            this.setSelection(selection.getMinX(), selection.getMinY(), selection.getWidth(), selection.getHeight());
        } else {
            this.setSelection(0.0, 0.0, 0.0, 0.0);
        }
    }

    private void setSelection(double x, double y, double width, double height) {
        this.selectedArea.setX(x);
        this.selectedArea.setY(y);
        this.selectedArea.setWidth(width);
        this.selectedArea.setHeight(height);
    }

    private void handleMouseEvent(MouseEvent event) {
        Cursor newCursor = this.snapshotViewBehavior.handleMouseEvent(event);
        this.mouseNode.setCursor(newCursor);
    }

    private static class Clipper {
        private final SnapshotView snapshotView;
        private final Node clippedNode;
        private final Runnable rebindClippedNodeVisibility;
        private final Rectangle controlClip;
        private final Rectangle nodeClip;
        private final ChangeListener<Bounds> updateControlClipToNewBoundsListener;
        private final ChangeListener<Bounds> updateNodeClipToNewBoundsListener;

        public Clipper(SnapshotView snapshotView, Node clippedNode, Runnable rebindClippedNodeVisibility) {
            this.snapshotView = snapshotView;
            this.clippedNode = clippedNode;
            this.rebindClippedNodeVisibility = rebindClippedNodeVisibility;
            this.controlClip = new Rectangle();
            this.updateControlClipToNewBoundsListener = (o, oldBounds, newBounds) -> Clipper.resizeRectangleToBounds(this.controlClip, newBounds);
            this.nodeClip = new Rectangle();
            this.updateNodeClipToNewBoundsListener = (o, oldBounds, newBounds) -> Clipper.resizeRectangleToBounds(this.nodeClip, newBounds);
            this.setClipping();
            snapshotView.unselectedAreaBoundaryProperty().addListener((o, oldBoundary, newBoundary) -> this.setClipping());
        }

        private void setClipping() {
            SnapshotView.Boundary boundary = this.snapshotView.getUnselectedAreaBoundary();
            switch (boundary) {
                case CONTROL: {
                    this.clipToControl();
                    break;
                }
                case NODE: {
                    this.clipToNode();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The boundary " + boundary + " is not fully implemented.");
                }
            }
        }

        private void clipToControl() {
            this.updateNodeClipToChangingNode(this.snapshotView.nodeProperty(), this.snapshotView.getNode(), null);
            Clipper.resizeRectangleToBounds(this.controlClip, this.snapshotView.getBoundsInLocal());
            this.snapshotView.boundsInLocalProperty().addListener(this.updateControlClipToNewBoundsListener);
            this.setClip(this.controlClip);
        }

        private void clipToNode() {
            this.updateNodeClipToChangingNode(this.snapshotView.nodeProperty(), null, this.snapshotView.getNode());
            this.snapshotView.nodeProperty().addListener(this::updateNodeClipToChangingNode);
            this.setClip(this.nodeClip);
        }

        private void updateNodeClipToChangingNode(ObservableValue<? extends Node> o, Node oldNode, Node newNode) {
            Clipper.resizeRectangleToNodeBounds(this.nodeClip, newNode);
            if (oldNode != null) {
                oldNode.boundsInParentProperty().removeListener(this.updateNodeClipToNewBoundsListener);
            }
            if (newNode != null) {
                newNode.boundsInParentProperty().addListener(this.updateNodeClipToNewBoundsListener);
            }
        }

        private static void resizeRectangleToNodeBounds(Rectangle rectangle, Node node) {
            if (node == null) {
                Clipper.resizeRectangleToZero(rectangle);
            } else {
                Clipper.resizeRectangleToBounds(rectangle, node.getBoundsInParent());
            }
        }

        private static void resizeRectangleToZero(Rectangle rectangle) {
            rectangle.setX(0.0);
            rectangle.setY(0.0);
            rectangle.setWidth(0.0);
            rectangle.setHeight(0.0);
        }

        private static void resizeRectangleToBounds(Rectangle rectangle, Bounds bounds) {
            rectangle.setX(bounds.getMinX());
            rectangle.setY(bounds.getMinY());
            rectangle.setWidth(bounds.getWidth());
            rectangle.setHeight(bounds.getHeight());
        }

        private void setClip(Node clip) {
            boolean workAroundVisibilityProblem;
            boolean bl = workAroundVisibilityProblem = !this.clippedNode.isVisible();
            if (workAroundVisibilityProblem) {
                this.clippedNode.visibleProperty().unbind();
                this.clippedNode.setVisible(true);
            }
            this.clippedNode.setClip(clip);
            if (workAroundVisibilityProblem) {
                this.rebindClippedNodeVisibility.run();
            }
        }
    }
}

