/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.util.Callback;

public class PixelBuffer<T extends Buffer> {
    private final T buffer;
    private final int width;
    private final int height;
    private final PixelFormat<T> pixelFormat;
    private final List<WeakReference<WritableImage>> imageRefs;

    public PixelBuffer(int n, int n2, T t, PixelFormat<T> pixelFormat) {
        Objects.requireNonNull(t, "buffer must not be null.");
        Objects.requireNonNull(pixelFormat, "pixelFormat must not be null.");
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("PixelBuffer dimensions must be positive (w,h > 0)");
        }
        switch (pixelFormat.getType()) {
            case BYTE_BGRA_PRE: {
                if (((Buffer)t).capacity() / n / 4 < n2) {
                    throw new IllegalArgumentException("Insufficient memory allocated for ByteBuffer.");
                }
                if (t instanceof ByteBuffer) break;
                throw new IllegalArgumentException("PixelFormat<ByteBuffer> requires a ByteBuffer.");
            }
            case INT_ARGB_PRE: {
                if (((Buffer)t).capacity() / n < n2) {
                    throw new IllegalArgumentException("Insufficient memory allocated for IntBuffer.");
                }
                if (t instanceof IntBuffer) break;
                throw new IllegalArgumentException("PixelFormat<IntBuffer> requires an IntBuffer.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported PixelFormat: " + pixelFormat.getType());
            }
        }
        this.buffer = t;
        this.width = n;
        this.height = n2;
        this.pixelFormat = pixelFormat;
        this.imageRefs = new LinkedList<WeakReference<WritableImage>>();
    }

    public T getBuffer() {
        return this.buffer;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public PixelFormat<T> getPixelFormat() {
        return this.pixelFormat;
    }

    public void updateBuffer(Callback<PixelBuffer<T>, Rectangle2D> callback) {
        Toolkit.getToolkit().checkFxUserThread();
        Objects.requireNonNull(callback, "callback must not be null.");
        Rectangle2D rectangle2D = callback.call(this);
        if (rectangle2D != null) {
            if (rectangle2D.getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
                int n = (int)Math.floor(rectangle2D.getMinX());
                int n2 = (int)Math.floor(rectangle2D.getMinY());
                int n3 = (int)Math.ceil(rectangle2D.getMaxX());
                int n4 = (int)Math.ceil(rectangle2D.getMaxY());
                this.bufferDirty(new Rectangle(n, n2, n3 - n, n4 - n2));
            }
        } else {
            this.bufferDirty(null);
        }
    }

    private void bufferDirty(Rectangle rectangle) {
        Iterator<WeakReference<WritableImage>> iterator2 = this.imageRefs.iterator();
        while (iterator2.hasNext()) {
            WritableImage writableImage = (WritableImage)iterator2.next().get();
            if (writableImage != null) {
                writableImage.bufferDirty(rectangle);
                continue;
            }
            iterator2.remove();
        }
    }

    void addImage(WritableImage writableImage) {
        this.imageRefs.add(new WeakReference<WritableImage>(writableImage));
        this.imageRefs.removeIf(weakReference -> weakReference.get() == null);
    }
}

