/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.blacklist;

import java.util.function.Predicate;
import mediathek.config.MVConfig;
import mediathek.daten.DatenFilm;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.tool.Filter;
import org.apache.commons.lang3.StringUtils;

class ApplyBlacklistFilterPredicate
implements Predicate<DatenFilm> {
    private static final String[] EMPTY_STRING = new String[]{""};
    private final boolean isWhitelist = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
    private final ListeBlacklist listeBlacklist;

    public ApplyBlacklistFilterPredicate(ListeBlacklist listeBlacklist) {
        this.listeBlacklist = listeBlacklist;
    }

    @Override
    public boolean test(DatenFilm film) {
        for (BlacklistRule entry : this.listeBlacklist) {
            String[] pThema;
            String[] pTitel;
            if (!this.performFiltering(entry, pTitel = this.createPattern(entry.hasTitlePattern(), entry.arr[3]), pThema = this.createPattern(entry.hasThemaPattern(), entry.arr[4]), film)) continue;
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }

    private String[] mySplit(String inputString) {
        String[] pTitle = StringUtils.split(inputString, ',');
        if (pTitle.length == 0) {
            return EMPTY_STRING;
        }
        return pTitle;
    }

    private String[] createPattern(boolean isPattern, String inputString) {
        if (isPattern) {
            return new String[]{inputString};
        }
        return this.mySplit(inputString);
    }

    private boolean performFiltering(BlacklistRule entry, String[] titelSuchen, String[] themaTitelSuchen, DatenFilm film) {
        boolean result = false;
        String thema = film.getThema();
        String title = film.getTitle();
        String senderSuchen = entry.arr[1];
        String themaSuchen = entry.arr[2];
        if ((senderSuchen.isEmpty() || film.getSender().compareTo(senderSuchen) == 0) && (themaSuchen.isEmpty() || thema.equalsIgnoreCase(themaSuchen)) && (titelSuchen.length == 0 || Filter.pruefen(titelSuchen, title)) && (themaTitelSuchen.length == 0 || Filter.pruefen(themaTitelSuchen, thema) || Filter.pruefen(themaTitelSuchen, title)) && this.checkLengthWithMin(film.getFilmLength())) {
            result = true;
        }
        return result;
    }

    public boolean lengthCheck(int filterLaengeInMinuten, long filmLaenge) {
        return filterLaengeInMinuten == 0 || filmLaenge == 0L;
    }

    private boolean checkLengthWithMin(long filmLaenge) {
        return this.lengthCheck(0, filmLaenge) || filmLaenge > 0L;
    }
}

