/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.blacklist;

import java.util.Arrays;
import mediathek.tool.Filter;
import org.jetbrains.annotations.NotNull;

public class BlacklistRule
implements Comparable<BlacklistRule> {
    public static final int BLACKLIST_NR = 0;
    public static final int BLACKLIST_SENDER = 1;
    public static final int BLACKLIST_THEMA = 2;
    public static final int BLACKLIST_TITEL = 3;
    public static final int BLACKLIST_THEMA_TITEL = 4;
    public static final int MAX_ELEM = 5;
    public static final String TAG = "Blacklist";
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "Sender", "Thema", "Titel", "Thema-Titel"};
    public static final String[] XML_NAMES = new String[]{"black-nr", "black-sender", "black-thema", "black-titel", "black-thema-titel"};
    public String[] arr = new String[5];
    private boolean patternTitle = true;
    private boolean patternThema = true;

    public BlacklistRule() {
        Arrays.fill(this.arr, "");
    }

    public BlacklistRule(String sender, String thema, String titel, String themaTitel) {
        this();
        this.arr[1] = sender;
        this.arr[2] = thema;
        this.arr[3] = titel;
        this.arr[4] = themaTitel;
    }

    public void checkPatterns() {
        this.patternTitle = Filter.isPattern(this.arr[3]);
        this.patternThema = Filter.isPattern(this.arr[4]);
        if (this.patternTitle) {
            Filter.makePattern(this.arr[3]);
        }
        if (this.patternThema) {
            Filter.makePattern(this.arr[4]);
        }
    }

    public boolean hasTitlePattern() {
        return this.patternTitle;
    }

    public boolean hasThemaPattern() {
        return this.patternThema;
    }

    public void convertToLowerCase() {
        this.arr[3] = this.arr[3].toLowerCase();
        this.arr[4] = this.arr[4].toLowerCase();
    }

    @Override
    public int compareTo(@NotNull BlacklistRule o) {
        return 0;
    }
}

