[![Build Status](https://dev.azure.com/leezer3/OpenBVE/_apis/build/status/leezer3.OpenBVE?branchName=master)](https://dev.azure.com/leezer3/OpenBVE/_build/latest?definitionId=1&branchName=master)

[![Build status](https://ci.appveyor.com/api/projects/status/p4d983eclo738hjo?svg=true)](https://ci.appveyor.com/project/leezer3/openbve)

## openBVE Source Code - Readme

This source code started out life as a port of openBVE to the OpenTK framework, but now has begun major development work to improve the sim and the possibilities it presents.

### Compatibility Changes

A general overview of compatibility changes, including to the OpenBveApi, and animated objects are described fully [here](https://github.com/leezer3/OpenBVE/wiki/Compatibility-Notes).

### Fixed Errata

These are described fully [here](https://github.com/leezer3/OpenBVE/wiki/Errata).

### Nightly Builds

Automatically generated daily builds are available [here](http://vps.bvecornwall.co.uk/OpenBVE/Builds/).

### Developer Documentation

Documentation for development of add-ons (update version of docs originally written by _michelle_) can be found [here](https://github.com/leezer3/OpenBVE/tree/master/Documentation).

### Packages

openBVE now supports the installation of 'package files' , which are intended as a replacement for the now defunct managed content. These are described fully [here](http://openbve-project.net/packages/).

### How to build

This build has been tested to compile correctly using Visual Studio 2017 onwards and MonoDevelop. These are described fully [here](Building.md).

### Contributing

Please see the [Contributors File](Contributing.md) for a list of contributors, and basic guidelines for contributing to the development of openBVE.


### Links

**Project Website**:

https://openbve-project.net

Project Source Code on GitHub: https://github.com/leezer3/OpenBVE

**Discussion Boards**:

- [BVE Worldwide](http://bveworldwide.forumotion.com)
- [BVE-Terminus](http://www.bve-terminus.org/forum)
- [UKTrainsim](http://forums.uktrainsim.com/viewforum.php?f=66)

**Official Project Forum:**

http://bveworldwide.forumotion.com/f14-the-sim-in-time-general-discussion

### License

Michelle intended for this program to be placed in the public domain. This means that you can make any modifications to it you like and share your modifications with others.
Please also see the following issue for further discussion on the topic: https://github.com/leezer3/OpenBVE/issues/305

**Third-Party Libraries**

- openBVE uses the [**CoreFX**](https://github.com/dotnet/corefx). This is licensed under the _MIT License_, which may be found in [here](licenses/CoreFX.txt).
- openBVE uses the [**CS Script**](https://github.com/oleg-shilo/cs-script) for animation scripting. This is licensed under the _MIT License_, which may be found in [here](licenses/CS-Script.txt).
- openBVE uses the [**DotNetZip**](https://github.com/haf/DotNetZip.Semverd) for loading compressed DirectX file. This is licensed under the *Microsoft Public License*, which may be found in [here](licenses/DotNetZip.txt).
- openBVE uses the [**NAudio**](https://github.com/naudio/NAudio) for decoding sound file. This is licensed under the *Microsoft Public License*, which may be found in [here](licenses/NAudio.txt).
- openBVE uses the [**NAudio.Vorbis**](https://github.com/naudio/Vorbis) for decoding Vorbis file. This is licensed under the *Microsoft Public License*, which may be found in [here](licenses/NAudio.Vorbis.txt).
- openBVE uses the [**NLayer**](https://github.com/naudio/NLayer) for decoding MP3 file. This is licensed under the *MIT License*, which may be found in [here](licenses/NLayer.txt).
- openBVE uses the [**NVorbis**](https://github.com/NVorbis/NVorbis) for decoding Vorbis file. This is licensed under the *Microsoft Public License*, which may be found in [here](licenses/NVorbis.txt).
- openBVE uses the [**OpenTK**](https://github.com/opentk/opentk) library for windowing and input handling. This is licensed under the _Open Toolkit Library License_, which may be found in [here](licenses/OpenTK.txt).
- openBVE uses the [**Prism**](https://github.com/PrismLibrary/Prism). This is licensed under the *MIT License*, which may be found in [here](licenses/Prism.txt).
- openBVE uses the [**ReactiveProperty**](https://github.com/runceel/ReactiveProperty). This is licensed under the *MIT License*, which may be found in [here](licenses/ReactiveProperty.txt).
- openBVE uses the [**SharpCompress**](https://github.com/adamhathcock/sharpcompress) for archive handling. This is licensed under the _MIT License_, which may be found in [here](licenses/SharpCompress.txt).
- openBVE uses the [**Reactive Extensions**](https://github.com/dotnet/reactive). This is licensed under the *Apache License, Version 2.0*, which may be found in [here](licenses/ReactiveExtensions.txt).
- openBVE uses the [**Ude**](https://github.com/yinyue200/ude) for character set detection. This is tri-licensed under the _Mozilla Public License v1.1_, _GPL 2.0_ and _LGPL 2.0_, which may be found in [here](licenses/Ude.txt).
- openBVE uses the [**XamlBehaviors for WPF**](https://github.com/microsoft/XamlBehaviorsWpf). This is licensed under the *MIT License*, which may be found in [here](licenses/XamlBehaviorsForWPF.txt).
