#!/bin/bash

# This script is used for installing rpm public key and registering repository
# in package manager.

debug() {
  #Uncomment below to see some diagnostic messages
  logger $*
}

install_key() {
  rpm -q gpg-pubkey-8de1b7a0-60d2f880 >/dev/null 2>&1
  if [ "$?" -eq "0" ]; then
    debug "Key installed already"
    return 0
  fi

  local TMPFILE=$(mktemp -t opera-tmp-key.XXXXXX)

  cat >"$TMPFILE" <<ENDKEY
-----BEGIN PGP PUBLIC KEY BLOCK-----
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==
=amLT
-----END PGP PUBLIC KEY BLOCK-----
ENDKEY

  rpm --import "$TMPFILE" >/dev/null 2>&1
  local import_result="$?"

  rm "$TMPFILE"

  if [ "$import_result" != "0" ]; then
    debug "Failed key installation"
    return 1
  fi

  debug "Key installation success"
}

install_old_key() {
  rpm -q gpg-pubkey-abdc4346-5d79ff84 >/dev/null 2>&1
  if [ "$?" -eq "0" ]; then
    debug "Key installed already"
    return 0
  fi

  local TMPFILE=$(mktemp -t opera-tmp-key.XXXXXX)

  cat >"$TMPFILE" <<ENDKEY
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1
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=drxy
-----END PGP PUBLIC KEY BLOCK-----
ENDKEY

  rpm --import "$TMPFILE" >/dev/null 2>&1
  local import_result="$?"

  rm "$TMPFILE"

  if [ "$import_result" != "0" ]; then
    debug "Failed key installation"
    return 1
  fi

  debug "Key installation success"
}

install_repo() {
  local RELEASE
  local PKGMANAGER
  LSB_RELEASE="$(which lsb_release 2> /dev/null)"

  if [ -x "$LSB_RELEASE" ]; then
    RELEASE=$(lsb_release -i 2> /dev/null | sed 's/:\t/:/' | cut -d ':' -f 2-)
    case $RELEASE in
      "Fedora")
        PKGMANAGER=yum
        ;;
      "SUSE LINUX")
        PKGMANAGER=zypper
        ;;
    esac
  fi

  if [ -z "$PKGMANAGER" ]; then
    if [ -f "/etc/fedora-release" ] || [ -f "/etc/redhat-release" ]; then
      PKGMANAGER=yum
    elif [ -f "/etc/SuSE-release" ] || [ -f "/etc/SUSE-brand" ]; then
      PKGMANAGER=zypper
    fi
  fi

  case $PKGMANAGER in
  "yum")
    grep -ql https://rpm.opera.com/rpm /etc/yum.repos.d/*
    if [ $? = 0 ]; then
      debug "Opera yum repo exists already"
    else
      cat >"/etc/yum.repos.d/opera.repo" <<ENDREPO
[opera]
name=Opera packages
type=rpm-md
baseurl=https://rpm.opera.com/rpm
gpgcheck=1
gpgkey=https://rpm.opera.com/rpmrepo.key
enabled=1
ENDREPO
    if [ "$?" != "0" ]; then
      debug "Yum repo installation problem"
      exit 1
    fi
    debug "Yum repo installed successfully"
    fi
    ;;
  "zypper")
    grep -ql https://rpm.opera.com/rpm /etc/zypp/repos.d/*
    if [ $? = 0 ]; then
      debug "Opera zypper repo exists already"
    else
      cat >"/etc/zypp/repos.d/opera.repo" <<ENDREPO
[opera]
name=Opera packages
type=rpm-md
baseurl=https://rpm.opera.com/rpm
gpgcheck=1
gpgkey=https://rpm.opera.com/rpmrepo.key
enabled=1
autorefresh=1
keeppackages=0
ENDREPO
    if [ "$?" != "0" ]; then
      debug "Zypper repo installation problem"
      exit 1
    fi
    debug "Zypper repo installed successfully"
    fi
    ;;
  else)
    debug "Unsupported package manager";
    ;;
  esac
}


install_key && install_old_key && install_repo
exit $?