/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class AbstractTaskDraw
implements TaskDraw {
    private CenterBorderColor colors;
    protected int completion = 100;
    protected Url url;
    protected Display note;
    protected final TimeScale timeScale;
    private Real y;
    protected final String prettyDisplay;
    protected final Day start;
    private final StyleBuilder styleBuilder;
    private final HColorSet colorSet;
    private final Task task;
    private final ToTaskDraw toTaskDraw;

    public final String toString() {
        return super.toString() + " " + this.task;
    }

    @Override
    public final void setColorsAndCompletion(CenterBorderColor colors, int completion, Url url, Display note) {
        this.colors = colors;
        this.completion = completion;
        this.url = url;
        this.note = note;
    }

    public AbstractTaskDraw(TimeScale timeScale, Real y, String prettyDisplay, Day start, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw, StyleBuilder styleBuilder, HColorSet colorSet) {
        this.y = y;
        this.colorSet = colorSet;
        this.styleBuilder = styleBuilder;
        this.toTaskDraw = toTaskDraw;
        this.start = start;
        this.prettyDisplay = prettyDisplay;
        this.timeScale = timeScale;
        this.task = task;
    }

    abstract StyleSignature getStyleSignature();

    protected final HColor getLineColor() {
        return this.getStyle().value(PName.LineColor).asColor(this.getStyleBuilder().getSkinParam().getThemeStyle(), this.colorSet);
    }

    protected final HColor getBackgroundColor() {
        return this.getStyle().value(PName.BackGroundColor).asColor(this.getStyleBuilder().getSkinParam().getThemeStyle(), this.colorSet);
    }

    protected final FontConfiguration getFontConfiguration() {
        return this.getStyle().getFontConfiguration(this.styleBuilder.getSkinParam().getThemeStyle(), this.colorSet);
    }

    protected final Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.styleBuilder);
    }

    @Override
    public final double getTitleWidth(StringBounder stringBounder) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getLeft() + this.getTitle().calculateDimension(stringBounder).getWidth() + margin.getRight();
    }

    protected abstract TextBlock getTitle();

    protected abstract double getShapeHeight(StringBounder var1);

    @Override
    public final double getFullHeightTask(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getTop() + this.getShapeHeight(stringBounder) + margin.getBottom();
    }

    @Override
    public TaskDraw getTrueRow() {
        return this.toTaskDraw.getTaskDraw(this.task.getRow());
    }

    @Override
    public final Real getY(StringBounder stringBounder) {
        if (this.task.getRow() == null) {
            return this.y;
        }
        return this.getTrueRow().getY(stringBounder);
    }

    @Override
    public final Task getTask() {
        return this.task;
    }

    @Override
    public final double getY(StringBounder stringBounder, Direction direction) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        double y1 = margin.getTop() + this.getY(stringBounder).getCurrentValue();
        double y2 = y1 + this.getShapeHeight(stringBounder);
        if (direction == Direction.UP) {
            return y1;
        }
        if (direction == Direction.DOWN) {
            return y2;
        }
        return (y1 + y2) / 2.0;
    }

    protected final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    protected final HColorSet getColorSet() {
        return this.colorSet;
    }

    protected CenterBorderColor getColors() {
        return this.colors;
    }
}

