# _FlattenNextSecondPromise
<span class="source-link">[[Source]](src/promises/_test.md#L319)</span>

Callback functions called after fulfilled/reject is called on the second
promise in our `flatten_next` tests.

This helper is designed for tests where there are only two promises. there
are calls to `complete` on `TestHelper` that would be incorrectly placed if
additional promises were chained after this. If tests are added with longer
chains, this helper's usage of `complete` should be reworked accordingly.


```pony
primitive val _FlattenNextSecondPromise
```

## Constructors

### create
<span class="source-link">[[Source]](src/promises/_test.md#L319)</span>


```pony
new val create()
: _FlattenNextSecondPromise val^
```

#### Returns

* [_FlattenNextSecondPromise](promises-_FlattenNextSecondPromise.md) val^

---

## Public Functions

### successful_fulfill
<span class="source-link">[[Source]](src/promises/_test.md#L329)</span>


```pony
fun box successful_fulfill(
  h: TestHelper val,
  expected: String val,
  actual: String val)
: None val
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   expected: [String](builtin-String.md) val
*   actual: [String](builtin-String.md) val

#### Returns

* [None](builtin-None.md) val

---

### fulfill_will_error
<span class="source-link">[[Source]](src/promises/_test.md#L334)</span>


```pony
fun box fulfill_will_error(
  h: TestHelper val,
  expected: String val,
  actual: String val)
: None val ?
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   expected: [String](builtin-String.md) val
*   actual: [String](builtin-String.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### fail_if_fulfill_is_called
<span class="source-link">[[Source]](src/promises/_test.md#L340)</span>


```pony
fun box fail_if_fulfill_is_called(
  h: TestHelper val,
  s: String val)
: None val
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   s: [String](builtin-String.md) val

#### Returns

* [None](builtin-None.md) val

---

### reject_expected
<span class="source-link">[[Source]](src/promises/_test.md#L343)</span>


```pony
fun box reject_expected(
  h: TestHelper val,
  action: String val)
: None val
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val
*   action: [String](builtin-String.md) val

#### Returns

* [None](builtin-None.md) val

---

### fail_if_reject_is_called
<span class="source-link">[[Source]](src/promises/_test.md#L347)</span>


```pony
fun box fail_if_reject_is_called(
  h: TestHelper val)
: None val
```
#### Parameters

*   h: [TestHelper](ponytest-TestHelper.md) val

#### Returns

* [None](builtin-None.md) val

---

### eq
<span class="source-link">[[Source]](src/promises/_test.md#L329)</span>


```pony
fun box eq(
  that: _FlattenNextSecondPromise val)
: Bool val
```
#### Parameters

*   that: [_FlattenNextSecondPromise](promises-_FlattenNextSecondPromise.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/promises/_test.md#L329)</span>


```pony
fun box ne(
  that: _FlattenNextSecondPromise val)
: Bool val
```
#### Parameters

*   that: [_FlattenNextSecondPromise](promises-_FlattenNextSecondPromise.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

