#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              8.0.0
visibility:           public
id:                   postgrest-8.0.0-DTGFecm68zUIfI0023oJUU
key:                  postgrest-8.0.0-DTGFecm68zUIfI0023oJUU
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for the tables and views, supporting all HTTP verbs that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  217256d12ca61995c8283a45303d3eea
exposed:              True
exposed-modules:
    PostgREST.App PostgREST.AppState PostgREST.Auth PostgREST.CLI
    PostgREST.Config PostgREST.Config.Database PostgREST.Config.JSPath
    PostgREST.Config.PgVersion PostgREST.Config.Proxy
    PostgREST.ContentType PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Middleware
    PostgREST.OpenAPI PostgREST.Query.QueryBuilder
    PostgREST.Query.SqlFragment PostgREST.Query.Statements
    PostgREST.RangeQuery PostgREST.Request.ApiRequest
    PostgREST.Request.DbRequestBuilder PostgREST.Request.Parsers
    PostgREST.Request.Preferences PostgREST.Request.Types
    PostgREST.Unix PostgREST.Version PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.0.1/site-local/postgrest-8.0.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/postgrest-8.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/postgrest-8.0.0
hs-libraries:         HSpostgrest-8.0.0-DTGFecm68zUIfI0023oJUU
depends:
    HTTP-4000.3.16-DakrwPCsYMf7etNpNbR82M
    Ranged-sets-0.4.0-LxdXSIdHskDLgmrmTzRb8Y
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    ansi-wl-pprint-0.6.9-IaSywr9DY1zKJuO3E6UeUv
    auto-update-0.1.6-2vR8sjZEtEqBYdmKoWmRqa base-4.15.0.0
    base64-bytestring-1.2.1.0-BH3if0BufO51UJ74fSwj5E
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-J1gQtd73c5YHY9YtfdlefR
    cassava-0.5.2.0-BRuzc4Wtv5A4PUOtXG2WXL
    configurator-pg-0.2.5-BwrRjDaOPaQLva8IjCQnin containers-0.6.4.1
    contravariant-1.5.5-1Tz7FaRP9yoKqkcBKkQ76A
    contravariant-extras-0.3.5.3-BOMA4yOBKRZGllUFtzIpFa
    cookie-0.4.5-KsNYn2KTPEnIdTHNDYXGny directory-1.3.6.1
    either-5.0.1.1-G5W4rd5K8xuDISfnWigtKP
    fast-logger-3.0.5-5U7Yc1ziI2k64PjTJWcPvL
    gitrev-1.3.1-3S5hdXPxjE4SlzdPOZm45
    hasql-1.4.5.3-JLbtY16ycEAHtjCVIlxeFr
    hasql-dynamic-statements-0.3.1-9pLE9ySTHAvF51yghIetjD
    hasql-notifications-0.2.0.0-71UzQnV2XtK5oQXe9jmEB4
    hasql-pool-0.5.2-7sgBlNuaTdn7TSXoQzUUHZ
    hasql-transaction-1.0.1-88Ign9ozOAUBBQy9o2YuQe
    heredoc-0.2.0.0-8dCyZiJbseXB5fmMncY7ZS
    http-types-0.12.3-5xSWCbzPZMJ3FKkHNvWW2m
    insert-ordered-containers-0.2.5-I3JJphhz6As6TxM2MZmhF3
    interpolatedstring-perl6-1.0.2-9uBPbSqEcnI1jrNPUtBesI
    jose-0.8.5-1lRjkWdKGCOFP7Un6y9hCN lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    lens-aeson-1.1.2-5O7cnRDHxMx8EZQitlbBW3 mtl-2.2.2
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    optparse-applicative-0.16.1.0-2gAu0ltAuRsE34mFhrRUQs
    parsec-3.1.14.0 protolude-0.3.0-DadyjsAgkzo8Jpxke6KwZB
    regex-tdfa-1.3.1.1-8KBKH3EsotI2v3BWqoG8PB
    retry-0.9.0.0-8DwWynV2fIr3oSO2pTuqHO
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV
    swagger2-2.6.1-EJUaSpsAg0iDwV0H6k8Zjd text-1.2.4.1 time-1.9.3
    unix-2.7.2.2 unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3
    wai-3.2.3-5Y0o3GgLhLBDIUVnFhg417
    wai-cors-0.2.7-11ccpD9KI9FEgc0vD0zokq
    wai-extra-3.1.7-7O6xxSYSpPwLxUDTZSwbv3
    wai-logger-2.3.6-69MmnhLjdcACWrxL6PTX4o
    wai-middleware-static-0.9.1-8IhooT7QK2VG64DscT1JU8
    warp-3.3.18-FG6iRvxgYKDGN1ukLWsD2N

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

