/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.codeInsight.completion.PyMultipleArgumentsCompletionContributor;
import com.jetbrains.python.psi.PyReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class PythonCompletionWeigher
extends CompletionWeigher {
    public static final int PRIORITY_WEIGHT = 5;
    public static final int WEIGHT_FOR_MULTIPLE_ARGUMENTS = 5;
    public static final int WEIGHT_FOR_KEYWORDS = 0;
    private static final Logger LOG = Logger.getInstance(PythonCompletionWeigher.class);
    public static final String COLLECTION_KEY = "dict key";
    private static final int COLLECTION_KEY_WEIGHT = 10;

    public Comparable weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        if (element == null) {
            PythonCompletionWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            PythonCompletionWeigher.$$$reportNull$$$0(1);
        }
        if (!PsiUtilCore.findLanguageFromElement((PsiElement)location.getCompletionParameters().getPosition()).isKindOf((Language)PythonLanguage.getInstance())) {
            return Integer.valueOf(-1000000);
        }
        String name = element.getLookupString();
        LookupElementPresentation presentation = LookupElementPresentation.renderElement((LookupElement)element);
        if (COLLECTION_KEY.equals(presentation.getTypeText())) {
            return Integer.valueOf(10);
        }
        PsiElement psiElement = element.getPsiElement();
        PsiFile file = location.getCompletionParameters().getOriginalFile();
        if (psiElement != null) {
            if (psiElement.getContainingFile() == file) {
                return Integer.valueOf(5);
            }
            PsiElement dummyParent = location.getCompletionParameters().getPosition().getParent();
            boolean isQualified = dummyParent instanceof PyReferenceExpression && ((PyReferenceExpression)dummyParent).isQualified();
            int completionWeight = PyCompletionUtilsKt.computeCompletionWeight(psiElement, name, null, file, isQualified);
            LOG.debug("Combined weight for completion item ", new Object[]{name, ": ", completionWeight});
            return Integer.valueOf(completionWeight);
        }
        if (PyNames.isReserved(element.getLookupString())) {
            return Integer.valueOf(0);
        }
        if (element.getUserData(PyMultipleArgumentsCompletionContributor.Companion.getMULTIPLE_ARGUMENTS_VARIANT_KEY()) != null) {
            return Integer.valueOf(5);
        }
        return Integer.valueOf(-1000000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/completion/PythonCompletionWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

