/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.transport.server;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.python.console.transport.DirectedMessage;
import com.jetbrains.python.console.transport.DirectedMessageCodec;
import com.jetbrains.python.console.transport.DirectedMessageHandler;
import com.jetbrains.python.console.transport.TCumulativeTransport;
import com.jetbrains.python.console.transport.server.ServerClosedException;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00172\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0006\u0010\u0016\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport;", "Lorg/apache/thrift/transport/TServerTransport;", "host", "", "port", "", "(Ljava/lang/String;I)V", "nettyServer", "Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$NettyServer;", "acceptImpl", "Lorg/apache/thrift/transport/TTransport;", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "close", "", "getReverseTransport", "interrupt", "listen", "waitForBind", "Companion", "NettyServer", "TNettyClientTransport", "TNettyTransport", "intellij.python.community.impl"})
public final class TNettyServerTransport
extends TServerTransport {
    private final NettyServer nettyServer;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public void listen() throws TTransportException {
        try {
            this.nettyServer.listen();
        }
        catch (InterruptedException e) {
            throw (Throwable)new TTransportException((Throwable)e);
        }
    }

    public final void waitForBind() throws InterruptedException {
        this.nettyServer.waitForBind();
    }

    public final boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.nettyServer.awaitTermination(timeout, unit);
    }

    @NotNull
    protected TTransport acceptImpl() {
        return this.nettyServer.accept();
    }

    public void interrupt() {
        this.close();
    }

    public void close() {
        this.nettyServer.close();
    }

    @NotNull
    public final TTransport getReverseTransport() throws InterruptedException {
        return this.nettyServer.takeReverseTransport();
    }

    public TNettyServerTransport(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.nettyServer = new NettyServer(host, port);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(TNettyServerTransport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(TNett\u2026verTransport::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\u001eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$NettyServer;", "", "host", "", "port", "", "(Ljava/lang/String;I)V", "acceptQueue", "Ljava/util/concurrent/BlockingQueue;", "Lorg/apache/thrift/transport/TTransport;", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getHost", "()Ljava/lang/String;", "getPort", "()I", "reverseTransportQueue", "serverBound", "Ljava/util/concurrent/CountDownLatch;", "workerGroup", "accept", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "close", "", "listen", "takeReverseTransport", "waitForBind", "intellij.python.community.impl"})
    private static final class NettyServer {
        private final AtomicBoolean closed;
        private final BlockingQueue<TTransport> acceptQueue;
        private final BlockingQueue<TTransport> reverseTransportQueue;
        private final NioEventLoopGroup bossGroup;
        private final NioEventLoopGroup workerGroup;
        private final CountDownLatch serverBound;
        @NotNull
        private final String host;
        private final int port;

        public final void listen() {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
                final /* synthetic */ NettyServer this$0;

                protected void initChannel(@NotNull SocketChannel ch) throws Exception {
                    Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                    TNettyServerTransport.Companion.getLOG().debug("Connection to Thrift server on " + this.this$0.getPort() + " received");
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new LoggingHandler('#' + TNettyServerTransport.class.getName())});
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4)});
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new LengthFieldPrepender(4)});
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new DirectedMessageCodec()});
                    TNettyTransport thriftTransport = new TNettyTransport(ch);
                    TNettyClientTransport reverseTransport = new TNettyClientTransport(ch);
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new DirectedMessageHandler(reverseTransport.getOutputStream(), thriftTransport.getOutputStream())});
                    ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new ChannelInboundHandlerAdapter(thriftTransport, reverseTransport){
                        final /* synthetic */ TNettyTransport $thriftTransport;
                        final /* synthetic */ TNettyClientTransport $reverseTransport;

                        public void channelInactive(@NotNull ChannelHandlerContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            this.$thriftTransport.close();
                            this.$reverseTransport.close();
                            super.channelInactive(ctx);
                        }
                        {
                            this.$thriftTransport = $captured_local_variable$0;
                            this.$reverseTransport = $captured_local_variable$1;
                        }
                    }});
                    NettyServer.access$getAcceptQueue$p(this.this$0).put(thriftTransport);
                    NettyServer.access$getReverseTransportQueue$p(this.this$0).put(reverseTransport);
                }
                {
                    this.this$0 = this$0;
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.bind(this.host, this.port).sync();
            Companion.getLOG().debug("Running Netty server on " + this.port);
            this.serverBound.countDown();
        }

        public final void waitForBind() throws InterruptedException {
            while (!this.closed.get()) {
                if (!this.serverBound.await(100L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            throw (Throwable)new ServerClosedException();
        }

        @NotNull
        public final TTransport accept() {
            try {
                TTransport acceptedTransport;
                do {
                    acceptedTransport = this.acceptQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (!this.closed.get()) continue;
                    throw (Throwable)new TTransportException("Netty server is closed");
                } while (acceptedTransport == null);
                return acceptedTransport;
            }
            catch (InterruptedException e) {
                throw (Throwable)new TTransportException((Throwable)e);
            }
        }

        @NotNull
        public final TTransport takeReverseTransport() throws InterruptedException {
            while (!this.closed.get()) {
                TTransport element = this.reverseTransportQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (element == null) continue;
                return element;
            }
            throw (Throwable)new ServerClosedException();
        }

        public final void close() {
            if (this.closed.compareAndSet(false, true)) {
                Companion.getLOG().debug("Closing Netty server");
                this.workerGroup.shutdownGracefully();
                this.bossGroup.shutdownGracefully();
            }
        }

        public final boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return this.workerGroup.awaitTermination(timeout, unit) && this.bossGroup.awaitTermination(timeout, unit);
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        public NettyServer(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
            this.port = port;
            this.closed = new AtomicBoolean(false);
            this.acceptQueue = new LinkedBlockingQueue();
            this.reverseTransportQueue = new LinkedBlockingQueue();
            this.bossGroup = new NioEventLoopGroup(0, ConcurrencyUtil.newNamedThreadFactory((String)"Python Console NIO Event Loop Boss"));
            this.workerGroup = new NioEventLoopGroup(0, ConcurrencyUtil.newNamedThreadFactory((String)"Python Console NIO Event Loop Worker"));
            this.serverBound = new CountDownLatch(1);
        }

        public static final /* synthetic */ BlockingQueue access$getAcceptQueue$p(NettyServer $this) {
            return $this.acceptQueue;
        }

        public static final /* synthetic */ BlockingQueue access$getReverseTransportQueue$p(NettyServer $this) {
            return $this.reverseTransportQueue;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$TNettyTransport;", "Lcom/jetbrains/python/console/transport/TCumulativeTransport;", "channel", "Lio/netty/channel/socket/SocketChannel;", "(Lio/netty/channel/socket/SocketChannel;)V", "isOpen", "", "readAll", "", "buf", "", "off", "len", "writeMessage", "", "content", "intellij.python.community.impl"})
    private static final class TNettyTransport
    extends TCumulativeTransport {
        private final SocketChannel channel;

        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void writeMessage(@NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.channel.writeAndFlush((Object)new DirectedMessage(DirectedMessage.MessageDirection.RESPONSE, content2));
        }

        public int readAll(@NotNull byte[] buf, int off, int len) {
            int got;
            int ret;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            for (got = 0; got < len; got += ret) {
                ret = this.read(buf, off + got, len - got);
                if (ret > 0) continue;
                if (got == 0) {
                    throw (Throwable)new TTransportException(4);
                }
                throw (Throwable)new TTransportException("Cannot read. Remote side has closed. Tried to read " + len + " bytes, but only got " + got + " bytes. (This is often indicative of an internal error on the server side. Please check your server logs.)");
            }
            return got;
        }

        public TNettyTransport(@NotNull SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$TNettyClientTransport;", "Lcom/jetbrains/python/console/transport/TCumulativeTransport;", "channel", "Lio/netty/channel/socket/SocketChannel;", "(Lio/netty/channel/socket/SocketChannel;)V", "isOpen", "", "writeMessage", "", "content", "", "intellij.python.community.impl"})
    private static final class TNettyClientTransport
    extends TCumulativeTransport {
        private final SocketChannel channel;

        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void writeMessage(@NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.channel.writeAndFlush((Object)new DirectedMessage(DirectedMessage.MessageDirection.REQUEST, content2));
        }

        public TNettyClientTransport(@NotNull SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

