/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001e*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0004\u001d\u001e\u001f B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor;", "T", "", "threadsName", "", "recurrentTask", "Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$RecurrentTask;", "callback", "Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$Callback;", "(Ljava/lang/String;Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$RecurrentTask;Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$Callback;)V", "activeRequests", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "lastRequestAttemptTime", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "notZeroRequests", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "timeCondition", "dispose", "", "hasActiveRequests", "", "incrementRequests", "tryToPerformTaskAndHandleSuccess", "waitForRequests", "Callback", "Companion", "RecurrentTask", "TaskRunnable", "intellij.python.pydev"})
public final class RecurrentTaskExecutor<T> {
    private final ExecutorService executorService;
    private final ReentrantLock lock;
    private int activeRequests;
    private final Condition notZeroRequests;
    private final Condition timeCondition;
    private long lastRequestAttemptTime;
    private final RecurrentTask<T> recurrentTask;
    private final Callback<T> callback;
    private static final int FIXED_THREAD_POOL_SIZE = 10;
    private static final Logger LOG;
    private static final long PERFORM_TASK_ATTEMPT_DELAY;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementRequests() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            int n = this.activeRequests;
            this.activeRequests = n + 1;
            this.notZeroRequests.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void dispose() {
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitForRequests() throws InterruptedException {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            while (true) {
                long currentTime;
                long timeToStart;
                if (!this.hasActiveRequests()) {
                    this.notZeroRequests.await();
                    continue;
                }
                while ((timeToStart = this.lastRequestAttemptTime + PERFORM_TASK_ATTEMPT_DELAY) > (currentTime = System.nanoTime())) {
                    long timeToSleep = timeToStart - currentTime;
                    this.timeCondition.awaitNanos(timeToSleep);
                    if (this.hasActiveRequests()) continue;
                }
                if (this.hasActiveRequests()) break;
            }
            this.lastRequestAttemptTime = System.nanoTime();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean hasActiveRequests() {
        return this.activeRequests > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryToPerformTaskAndHandleSuccess() throws Exception, InterruptedException {
        T requestResult = this.recurrentTask.tryToPerform();
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            int n = this.activeRequests;
            this.activeRequests = n + -1;
            this.lastRequestAttemptTime = System.nanoTime() - PERFORM_TASK_ATTEMPT_DELAY;
            this.timeCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.callback.onSuccess(requestResult);
    }

    public RecurrentTaskExecutor(@NotNull String threadsName, @NotNull RecurrentTask<? extends T> recurrentTask, @NotNull Callback<? super T> callback) {
        Intrinsics.checkNotNullParameter((Object)threadsName, (String)"threadsName");
        Intrinsics.checkNotNullParameter(recurrentTask, (String)"recurrentTask");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.recurrentTask = recurrentTask;
        this.callback = callback;
        this.lock = new ReentrantLock();
        this.notZeroRequests = this.lock.newCondition();
        this.timeCondition = this.lock.newCondition();
        this.lastRequestAttemptTime = System.nanoTime();
        ThreadFactory threadFactory = ConcurrencyUtil.newNamedThreadFactory((String)threadsName);
        Intrinsics.checkNotNullExpressionValue((Object)threadFactory, (String)"ConcurrencyUtil.newNamedThreadFactory(threadsName)");
        ThreadFactory threadFactory2 = threadFactory;
        ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactory2);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newFixedThread\u2026POOL_SIZE, threadFactory)");
        this.executorService = executorService;
        int n = 10;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            this.executorService.submit(new TaskRunnable());
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RecurrentTaskExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Recur\u2026TaskExecutor::class.java)");
        LOG = logger;
        PERFORM_TASK_ATTEMPT_DELAY = TimeUnit.MILLISECONDS.toNanos(500L);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$TaskRunnable;", "Ljava/lang/Runnable;", "(Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor;)V", "run", "", "intellij.python.pydev"})
    private final class TaskRunnable
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    RecurrentTaskExecutor.this.waitForRequests();
                    RecurrentTaskExecutor.this.tryToPerformTaskAndHandleSuccess();
                    continue;
                }
                catch (InterruptedException e) {
                    if (RecurrentTaskExecutor.this.executorService.isShutdown()) {
                        return;
                    }
                    LOG.debug((Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002J\r\u0010\u0003\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$RecurrentTask;", "T", "", "tryToPerform", "()Ljava/lang/Object;", "intellij.python.pydev"})
    public static interface RecurrentTask<T> {
        public T tryToPerform() throws Exception, InterruptedException;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00002\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$Callback;", "T", "", "onSuccess", "", "result", "(Ljava/lang/Object;)V", "intellij.python.pydev"})
    public static interface Callback<T> {
        public void onSuccess(T var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/debugger/pydev/RecurrentTaskExecutor$Companion;", "", "()V", "FIXED_THREAD_POOL_SIZE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PERFORM_TASK_ATTEMPT_DELAY", "", "intellij.python.pydev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

