/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedElementContainer;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodFirstArgAssignmentInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMethodFirstArgAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMethodFirstArgAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        private void complain(PsiElement element, String name) {
            this.registerProblem(element, PyPsiBundle.message("INSP.first.arg.assign.method.parameter.reassigned", name));
        }

        private void handleTarget(PyQualifiedExpression target, String name) {
            if (!target.isQualified() && name.equals(target.getText())) {
                this.complain((PsiElement)target, name);
            }
        }

        @Nullable
        private static String extractFirstParamName(PyElement node) {
            List<PsiElement> place = PyUtil.searchForWrappingMethod((PsiElement)node, true);
            if (place == null || place.size() < 2) {
                return null;
            }
            PyFunction method = (PyFunction)place.get(place.size() - 2);
            PyParameter[] params = method.getParameterList().getParameters();
            if (params.length < 1) {
                return null;
            }
            PyNamedParameter first_parm = params[0].getAsNamed();
            if (first_parm == null) {
                return null;
            }
            if (first_parm.isKeywordContainer() || first_parm.isPositionalContainer()) {
                return null;
            }
            String first_param_name = first_parm.getName();
            if (first_param_name == null || first_param_name.length() < 1) {
                return null;
            }
            PyFunction.Modifier modifier = method.getModifier();
            if (modifier == PyFunction.Modifier.STATICMETHOD) {
                return null;
            }
            return first_param_name;
        }

        private void markNameDefiner(PyNamedElementContainer definer) {
            String first_param_name = Visitor.extractFirstParamName((PyElement)((Object)definer));
            if (first_param_name != null) {
                for (PsiNamedElement elt : definer.getNamedElements()) {
                    if (!(elt instanceof PyTargetExpression)) continue;
                    this.handleTarget((PyTargetExpression)elt, first_param_name);
                }
            }
        }

        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.markNameDefiner(node);
        }

        @Override
        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            String first_param_name;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((first_param_name = Visitor.extractFirstParamName(node)) != null) {
                PyExpression target = node.getTarget();
                if (target instanceof PyQualifiedExpression) {
                    this.handleTarget((PyQualifiedExpression)target, first_param_name);
                } else if (target instanceof PyTupleExpression) {
                    for (PyExpression elt : PyUtil.flattenedParensAndTuples(((PyTupleExpression)target).getElements())) {
                        if (!(elt instanceof PyQualifiedExpression)) continue;
                        this.handleTarget((PyQualifiedExpression)elt, first_param_name);
                    }
                }
            }
        }

        @Override
        public void visitPyForStatement(@NotNull PyForStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.markNameDefiner(node);
        }

        private void markDefinition(PyElement definer) {
            String first_param_name = Visitor.extractFirstParamName(definer);
            if (first_param_name != null && first_param_name.equals(definer.getName())) {
                this.complain(definer.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER).getPsi(), first_param_name);
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction definer) {
            if (definer == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            this.markDefinition(definer);
        }

        @Override
        public void visitPyClass(@NotNull PyClass definer) {
            if (definer == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            this.markDefinition(definer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAugAssignmentStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyForStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

