/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypedDictInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyTypedDictInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J#\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010!\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\b2\u0006\u0010!\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\b2\u0006\u0010!\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\b2\u0006\u0010!\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010!\u001a\u00020.H\u0016\u00a8\u0006/"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkValidTotality", "", "totalityValue", "Lcom/jetbrains/python/psi/PyExpression;", "checkValueIsAType", "expression", "strType", "", "getIndexExpressionValueOptions", "", "indexExpression", "inspectUpdateSequenceArgument", "sequenceElements", "", "typedDictType", "Lcom/jetbrains/python/psi/types/PyTypedDictType;", "([Lcom/jetbrains/python/psi/PyExpression;Lcom/jetbrains/python/psi/types/PyTypedDictType;)V", "matchTypedDictFieldTypeAndTotality", "", "expected", "Lcom/jetbrains/python/psi/types/PyTypedDictType$FieldTypeAndTotality;", "actual", "tryGetNameIdentifier", "Lcom/intellij/psi/PsiElement;", "element", "visitPyArgumentList", "node", "Lcom/jetbrains/python/psi/PyArgumentList;", "visitPyAssignmentStatement", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPySubscriptionExpression", "Lcom/jetbrains/python/psi/PySubscriptionExpression;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "intellij.python.psi.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyType operandType = this.myTypeEvalContext.getType(node.getOperand());
            if (!(operandType instanceof PyTypedDictType) || ((PyTypedDictType)operandType).isInferred()) {
                return;
            }
            PyExpression indexExpression = node.getIndexExpression();
            List<String> indexExpressionValueOptions = this.getIndexExpressionValueOptions(indexExpression);
            Collection collection = indexExpressionValueOptions;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                Set<String> set = ((PyTypedDictType)operandType).getFields().keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"operandType.fields.keys");
                String keyList2 = CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)visitPySubscriptionExpression.keyList.1.INSTANCE, (int)31, null);
                this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.typeddict.typeddict.key.must.be.string.literal.expected.one", keyList2));
                return;
            }
            Iterable $this$filterNot$iv = indexExpressionValueOptions;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                Map map2 = ((PyTypedDictType)operandType).getFields();
                boolean bl4 = false;
                Map map3 = map2;
                boolean bl5 = false;
                if (map3.containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonMatchingFields = (List)destination$iv$iv;
            $this$filterNot$iv = nonMatchingFields;
            bl2 = false;
            if (!$this$filterNot$iv.isEmpty()) {
                String string;
                PsiElement psiElement = (PsiElement)indexExpression;
                if (nonMatchingFields.size() == 1) {
                    string = PyPsiBundle.message("INSP.typeddict.typeddict.has.no.key", ((PyTypedDictType)operandType).getName(), nonMatchingFields.get(0));
                } else {
                    String nonMatchingFieldList2 = CollectionsKt.joinToString$default((Iterable)nonMatchingFields, null, null, null, (int)0, null, (Function1)visitPySubscriptionExpression.nonMatchingFieldList.1.INSTANCE, (int)31, null);
                    string = PyPsiBundle.message("INSP.typeddict.typeddict.has.no.keys", ((PyTypedDictType)operandType).getName(), nonMatchingFieldList2);
                }
                this.registerProblem(psiElement, string);
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression value = node.findAssignedValue();
            if (value instanceof PyCallExpression && ((PyCallExpression)value).getCallee() != null) {
                PyExpression typedDictName;
                PyExpression pyExpression = ((PyCallExpression)value).getCallee();
                Intrinsics.checkNotNull((Object)pyExpression);
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"value.callee!!");
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypedDict(pyExpression, typeEvalContext) && (typedDictName = ((PyCallExpression)value).getArgument(0, "name", PyExpression.class)) instanceof PyStringLiteralExpression && Intrinsics.areEqual((Object)node.getName(), (Object)((PyStringLiteralExpression)typedDictName).getStringValue()) ^ true) {
                    this.registerProblem((PsiElement)typedDictName, PyPsiBundle.message("INSP.typeddict.first.argument.has.to.match.variable.name", new Object[0]));
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            PyCallExpression callExpression;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getParent() instanceof PyClass) {
                PsiElement psiElement = node.getParent();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyClass");
                }
                PyClass pyClass = (PyClass)psiElement;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(pyClass, typeEvalContext)) {
                    PyExpression[] arguments;
                    PyExpression[] pyExpressionArray = arguments = node.getArguments();
                    int n = pyExpressionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PyExpression argument = pyExpressionArray[n2];
                        PyType type = this.myTypeEvalContext.getType(argument);
                        if (!(argument instanceof PyKeywordArgument) && !(type instanceof PyTypedDictType)) {
                            PyExpression pyExpression = argument;
                            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"argument");
                            TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
                            if (!PyTypedDictTypeProvider.Companion.isTypedDict(pyExpression, typeEvalContext2)) {
                                this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.typeddict.typeddict.cannot.inherit.from.non.typeddict.base.class", new Object[0]));
                            }
                        }
                        if (argument instanceof PyKeywordArgument && Intrinsics.areEqual((Object)((PyKeywordArgument)argument).getKeyword(), (Object)"total") && ((PyKeywordArgument)argument).getValueExpression() != null) {
                            PyExpression pyExpression = ((PyKeywordArgument)argument).getValueExpression();
                            Intrinsics.checkNotNull((Object)pyExpression);
                            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"argument.valueExpression!!");
                            this.checkValidTotality(pyExpression);
                        }
                        ++n2;
                    }
                    return;
                }
            }
            if (node.getCallExpression() == null) return;
            PyCallExpression pyCallExpression = callExpression = node.getCallExpression();
            Intrinsics.checkNotNull((Object)pyCallExpression);
            PyExpression callee = pyCallExpression.getCallee();
            if (callee == null) return;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypedDict(callee, typeEvalContext)) return;
            PyExpression fields = callExpression.getArgument(1, "fields", PyExpression.class);
            if (!(fields instanceof PyDictLiteralExpression)) {
                return;
            }
            PyKeyValueExpression[] pyKeyValueExpressionArray = ((PyDictLiteralExpression)fields).getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"fields.elements");
            PyKeyValueExpression[] $this$forEach$iv = pyKeyValueExpressionArray;
            boolean $i$f$forEach = false;
            PyKeyValueExpression[] pyKeyValueExpressionArray2 = $this$forEach$iv;
            int n = pyKeyValueExpressionArray2.length;
            int n3 = 0;
            while (true) {
                PyKeyValueExpression element$iv;
                if (n3 >= n) {
                    PyExpression totalityArgument = callExpression.getArgument(2, "total", PyExpression.class);
                    if (totalityArgument == null) return;
                    this.checkValidTotality(totalityArgument);
                    return;
                }
                PyKeyValueExpression it = element$iv = pyKeyValueExpressionArray2[n3];
                boolean bl = false;
                if (!(it instanceof PyKeyValueExpression)) {
                    return;
                }
                PyExpression pyExpression = it.getValue();
                this.checkValueIsAType(it.getValue(), pyExpression != null ? pyExpression.getText() : null);
                ++n3;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyClass(@NotNull PyClass node) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(node, typeEvalContext)) {
                return;
            }
            if (node.getMetaClassExpression() != null) {
                PyExpression pyExpression = node.getMetaClassExpression();
                if (pyExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyExpression");
                }
                this.registerProblem(pyExpression.getParent(), PyPsiBundle.message("INSP.typeddict.specifying.metaclass.not.allowed.in.typeddict", new Object[0]));
            }
            boolean bl = false;
            Map ancestorsFields = new LinkedHashMap();
            List list = node.getAncestorTypes(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.getAncestorTypes(myTypeEvalContext)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PyTypedDictType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List typedDictAncestors = (List)destination$iv$iv;
            Iterable $this$forEach$iv = typedDictAncestors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTypedDictType typedDict = (PyTypedDictType)element$iv;
                boolean bl2 = false;
                Map $this$forEach$iv2 = typedDict.getFields();
                boolean $i$f$forEach2 = false;
                Map map2 = $this$forEach$iv2;
                boolean bl3 = false;
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry field = element$iv2 = iterator.next();
                    boolean bl4 = false;
                    String key = (String)field.getKey();
                    PyTypedDictType.FieldTypeAndTotality value = (PyTypedDictType.FieldTypeAndTotality)field.getValue();
                    Map map3 = ancestorsFields;
                    boolean bl5 = false;
                    Map map4 = map3;
                    boolean bl6 = false;
                    if (map4.containsKey(key)) {
                        Object v = ancestorsFields.get(key);
                        Intrinsics.checkNotNull(v);
                        if (!this.matchTypedDictFieldTypeAndTotality((PyTypedDictType.FieldTypeAndTotality)v, value)) {
                            this.registerProblem((PsiElement)node.getSuperClassExpressionList(), PyPsiBundle.message("INSP.typeddict.cannot.overwrite.typeddict.field.while.merging", key));
                            continue;
                        }
                    }
                    ancestorsFields.put(key, value);
                }
            }
            PyStatementList pyStatementList = node.getStatementList();
            Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"node.statementList");
            Object[] objectArray = pyStatementList.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"node.statementList.statements");
            PyStatement singleStatement = (PyStatement)ArraysKt.singleOrNull((Object[])objectArray);
            if (singleStatement != null && singleStatement instanceof PyExpressionStatement && ((PyExpressionStatement)singleStatement).getExpression() instanceof PyNoneLiteralExpression) {
                PyExpression pyExpression = ((PyExpressionStatement)singleStatement).getExpression();
                if (pyExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyNoneLiteralExpression");
                }
                if (((PyNoneLiteralExpression)pyExpression).isEllipsis()) {
                    this.registerProblem(this.tryGetNameIdentifier((PsiElement)singleStatement), PyPsiBundle.message("INSP.typeddict.invalid.statement.in.typeddict.definition.expected.field.name.field.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                    return;
                }
            }
            node.processClassLevelDeclarations(new PsiScopeProcessor(this, ancestorsFields){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ Map $ancestorsFields;

                public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                    if (!(element instanceof PyTargetExpression)) {
                        this.this$0.registerProblem(Visitor.access$tryGetNameIdentifier(this.this$0, element), PyPsiBundle.message("INSP.typeddict.invalid.statement.in.typeddict.definition.expected.field.name.field.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                        return true;
                    }
                    if (((PyTargetExpression)element).hasAssignedValue()) {
                        this.this$0.registerProblem((PsiElement)((PyTargetExpression)element).findAssignedValue(), PyPsiBundle.message("INSP.typeddict.right.hand.side.values.are.not.supported.in.typeddict", new Object[0]));
                        return true;
                    }
                    Map map2 = this.$ancestorsFields;
                    String string = ((PyTargetExpression)element).getName();
                    boolean bl = false;
                    Map map3 = map2;
                    boolean bl2 = false;
                    if (map3.containsKey(string)) {
                        this.this$0.registerProblem(element, PyPsiBundle.message("INSP.typeddict.cannot.overwrite.typeddict.field", new Object[0]));
                        return true;
                    }
                    PyAnnotation pyAnnotation = ((PyTargetExpression)element).getAnnotation();
                    Visitor.access$checkValueIsAType(this.this$0, pyAnnotation != null ? pyAnnotation.getValue() : null, ((PyTargetExpression)element).getAnnotationValue());
                    return true;
                }
                {
                    this.this$0 = visitor2;
                    this.$ancestorsFields = map2;
                }
            });
        }

        @Override
        public void visitPyDelStatement(@NotNull PyDelStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            for (PyExpression target : node.getTargets()) {
                for (PyExpression expr : PyUtil.flattenedParensAndTuples(target)) {
                    String index;
                    PyType type;
                    if (!(expr instanceof PySubscriptionExpression) || !((type = this.myTypeEvalContext.getType(((PySubscriptionExpression)expr).getOperand())) instanceof PyTypedDictType) || ((PyTypedDictType)type).isInferred() || (index = PyEvaluator.evaluate(((PySubscriptionExpression)expr).getIndexExpression(), String.class)) == null) continue;
                    Map map2 = ((PyTypedDictType)type).getFields();
                    boolean bl = false;
                    Map map3 = map2;
                    boolean bl2 = false;
                    if (!map3.containsKey(index)) continue;
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)type).getFields().get(index);
                    Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                    if (!fieldTypeAndTotality.isRequired()) continue;
                    this.registerProblem((PsiElement)((PySubscriptionExpression)expr).getIndexExpression(), PyPsiBundle.message("INSP.typeddict.key.cannot.be.deleted", index, ((PyTypedDictType)type).getName()));
                }
            }
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            String key;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression callee = node.getCallee();
            if (!(callee instanceof PyReferenceExpression) || ((PyReferenceExpression)callee).getQualifier() == null) {
                return;
            }
            PyExpression pyExpression = ((PyReferenceExpression)callee).getQualifier();
            Intrinsics.checkNotNull((Object)pyExpression);
            PyType nodeType = this.myTypeEvalContext.getType(pyExpression);
            if (!(nodeType instanceof PyTypedDictType) || ((PyTypedDictType)nodeType).isInferred()) {
                return;
            }
            PyExpression[] arguments = node.getArguments();
            if (Intrinsics.areEqual((Object)"update", (Object)((PyReferenceExpression)callee).getName())) {
                PyExpression[] pyExpressionArray;
                if (arguments.length == 1 && arguments[0] instanceof PySequenceExpression) {
                    PyExpression pyExpression2 = arguments[0];
                    if (pyExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PySequenceExpression");
                    }
                    pyExpressionArray = ((PySequenceExpression)pyExpression2).getElements();
                } else {
                    pyExpressionArray = arguments;
                }
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"if (arguments.size == 1 \u2026).elements else arguments");
                this.inspectUpdateSequenceArgument(pyExpressionArray, (PyTypedDictType)nodeType);
            }
            if (Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) || Intrinsics.areEqual((Object)"popitem", (Object)((PyReferenceExpression)callee).getName())) {
                boolean bl;
                block24: {
                    Map $this$any$iv = ((PyTypedDictType)nodeType).getFields();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Map map2 = $this$any$iv;
                        boolean bl2 = false;
                        Iterator iterator = map2.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (!((PyTypedDictType.FieldTypeAndTotality)it.getValue()).isRequired()) continue;
                            bl = true;
                            break block24;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                    this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), PyPsiBundle.message("INSP.typeddict.this.operation.might.break.typeddict.consistency", new Object[0]), Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) ? ProblemHighlightType.WARNING : ProblemHighlightType.WEAK_WARNING);
                }
            }
            if (Intrinsics.areEqual((Object)"pop", (Object)((PyReferenceExpression)callee).getName())) {
                Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"arguments");
                Object $i$f$any = arguments;
                boolean bl = false;
                PyExpression[] pyExpressionArray = $i$f$any;
                boolean bl4 = false;
                String string = key = !(pyExpressionArray.length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null) {
                    $i$f$any = ((PyTypedDictType)nodeType).getFields();
                    bl = false;
                    pyExpressionArray = $i$f$any;
                    bl4 = false;
                    if (pyExpressionArray.containsKey(key)) {
                        PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                        Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                        if (fieldTypeAndTotality.isRequired()) {
                            ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                            this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), PyPsiBundle.message("INSP.typeddict.key.cannot.be.deleted", key, ((PyTypedDictType)nodeType).getName()));
                        }
                    }
                }
            }
            if (Intrinsics.areEqual((Object)"setdefault", (Object)((PyReferenceExpression)callee).getName())) {
                Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"arguments");
                Object $i$f$any = arguments;
                boolean bl = false;
                PyExpression[] pyExpressionArray = $i$f$any;
                boolean bl5 = false;
                String string = key = !(pyExpressionArray.length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null) {
                    $i$f$any = ((PyTypedDictType)nodeType).getFields();
                    bl = false;
                    pyExpressionArray = $i$f$any;
                    bl5 = false;
                    if (pyExpressionArray.containsKey(key)) {
                        PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                        Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                        if (!fieldTypeAndTotality.isRequired() && node.getArguments().length > 1) {
                            PyType valueType = this.myTypeEvalContext.getType(arguments[1]);
                            PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = ((PyTypedDictType)nodeType).getFields().get(key);
                            Intrinsics.checkNotNull((Object)fieldTypeAndTotality2);
                            if (!PyTypeChecker.match(fieldTypeAndTotality2.getType(), valueType, this.myTypeEvalContext)) {
                                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality3 = ((PyTypedDictType)nodeType).getFields().get(key);
                                Intrinsics.checkNotNull((Object)fieldTypeAndTotality3);
                                String string2 = PythonDocumentationProvider.getTypeName(fieldTypeAndTotality3.getType(), this.myTypeEvalContext);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PythonDocumentationProvi\u2026       myTypeEvalContext)");
                                String expectedTypeName = string2;
                                String string3 = PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PythonDocumentationProvi\u2026eType, myTypeEvalContext)");
                                String actualTypeName = string3;
                                this.registerProblem((PsiElement)arguments[1], PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedTypeName, actualTypeName));
                            }
                        }
                    }
                }
            }
            if (PyTypingTypeProvider.resolveToQualifiedNames(callee, this.myTypeEvalContext).contains("typing.Mapping.get")) {
                PyExpression pyExpression3 = node.getArgument(0, "key", PyExpression.class);
                if (pyExpression3 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression3, (String)"node.getArgument(0, \"key\u2026on::class.java) ?: return");
                PyExpression keyArgument = pyExpression3;
                String key2 = PyEvaluator.evaluate(keyArgument, String.class);
                if (key2 == null) {
                    this.registerProblem((PsiElement)keyArgument, PyPsiBundle.message("INSP.typeddict.key.should.be.string", new Object[0]));
                    return;
                }
                if (!((PyTypedDictType)nodeType).getFields().containsKey(key2)) {
                    this.registerProblem((PsiElement)keyArgument, PyPsiBundle.message("INSP.typeddict.typeddict.has.no.key", ((PyTypedDictType)nodeType).getName(), key2));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List<Pair<PyExpression, PyExpression>> list = node.getTargetsToValuesMapping();
            Intrinsics.checkNotNullExpressionValue(list, (String)"node.targetsToValuesMapping");
            List<Pair<PyExpression, PyExpression>> targetsToValuesMapping = list;
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.targets");
            PyExpression[] $this$forEach$iv = pyExpressionArray;
            boolean $i$f$forEach = false;
            PyExpression[] pyExpressionArray2 = $this$forEach$iv;
            int n = pyExpressionArray2.length;
            for (int i = 0; i < n; ++i) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Pair it;
                void $this$filterTo$iv$iv;
                String indexString;
                PyType targetType;
                PyExpression element$iv;
                PyExpression target = element$iv = pyExpressionArray2[i];
                boolean bl = false;
                if (!(target instanceof PySubscriptionExpression) || !((targetType = this.myTypeEvalContext.getType(((PySubscriptionExpression)target).getOperand())) instanceof PyTypedDictType) || (indexString = PyEvaluator.evaluate(((PySubscriptionExpression)target).getIndexExpression(), String.class)) == null) continue;
                PyType expected = ((PyTypedDictType)targetType).getElementType(indexString);
                Iterable $this$filter$iv = targetsToValuesMapping;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Pair)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((PyExpression)it.first), (Object)target)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    PyExpression pyExpression = (PyExpression)it.second;
                    collection.add(pyExpression);
                }
                List actualExpressions = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = actualExpressions;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String actualTypeName;
                    String expectedTypeName;
                    PyExpression actual = (PyExpression)element$iv2;
                    boolean bl4 = false;
                    PyType actualType = this.myTypeEvalContext.getType(actual);
                    if (PyTypeChecker.match(expected, actualType, this.myTypeEvalContext)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext), (String)"PythonDocumentationProvi\u2026ected, myTypeEvalContext)");
                    Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext), (String)"PythonDocumentationProvi\u2026lType, myTypeEvalContext)");
                    this.registerProblem((PsiElement)actual, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedTypeName, actualTypeName));
                }
            }
        }

        private final List<String> getIndexExpressionValueOptions(PyExpression indexExpression) {
            if (indexExpression == null) {
                return null;
            }
            String indexExprValue = PyEvaluator.evaluate(indexExpression, String.class);
            if (indexExprValue == null) {
                List list;
                PyType pyType = this.myTypeEvalContext.getType(indexExpression);
                if (pyType == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)pyType, (String)"myTypeEvalContext.getTyp\u2026xpression) ?: return null");
                PyType type = pyType;
                List members2 = PyTypeUtil.toStream(type).map((Function)getIndexExpressionValueOptions.members.1.INSTANCE).toList();
                if (members2.contains(null)) {
                    list = null;
                } else {
                    List list2 = members2;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"members");
                    list = CollectionsKt.filterNotNull((Iterable)list2);
                }
                return list;
            }
            return CollectionsKt.listOf((Object)indexExprValue);
        }

        private final void checkValueIsAType(PyExpression expression, String strType) {
            if (!(expression instanceof PyReferenceExpression) && !(expression instanceof PySubscriptionExpression) && !(expression instanceof PyNoneLiteralExpression) || strType == null) {
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.value.must.be.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                return;
            }
            PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(strType, (PsiElement)expression, this.myTypeEvalContext));
            if (type == null) {
                boolean bl;
                block6: {
                    Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"PyTypingTypeProvider.res\u2026ssion, myTypeEvalContext)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String qualifiedName = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"typing.Any", (Object)qualifiedName)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.value.must.be.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                }
            }
        }

        private final PsiElement tryGetNameIdentifier(PsiElement element) {
            PsiElement psiElement;
            if (element instanceof PsiNameIdentifierOwner) {
                PsiElement psiElement2 = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = element;
                }
                psiElement = psiElement2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.nameIdentifier ?: element");
            } else {
                psiElement = element;
            }
            return psiElement;
        }

        private final void checkValidTotality(PyExpression totalityValue) {
            LanguageLevel languageLevel = LanguageLevel.forElement(totalityValue.getOriginalElement());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"LanguageLevel.forElement\u2026ityValue.originalElement)");
            if (languageLevel.isPy3K() && !(totalityValue instanceof PyBoolLiteralExpression) || !CollectionsKt.listOf((Object[])new String[]{"True", "False"}).contains(totalityValue.getText())) {
                this.registerProblem((PsiElement)totalityValue, PyPsiBundle.message("INSP.typeddict.total.value.must.be.true.or.false", new Object[0]));
            }
        }

        private final boolean matchTypedDictFieldTypeAndTotality(PyTypedDictType.FieldTypeAndTotality expected, PyTypedDictType.FieldTypeAndTotality actual) {
            return expected.isRequired() == actual.isRequired() && PyTypeChecker.match(expected.getType(), actual.getType(), this.myTypeEvalContext);
        }

        private final void inspectUpdateSequenceArgument(PyExpression[] sequenceElements, PyTypedDictType typedDictType) {
            PyExpression[] $this$forEach$iv = sequenceElements;
            boolean $i$f$forEach = false;
            PyExpression[] pyExpressionArray = $this$forEach$iv;
            int n = pyExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                String actualTypeName;
                String expectedTypeName;
                PyExpression element$iv;
                PyExpression it = element$iv = pyExpressionArray[i];
                boolean bl = false;
                PsiElement key = null;
                String keyAsString = null;
                PyExpression value = null;
                if (it instanceof PyKeyValueExpression && ((PyKeyValueExpression)it).getKey() instanceof PyStringLiteralExpression) {
                    key = (PsiElement)((PyKeyValueExpression)it).getKey();
                    PyExpression pyExpression = ((PyKeyValueExpression)it).getKey();
                    if (pyExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                    }
                    keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                    value = ((PyKeyValueExpression)it).getValue();
                } else if (it instanceof PyParenthesizedExpression) {
                    PyExpression expression = PyPsiUtils.flattenParens(it);
                    if (expression == null) continue;
                    if (expression instanceof PyTupleExpression && ((PyTupleExpression)expression).getElements().length == 2 && ((PyTupleExpression)expression).getElements()[0] instanceof PyStringLiteralExpression) {
                        key = (PsiElement)((PyTupleExpression)expression).getElements()[0];
                        PyExpression pyExpression = ((PyTupleExpression)expression).getElements()[0];
                        if (pyExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                        }
                        keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                        value = ((PyTupleExpression)expression).getElements()[1];
                    }
                } else {
                    if (!(it instanceof PyKeywordArgument) || ((PyKeywordArgument)it).getValueExpression() == null) continue;
                    ASTNode aSTNode = ((PyKeywordArgument)it).getKeywordNode();
                    key = aSTNode != null ? aSTNode.getPsi() : null;
                    keyAsString = ((PyKeywordArgument)it).getKeyword();
                    value = ((PyKeywordArgument)it).getValueExpression();
                }
                LinkedHashMap<String, PyTypedDictType.FieldTypeAndTotality> fields = typedDictType.getFields();
                if (value == null) continue;
                if (keyAsString == null) {
                    this.registerProblem(key, PyPsiBundle.message("INSP.typeddict.cannot.add.non.string.key.to.typeddict", typedDictType.getName()));
                    continue;
                }
                if (!fields.containsKey(keyAsString)) {
                    this.registerProblem(key, PyPsiBundle.message("INSP.typeddict.typeddict.cannot.have.key", typedDictType.getName(), keyAsString));
                    continue;
                }
                PyType valueType = this.myTypeEvalContext.getType(value);
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = fields.get(keyAsString);
                if (PyTypeChecker.match(fieldTypeAndTotality != null ? fieldTypeAndTotality.getType() : null, valueType, this.myTypeEvalContext)) continue;
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = fields.get(keyAsString);
                Intrinsics.checkNotNull((Object)fieldTypeAndTotality2);
                Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(fieldTypeAndTotality2.getType(), this.myTypeEvalContext), (String)"PythonDocumentationProvi\u2026.type, myTypeEvalContext)");
                Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext), (String)"PythonDocumentationProvi\u2026eType, myTypeEvalContext)");
                this.registerProblem((PsiElement)value, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedTypeName, actualTypeName));
            }
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super(holder, session);
        }

        public static final /* synthetic */ PsiElement access$tryGetNameIdentifier(Visitor $this, PsiElement element) {
            return $this.tryGetNameIdentifier(element);
        }

        public static final /* synthetic */ void access$checkValueIsAType(Visitor $this, PyExpression expression, String strType) {
            $this.checkValueIsAType(expression, strType);
        }
    }
}

