/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerImpl
extends PyPackageManager {
    private static final String SETUPTOOLS_VERSION = "44.1.1";
    private static final String PIP_VERSION = "20.3.4";
    private static final String SETUPTOOLS_WHEEL_NAME = "setuptools-44.1.1-py2.py3-none-any.whl";
    private static final String PIP_WHEEL_NAME = "pip-20.3.4-py2.py3-none-any.whl";
    private static final String VIRTUALENV_ZIPAPP_NAME = "virtualenv.pyz";
    private static final int ERROR_NO_SETUPTOOLS = 3;
    private static final Logger LOG = Logger.getInstance(PyPackageManagerImpl.class);
    private static final String PACKAGING_TOOL = "packaging_tool.py";
    private static final int TIMEOUT = 600000;
    private static final String INSTALL = "install";
    private static final String UNINSTALL = "uninstall";
    protected String mySeparator;
    @Nullable
    private volatile List<PyPackage> myPackagesCache;
    private final AtomicBoolean myUpdatingCache;
    @NotNull
    private final Sdk mySdk;

    @Override
    public void refresh() {
        LOG.debug("Refreshing SDK roots and packages cache");
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Sdk sdk = this.getSdk();
            application.runWriteAction(() -> {
                VirtualFile[] files = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])files);
            });
            PythonSdkType.getInstance().setupSdkPaths(sdk);
        });
    }

    @Override
    public void installManagement() throws ExecutionException {
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(this.getSdk());
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.package.management.for.python.not.supported", new Object[]{languageLevel, LanguageLevel.PYTHON27}));
        }
        boolean success = this.updatePackagingTools();
        if (success) {
            return;
        }
        PyPackage installedSetuptools = this.refreshAndCheckForSetuptools();
        PyPackage installedPip = PyPsiPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip");
        if (installedSetuptools == null || PackageVersionComparator.VERSION_COMPARATOR.compare(installedSetuptools.getVersion(), SETUPTOOLS_VERSION) < 0) {
            this.installManagement(Objects.requireNonNull(this.getHelperPath(SETUPTOOLS_WHEEL_NAME)));
        }
        if (installedPip == null || PackageVersionComparator.VERSION_COMPARATOR.compare(installedPip.getVersion(), PIP_VERSION) < 0) {
            this.installManagement(Objects.requireNonNull(this.getHelperPath(PIP_WHEEL_NAME)));
        }
    }

    private boolean updatePackagingTools() {
        try {
            this.installUsingPipWheel("--upgrade", "--force-reinstall", "setuptools", "pip");
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        return this.refreshAndCheckForSetuptools() != null && PyPsiPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") != null;
    }

    @Nullable
    private PyPackage refreshAndCheckForSetuptools() throws ExecutionException {
        try {
            List<PyPackage> packages = this.refreshAndGetPackages(false);
            PyPackage setuptoolsPackage = PyPsiPackageUtil.findPackage(packages, "setuptools");
            return setuptoolsPackage != null ? setuptoolsPackage : PyPsiPackageUtil.findPackage(packages, "distribute");
        }
        catch (PyExecutionException e) {
            if (e.getExitCode() == 3) {
                return null;
            }
            throw e;
        }
    }

    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(0);
        }
        this.installUsingPipWheel("--no-index", name);
    }

    private void installUsingPipWheel(String ... pipArgs) throws ExecutionException {
        if (pipArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(1);
        }
        String pipWheel = this.getHelperPath(PIP_WHEEL_NAME);
        ArrayList args2 = Lists.newArrayList((Object[])new String[]{INSTALL});
        args2.addAll(Arrays.asList(pipArgs));
        this.getPythonProcessResult(pipWheel + this.mySeparator + "pip", args2, true, true, null);
    }

    @NotNull
    protected String toSystemDependentName(@NotNull String dirName) {
        if (dirName == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(2);
        }
        String string = FileUtil.toSystemDependentName((String)dirName);
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected PyPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(4);
        }
        this.mySeparator = File.separator;
        this.myPackagesCache = null;
        this.myUpdatingCache = new AtomicBoolean(false);
        this.mySdk = sdk;
        this.subscribeToLocalChanges();
        PyPackageManagers parentDisposable = sdk instanceof Disposable ? (Disposable)sdk : PyPackageManagers.getInstance();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    protected void subscribeToLocalChanges() {
        PyPackageUtil.runOnChangeUnderInterpreterPaths(this.getSdk(), this, () -> PythonSdkType.getInstance().setupSdkPaths(this.getSdk()));
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(5);
        }
        return sdk;
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(6);
        }
        this.install(Collections.singletonList(this.parseRequirement(requirementString)), Collections.emptyList());
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements2, @NotNull List<String> extraArgs) throws ExecutionException {
        if (extraArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(7);
        }
        this.install(requirements2, extraArgs, null);
    }

    public void install(@Nullable List<PyRequirement> requirements2, @NotNull List<String> extraArgs, @Nullable String workingDir) throws ExecutionException {
        if (extraArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(8);
        }
        if (requirements2 == null) {
            return;
        }
        if (!this.hasManagement()) {
            this.installManagement();
        }
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add(INSTALL);
        boolean useUserSite = extraArgs.contains("--user");
        String proxyString = PyPackageManagerImpl.getProxyString();
        if (proxyString != null) {
            args2.add("--proxy");
            args2.add(proxyString);
        }
        args2.addAll(extraArgs);
        for (PyRequirement req : requirements2) {
            args2.addAll(req.getInstallOptions());
        }
        try {
            this.getHelperResult(args2, !useUserSite, true, workingDir);
        }
        catch (PyExecutionException e) {
            ArrayList<String> simplifiedArgs = new ArrayList<String>();
            simplifiedArgs.add(INSTALL);
            if (proxyString != null) {
                simplifiedArgs.add("--proxy");
                simplifiedArgs.add(proxyString);
            }
            simplifiedArgs.addAll(extraArgs);
            for (PyRequirement req : requirements2) {
                simplifiedArgs.addAll(req.getInstallOptions());
            }
            throw new PyExecutionException(e.getMessage(), "pip", PyPackageManagerImpl.makeSafeToDisplayCommand(simplifiedArgs), e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these requirements were installed: " + requirements2);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(9);
        }
        ArrayList<String> args2 = new ArrayList<String>();
        try {
            args2.add(UNINSTALL);
            boolean canModify = true;
            for (PyPackage pkg : packages) {
                String location;
                if (canModify && (location = pkg.getLocation()) != null) {
                    canModify = Files.isWritable(Paths.get(location, new String[0]));
                }
                args2.add(pkg.getName());
            }
            this.getHelperResult(args2, !canModify, true);
        }
        catch (PyExecutionException e) {
            throw new PyExecutionException(e.getMessage(), "pip", args2, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these packages were uninstalled: " + packages);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> packages = this.myPackagesCache;
        return packages != null ? Collections.unmodifiableList(packages) : null;
    }

    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        if (this.mySdk instanceof PyLazySdk) {
            List<PyPackage> list = List.of();
            if (list == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        try {
            LOG.debug("Collecting installed packages for the SDK " + this.mySdk.getName(), new Throwable());
            String output = this.getHelperResult(List.of("list"), false, false);
            return this.parsePackagingToolOutput(output);
        }
        catch (ProcessNotCreatedException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Not-env unit test mode, will return mock packages");
                List<PyPackage> list = List.of(new PyPackage("pip", PIP_VERSION), new PyPackage("setuptools", SETUPTOOLS_VERSION));
                if (list == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(11);
                }
                return list;
            }
            throw ex;
        }
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) throws ExecutionException {
        if (pkg == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(12);
        }
        List<PyPackage> packages = this.refreshAndGetPackages(false);
        HashSet<PyPackage> dependents = new HashSet<PyPackage>();
        for (PyPackage p : packages) {
            List<PyRequirement> requirements2 = p.getRequirements();
            for (PyRequirement requirement : requirements2) {
                if (!requirement.getName().equals(pkg.getName())) continue;
                dependents.add(p);
            }
        }
        HashSet<PyPackage> hashSet = dependents;
        if (hashSet == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        if (destinationDir == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(14);
        }
        ArrayList<String> args2 = new ArrayList<String>();
        Sdk sdk = this.getSdk();
        LanguageLevel languageLevel = PyPackageManagerImpl.getOrRequestLanguageLevelForSdk(sdk);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.creating.virtual.environment.for.python.not.supported", new Object[]{languageLevel, LanguageLevel.PYTHON27}));
        }
        if (useGlobalSite) {
            args2.add("--system-site-packages");
        }
        args2.add(destinationDir);
        try {
            this.getPythonProcessResult(Objects.requireNonNull(this.getHelperPath(VIRTUALENV_ZIPAPP_NAME)), args2, false, true, null, List.of("-S"));
        }
        catch (ExecutionException e) {
            throw new ExecutionException(PySdkBundle.message("python.creating.venv.failed.sentence", new Object[0]), (Throwable)e);
        }
        String binary = PythonSdkUtil.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + this.mySeparator + "bin" + this.mySeparator + "python";
        Object object = binary != null ? binary : binaryFallback;
        if (object == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(15);
        }
        return object;
    }

    @NotNull
    private static LanguageLevel getOrRequestLanguageLevelForSdk(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(16);
        }
        if (sdk instanceof PyDetectedSdk) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            if (flavor != null && sdk.getHomePath() != null) {
                LanguageLevel languageLevel = flavor.getLanguageLevel(sdk.getHomePath());
                if (languageLevel == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(17);
                }
                return languageLevel;
            }
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.cannot.retrieve.version", sdk.getHomePath()));
        }
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(18);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        if (module == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(19);
        }
        return Optional.ofNullable(PyPackageUtil.getRequirementsFromTxt(module)).orElseGet(() -> PyPackageUtil.findSetupPyRequires(module));
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line2) {
        if (line2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(20);
        }
        return PyRequirementParser.fromLine(line2);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text2) {
        if (text2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(21);
        }
        List<PyRequirement> list = PyRequirementParser.fromText(text2);
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        if (file == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(23);
        }
        List<PyRequirement> list = PyRequirementParser.fromFile(file);
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) throws ExecutionException {
        List<PyPackage> currentPackages = this.myPackagesCache;
        if (alwaysRefresh || currentPackages == null) {
            List<PyPackage> list;
            this.myPackagesCache = null;
            try {
                List<PyPackage> packages = this.collectPackages();
                LOG.debug("Packages installed in " + this.mySdk.getName() + ": " + packages);
                this.myPackagesCache = packages;
                ((PyPackageManager.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PACKAGE_MANAGER_TOPIC)).packagesRefreshed(this.mySdk);
                list = Collections.unmodifiableList(packages);
            }
            catch (ExecutionException e) {
                this.myPackagesCache = Collections.emptyList();
                throw e;
            }
            if (list == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<PyPackage> list = Collections.unmodifiableList(currentPackages);
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    private void refreshPackagesSynchronously() {
        PyPackageUtil.updatePackagesSynchronouslyWithGuard(this, this.myUpdatingCache);
    }

    @Nullable
    private static String getProxyString() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.getProxyLogin(), settings.getPlainProxyPassword()) : "";
            return "http://" + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT);
        }
        return null;
    }

    @NotNull
    private String getHelperResult(@NotNull List<String> args2, boolean askForSudo, boolean showProgress) throws ExecutionException {
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(27);
        }
        return this.getHelperResult(args2, askForSudo, showProgress, null);
    }

    @NotNull
    private String getHelperResult(@NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String parentDir) throws ExecutionException {
        String helperPath;
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(28);
        }
        if ((helperPath = this.getHelperPath(PACKAGING_TOOL)) == null) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.cannot.find.external.tool", PACKAGING_TOOL));
        }
        return this.getPythonProcessResult(helperPath, args2, askForSudo, showProgress, parentDir);
    }

    @Nullable
    protected String getHelperPath(@NotNull String helper) throws ExecutionException {
        if (helper == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(29);
        }
        return PythonHelpersLocator.getHelperPath(helper);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        if (path == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(30);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(31);
        }
        return this.getPythonProcessResult(path, args2, askForSudo, showProgress, workingDir, null);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir, @Nullable List<String> pyArgs) throws ExecutionException {
        if (path == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(32);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(33);
        }
        ProcessOutput output = this.getPythonProcessOutput(path, args2, askForSudo, showProgress, workingDir, pyArgs);
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.timed.out", new Object[0]), path, args2, output);
        }
        if (exitCode != 0) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.non.zero.exit.code", exitCode), path, args2, output);
        }
        String string = output.getStdout();
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir, @Nullable List<String> pyArgs) throws ExecutionException {
        ProcessOutput processOutput;
        String homePath;
        if (helperPath == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(35);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(36);
        }
        if ((homePath = this.getSdk().getHomePath()) == null) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.cannot.find.python.interpreter", this.mySdk.getName()));
        }
        if (workingDir == null) {
            workingDir = new File(homePath).getParent();
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(homePath);
        if (pyArgs != null) {
            cmdline.addAll(pyArgs);
        }
        cmdline.add(helperPath);
        cmdline.addAll(args2);
        LOG.info("Running packaging tool: " + StringUtil.join(PyPackageManagerImpl.makeSafeToDisplayCommand(cmdline), (String)" "));
        try {
            ProcessOutput result;
            GeneralCommandLine commandLine = new GeneralCommandLine(cmdline).withWorkDirectory(workingDir).withEnvironment(PySdkUtil.activateVirtualEnv(this.getSdk()));
            Map environment = commandLine.getEnvironment();
            PythonEnvUtil.setPythonUnbuffered(environment);
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            PythonEnvUtil.resetHomePathChanges(homePath, environment);
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(this.mySdk);
            if (flavor != null && flavor.commandLinePatcher() != null) {
                flavor.commandLinePatcher().patchCommandLine(commandLine);
            }
            boolean useSudo = askForSudo && PySdkExtKt.adminPermissionsNeeded(this.mySdk);
            Process process2 = useSudo ? ExecUtil.sudo((GeneralCommandLine)commandLine, (String)PySdkBundle.message("python.sdk.packaging.enter.your.password.to.make.changes", new Object[0])) : commandLine.createProcess();
            CapturingProcessHandler handler = new CapturingProcessHandler(process2, commandLine.getCharset(), commandLine.getCommandLineString());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (showProgress && indicator != null) {
                handler.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
                result = handler.runProcessWithProgressIndicator(indicator);
            } else {
                result = handler.runProcess(600000);
            }
            if (result.isCancelled()) {
                throw new RunCanceledByUserException();
            }
            result.checkSuccess(LOG);
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                String message = StringUtil.isEmptyOrSpaces((String)result.getStdout()) && StringUtil.isEmptyOrSpaces((String)result.getStderr()) ? PySdkBundle.message("python.conda.permission.denied", new Object[0]) : PySdkBundle.message("python.sdk.packaging.non.zero.exit.code", exitCode);
                throw new PyExecutionException(message, helperPath, args2, result);
            }
            processOutput = result;
        }
        catch (IOException e) {
            throw new PyExecutionException(e.getMessage(), helperPath, args2);
        }
        if (processOutput == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(37);
        }
        return processOutput;
    }

    @NotNull
    private static List<String> makeSafeToDisplayCommand(@NotNull List<String> cmdline) {
        if (cmdline == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(38);
        }
        ArrayList<String> safeCommand = new ArrayList<String>(cmdline);
        for (int i = 0; i < safeCommand.size(); ++i) {
            if (!cmdline.get(i).equals("--proxy") || i + 1 >= cmdline.size()) continue;
            safeCommand.set(i + 1, PyPackageManagerImpl.makeSafeProxyArgument(cmdline.get(i + 1)));
        }
        ArrayList<String> arrayList = safeCommand;
        if (arrayList == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    private static String makeSafeProxyArgument(@NotNull String proxyArgument) {
        block5: {
            String string;
            if (proxyArgument == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(40);
            }
            try {
                int colonIndex;
                URI proxyUri = new URI(proxyArgument);
                String credentials = proxyUri.getUserInfo();
                if (credentials == null || (colonIndex = credentials.indexOf(":")) < 0) break block5;
                String login = credentials.substring(0, colonIndex);
                String password = credentials.substring(colonIndex + 1);
                String maskedPassword = StringUtil.repeatSymbol((char)'*', (int)password.length());
                String maskedCredentials = login + ":" + maskedPassword;
                string = proxyArgument.replaceFirst(Pattern.quote(credentials), maskedCredentials);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = proxyArgument;
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private List<PyPackage> parsePackagingToolOutput(@NotNull String output) throws PyExecutionException {
        if (output == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(43);
        }
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>();
        for (String line2 : StringUtil.splitByLines((String)output)) {
            PyPackage pkg = this.parsePackaging(line2, "\t", true, PySdkBundle.message("python.sdk.packaging.invalid.output.format", new Object[0]), PACKAGING_TOOL);
            if (pkg == null) continue;
            packages.add(pkg);
        }
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    @Nullable
    protected final PyPackage parsePackaging(@NotNull @NonNls String line2, @NotNull @NonNls String separator, boolean useLocation, @NotNull @Nls String errorMessage, @NotNull @NonNls String command) throws PyExecutionException {
        List<PyRequirement> requirements2;
        List fields;
        if (line2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(45);
        }
        if (separator == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(46);
        }
        if (errorMessage == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(47);
        }
        if (command == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(48);
        }
        if ((fields = StringUtil.split((String)line2, (String)separator)).size() < 3) {
            throw new PyExecutionException(errorMessage, command, List.of());
        }
        String name = (String)fields.get(0);
        List<PyRequirement> list = requirements2 = fields.size() >= 4 ? this.parseRequirements(PyPackageManagerImpl.toMultilineString((String)fields.get(3))) : List.of();
        return "Python".equals(name) ? null : new PyPackage(name, (String)fields.get(1), useLocation ? (String)fields.get(2) : "", requirements2);
    }

    @NotNull
    private static String toMultilineString(@NotNull String string) {
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(49);
        }
        String string2 = StringUtil.join((Collection)StringUtil.split((String)string, (String)":"), (String)"\n");
        if (string2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(50);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyArgument";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRequirements";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackages";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeToDisplayCommand";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeProxyArgument";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackagingToolOutput";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "toMultilineString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installUsingPipWheel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 50: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = INSTALL;
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = UNINSTALL;
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRequirements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirement";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHelperResult";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeToDisplayCommand";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeProxyArgument";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parsePackagingToolOutput";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "parsePackaging";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "toMultilineString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

