/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetupTaskIntrospector {
    private static final Logger LOG = Logger.getInstance(SetupTaskIntrospector.class);
    private static final Map<String, List<SetupTask>> ourDistutilsTaskCache = new HashMap<String, List<SetupTask>>();
    private static final Map<String, List<SetupTask>> ourSetuptoolsTaskCache = new HashMap<String, List<SetupTask>>();
    private static final Set<String> SKIP_NAMES = ImmutableSet.of((Object)"__init__.py", (Object)"alias.py", (Object)"setopt.py", (Object)"savecfg.py");

    @Nullable
    public static List<SetupTask.Option> getSetupTaskOptions(Module module, String taskName) {
        for (SetupTask task2 : SetupTaskIntrospector.getTaskList(module)) {
            if (!task2.getName().equals(taskName)) continue;
            return task2.getOptions();
        }
        return null;
    }

    @NotNull
    public static List<SetupTask> getTaskList(Module module) {
        PyFile setupPy = PyPackageUtil.findSetupPy(module);
        return SetupTaskIntrospector.getTaskList(module, setupPy != null && PyPsiUtils.containsImport(setupPy, "setuptools"));
    }

    @NotNull
    private static List<SetupTask> getTaskList(@NotNull Module module, boolean setuptools) {
        PsiDirectory commandDir;
        QualifiedName name;
        PsiElement install2;
        if (module == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(0);
        }
        if ((install2 = PyResolveImportUtil.resolveTopLevelMember(name = QualifiedName.fromDottedString((String)((setuptools ? "setuptools" : "distutils") + ".command.install.install")), PyResolveImportUtil.fromModule(module))) instanceof PyClass && (commandDir = install2.getContainingFile().getParent()) != null) {
            String path;
            Map<String, List<SetupTask>> cache2 = setuptools ? ourSetuptoolsTaskCache : ourDistutilsTaskCache;
            List<SetupTask> tasks = cache2.get(path = commandDir.getVirtualFile().getPath());
            if (tasks == null) {
                tasks = SetupTaskIntrospector.collectTasks(module, commandDir, setuptools);
                cache2.put(path, tasks);
            }
            List<SetupTask> list = tasks;
            if (list == null) {
                SetupTaskIntrospector.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<SetupTask> list = Collections.emptyList();
        if (list == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<SetupTask> collectTasks(@NotNull Module module, @NotNull PsiDirectory commandDir, boolean setuptools) {
        PsiFile file;
        QualifiedName name;
        PsiElement bdistWheel;
        if (module == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(3);
        }
        if (commandDir == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(4);
        }
        ArrayList<SetupTask> result = new ArrayList<SetupTask>();
        for (PsiFile commandFile : commandDir.getFiles()) {
            if (!(commandFile instanceof PyFile) || SKIP_NAMES.contains(commandFile.getName())) continue;
            String taskName = FileUtilRt.getNameWithoutExtension((String)commandFile.getName());
            result.add(SetupTaskIntrospector.createTaskFromFile((PyFile)commandFile, taskName, setuptools));
        }
        if (setuptools && (bdistWheel = PyResolveImportUtil.resolveTopLevelMember(name = QualifiedName.fromComponents((String[])new String[]{"wheel", "bdist_wheel", "bdist_wheel"}), PyResolveImportUtil.fromModule(module))) instanceof PyClass && (file = bdistWheel.getContainingFile()) instanceof PyFile) {
            result.add(SetupTaskIntrospector.createTaskFromFile((PyFile)file, "bdist_wheel", true));
        }
        ArrayList<SetupTask> arrayList = result;
        if (arrayList == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static SetupTask createTaskFromFile(PyFile file, @NotNull @NlsSafe String name, boolean setuptools) {
        PyClass taskClass;
        if (name == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(6);
        }
        SetupTask task2 = new SetupTask(name);
        PyClass pyClass = taskClass = name.equals("build_ext") && setuptools ? PyClassNameIndex.findClass("distutils.command.build_ext.build_ext", file.getProject()) : file.findTopLevelClass(name);
        if (taskClass != null) {
            String descriptionText;
            PyTargetExpression description = taskClass.findClassAttribute("description", true, null);
            if (description != null && (descriptionText = PyPsiUtils.strValue(PyPsiUtils.flattenParens(description.findAssignedValue()))) != null) {
                task2.setDescription(descriptionText);
            }
            List<PyExpression> booleanOptions = SetupTaskIntrospector.resolveSequenceValue(taskClass, "boolean_options");
            ArrayList<String> booleanOptionsList = new ArrayList<String>();
            for (PyExpression option : booleanOptions) {
                String s = PyPsiUtils.strValue(option);
                if (s == null) continue;
                booleanOptionsList.add(s);
            }
            PyTargetExpression negativeOpt = taskClass.findClassAttribute("negative_opt", true, null);
            Map<String, String> negativeOptMap = negativeOpt == null ? Collections.emptyMap() : SetupTaskIntrospector.parseNegativeOpt(negativeOpt.findAssignedValue());
            List<PyExpression> userOptions = SetupTaskIntrospector.resolveSequenceValue(taskClass, "user_options");
            for (PyExpression element : userOptions) {
                SetupTask.Option option = SetupTaskIntrospector.createOptionFromTuple(element, booleanOptionsList, negativeOptMap);
                if (option == null) continue;
                task2.addOption(option);
            }
        }
        return task2;
    }

    private static List<PyExpression> resolveSequenceValue(PyClass aClass, String name) {
        ArrayList<PyExpression> result = new ArrayList<PyExpression>();
        SetupTaskIntrospector.collectSequenceElements(aClass.findClassAttribute(name, true, null), result);
        return result;
    }

    private static void collectSequenceElements(PsiElement value, List<PyExpression> result) {
        if (value instanceof PySequenceExpression) {
            Collections.addAll(result, ((PySequenceExpression)value).getElements());
        } else if (value instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)value;
            if (binaryExpression.isOperator("+")) {
                SetupTaskIntrospector.collectSequenceElements((PsiElement)binaryExpression.getLeftExpression(), result);
                SetupTaskIntrospector.collectSequenceElements((PsiElement)binaryExpression.getRightExpression(), result);
            }
        } else if (value instanceof PyReferenceExpression) {
            TypeEvalContext context = TypeEvalContext.codeInsightFallback(value.getProject());
            PsiElement resolveResult = ((PyReferenceExpression)value).getReference(PyResolveContext.defaultContext(context)).resolve();
            SetupTaskIntrospector.collectSequenceElements(resolveResult, result);
        } else if (value instanceof PyTargetExpression) {
            SetupTaskIntrospector.collectSequenceElements((PsiElement)((PyTargetExpression)value).findAssignedValue(), result);
        }
    }

    private static Map<String, String> parseNegativeOpt(PyExpression dict) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((dict = PyPsiUtils.flattenParens(dict)) instanceof PyDictLiteralExpression) {
            PyKeyValueExpression[] elements;
            for (PyKeyValueExpression element : elements = ((PyDictLiteralExpression)dict).getElements()) {
                String key = PyPsiUtils.strValue(PyPsiUtils.flattenParens(element.getKey()));
                String value = PyPsiUtils.strValue(PyPsiUtils.flattenParens(element.getValue()));
                if (key == null || value == null) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    @Nullable
    private static SetupTask.Option createOptionFromTuple(PyExpression tuple, List<String> booleanOptions, Map<String, String> negativeOptMap) {
        PyExpression[] elements;
        if ((tuple = PyPsiUtils.flattenParens(tuple)) instanceof PyTupleExpression && (elements = ((PyTupleExpression)tuple).getElements()).length == 3) {
            String name = PyPsiUtils.strValue(elements[0]);
            String description = PyPsiUtils.strValue(elements[2]);
            if (name != null && description != null) {
                if (negativeOptMap.containsKey(name)) {
                    return null;
                }
                if (description.contains("don't use") || description.contains("deprecated")) {
                    return null;
                }
                boolean checkbox = booleanOptions.contains(name);
                boolean negative = false;
                if (negativeOptMap.containsValue(name)) {
                    negative = true;
                    for (Map.Entry<String, String> entry : negativeOptMap.entrySet()) {
                        if (!entry.getValue().equals(name)) continue;
                        name = entry.getKey();
                        break;
                    }
                }
                return new SetupTask.Option(name, StringUtil.capitalize((String)description), checkbox, negative);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/setupPy/SetupTaskIntrospector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/setupPy/SetupTaskIntrospector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTaskList";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectTasks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTaskFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

