/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.ImmutableList;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.psi.PyPsiFacade;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    PYTHON24(204),
    PYTHON25(205),
    PYTHON26(206),
    PYTHON27(207),
    PYTHON30(300),
    PYTHON31(301),
    PYTHON32(302),
    PYTHON33(303),
    PYTHON34(304),
    PYTHON35(305),
    PYTHON36(306),
    PYTHON37(307),
    PYTHON38(308),
    PYTHON39(309),
    PYTHON310(310);

    public static final List<LanguageLevel> SUPPORTED_LEVELS;
    private static final LanguageLevel DEFAULT2;
    private static final LanguageLevel DEFAULT3;
    @ApiStatus.Internal
    public static LanguageLevel FORCE_LANGUAGE_LEVEL;
    private final int myVersion;

    @NotNull
    public static LanguageLevel getDefault() {
        return LanguageLevel.getLatest();
    }

    private LanguageLevel(int version) {
        this.myVersion = version;
    }

    public int getMajorVersion() {
        return this.myVersion / 100;
    }

    public int getMinorVersion() {
        return this.myVersion % 100;
    }

    public boolean hasPrintStatement() {
        return this.isPython2();
    }

    public boolean isPython2() {
        return this.getMajorVersion() == 2;
    }

    public boolean isPy3K() {
        return this.getMajorVersion() == 3;
    }

    public boolean isOlderThan(@NotNull LanguageLevel other) {
        if (other == null) {
            LanguageLevel.$$$reportNull$$$0(0);
        }
        return this.myVersion < other.myVersion;
    }

    public boolean isAtLeast(@NotNull LanguageLevel other) {
        if (other == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return this.myVersion >= other.myVersion;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static LanguageLevel fromPythonVersion(@Nullable String pythonVersion) {
        if (pythonVersion == null) {
            return null;
        }
        if (pythonVersion.startsWith("2")) {
            if (pythonVersion.startsWith("2.4")) {
                return PYTHON24;
            }
            if (pythonVersion.startsWith("2.5")) {
                return PYTHON25;
            }
            if (pythonVersion.startsWith("2.6")) {
                return PYTHON26;
            }
            if (pythonVersion.startsWith("2.7")) {
                return PYTHON27;
            }
            return DEFAULT2;
        }
        if (pythonVersion.startsWith("3")) {
            if (pythonVersion.startsWith("3.0")) {
                return PYTHON30;
            }
            if (pythonVersion.startsWith("3.1.") || pythonVersion.equals("3.1")) {
                return PYTHON31;
            }
            if (pythonVersion.startsWith("3.2")) {
                return PYTHON32;
            }
            if (pythonVersion.startsWith("3.3")) {
                return PYTHON33;
            }
            if (pythonVersion.startsWith("3.4")) {
                return PYTHON34;
            }
            if (pythonVersion.startsWith("3.5")) {
                return PYTHON35;
            }
            if (pythonVersion.startsWith("3.6")) {
                return PYTHON36;
            }
            if (pythonVersion.startsWith("3.7")) {
                return PYTHON37;
            }
            if (pythonVersion.startsWith("3.8")) {
                return PYTHON38;
            }
            if (pythonVersion.startsWith("3.9")) {
                return PYTHON39;
            }
            if (pythonVersion.startsWith("3.10")) {
                return PYTHON310;
            }
            return DEFAULT3;
        }
        return LanguageLevel.getDefault();
    }

    @NotNull
    public String toPythonVersion() {
        String string = this.getMajorVersion() + "." + this.getMinorVersion();
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static LanguageLevel forElement(@NotNull PsiElement element) {
        if (element == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        LanguageLevel languageLevel = PyPsiFacade.getInstance(element.getProject()).getLanguageLevel(element);
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(4);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLatest() {
        LanguageLevel languageLevel = (LanguageLevel)((Object)ArrayUtil.getLastElement((Object[])LanguageLevel.values()));
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(5);
        }
        return languageLevel;
    }

    public String toString() {
        return this.toPythonVersion();
    }

    static {
        SUPPORTED_LEVELS = ImmutableList.copyOf((Collection)Stream.of(LanguageLevel.values()).filter(v -> v.isAtLeast(PYTHON36) || v == PYTHON27).collect(Collectors.toList()));
        DEFAULT2 = PYTHON27;
        DEFAULT3 = PYTHON310;
        FORCE_LANGUAGE_LEVEL = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/LanguageLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/LanguageLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toPythonVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOlderThan";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

