/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFQDNNames;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyEvaluator {
    @NotNull
    private final Set<PyExpression> myVisited = new HashSet<PyExpression>();
    @Nullable
    private Map<String, Object> myNamespace = null;
    private boolean myEvaluateCollectionItems = true;
    private boolean myEvaluateKeys = true;
    private boolean myEnableResolve = true;
    private boolean myAllowExpressionsAsValues = false;

    public void setNamespace(@Nullable Map<String, Object> namespace) {
        this.myNamespace = namespace;
    }

    public void setEvaluateCollectionItems(boolean evaluateCollectionItems) {
        this.myEvaluateCollectionItems = evaluateCollectionItems;
    }

    public void setAllowExpressionsAsValues(boolean allowExpressionsAsValues) {
        this.myAllowExpressionsAsValues = allowExpressionsAsValues;
    }

    public void setEvaluateKeys(boolean evaluateKeys) {
        this.myEvaluateKeys = evaluateKeys;
    }

    public void enableResolve(boolean enableResolve) {
        this.myEnableResolve = enableResolve;
    }

    @Nullable
    @Contract(value="null -> null")
    public Object evaluate(@Nullable PyExpression expression) {
        if (expression == null || this.myVisited.contains(expression)) {
            return null;
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)expression));
        this.myVisited.add(expression);
        if (expression instanceof PyParenthesizedExpression) {
            return this.evaluate(((PyParenthesizedExpression)expression).getContainedExpression());
        }
        if (expression instanceof PySequenceExpression) {
            return this.evaluateSequence((PySequenceExpression)expression);
        }
        Boolean bool = PyEvaluator.evaluateBoolean(expression);
        if (bool != null) {
            return bool;
        }
        if (expression instanceof PyCallExpression) {
            return this.evaluateCall((PyCallExpression)expression);
        }
        if (expression instanceof PyReferenceExpression) {
            return this.evaluateReference((PyReferenceExpression)expression);
        }
        if (expression instanceof PyStringLiteralExpression) {
            return ((PyStringLiteralExpression)expression).getStringValue();
        }
        if (expression instanceof PyBinaryExpression) {
            return this.evaluateBinary((PyBinaryExpression)expression);
        }
        if (expression instanceof PyNumericLiteralExpression) {
            return PyEvaluator.evaluateNumeric((PyNumericLiteralExpression)expression);
        }
        if (expression instanceof PyPrefixExpression) {
            return this.evaluatePrefix((PyPrefixExpression)expression);
        }
        return null;
    }

    @Nullable
    private static Object evaluateNumeric(@NotNull PyNumericLiteralExpression expression) {
        BigInteger value;
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(0);
        }
        if (expression.isIntegerLiteral() && (value = expression.getBigIntegerValue()) != null) {
            return PyEvaluator.fromBigInteger(value);
        }
        return null;
    }

    @Nullable
    private Object evaluateBinary(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(1);
        }
        PyElementType op = expression.getOperator();
        Object lhs = this.evaluate(expression.getLeftExpression());
        Object rhs = this.evaluate(expression.getRightExpression());
        if (op == PyTokenTypes.PLUS && lhs != null && rhs != null) {
            return this.applyPlus(lhs, rhs);
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            BigInteger first = PyEvaluator.toBigInteger((Number)lhs);
            BigInteger second = PyEvaluator.toBigInteger((Number)rhs);
            if (op == PyTokenTypes.MINUS) {
                return PyEvaluator.fromBigInteger(first.subtract(second));
            }
            if (op == PyTokenTypes.MULT) {
                return PyEvaluator.fromBigInteger(first.multiply(second));
            }
            if (op == PyTokenTypes.FLOORDIV) {
                return PyEvaluator.fromBigInteger(first.divide(second));
            }
            if (op == PyTokenTypes.LT) {
                return first.compareTo(second) < 0;
            }
            if (op == PyTokenTypes.LE) {
                return first.compareTo(second) <= 0;
            }
            if (op == PyTokenTypes.GT) {
                return first.compareTo(second) > 0;
            }
            if (op == PyTokenTypes.GE) {
                return first.compareTo(second) >= 0;
            }
            if (op == PyTokenTypes.EQEQ) {
                return first.compareTo(second) == 0;
            }
            if (op == PyTokenTypes.NE) {
                return first.compareTo(second) != 0;
            }
        } else if (lhs instanceof Boolean && rhs instanceof Boolean) {
            Boolean first = (Boolean)lhs;
            Boolean second = (Boolean)rhs;
            if (op == PyTokenTypes.AND_KEYWORD) {
                return first != false && second != false;
            }
            if (op == PyTokenTypes.OR_KEYWORD) {
                return first != false || second != false;
            }
        }
        return null;
    }

    @Nullable
    private static Boolean evaluateBoolean(@NotNull PyExpression expression) {
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(2);
        }
        if (expression instanceof PyBoolLiteralExpression) {
            return ((PyBoolLiteralExpression)expression).getValue();
        }
        if (expression instanceof PyReferenceExpression && LanguageLevel.forElement((PsiElement)expression).isPython2()) {
            String text2 = ((PyQualifiedExpression)expression).getReferencedName();
            if ("True".equals(text2)) {
                return true;
            }
            if ("False".equals(text2)) {
                return false;
            }
        }
        return null;
    }

    @Nullable
    private Object evaluatePrefix(@NotNull PyPrefixExpression expression) {
        Number number;
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(3);
        }
        if (expression.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            Boolean value = PyUtil.as(this.evaluate(expression.getOperand()), Boolean.class);
            if (value != null) {
                return value == false;
            }
        } else if (expression.getOperator() == PyTokenTypes.MINUS && (number = PyUtil.as(this.evaluate(expression.getOperand()), Number.class)) != null) {
            return PyEvaluator.fromBigInteger(PyEvaluator.toBigInteger(number).negate());
        }
        return null;
    }

    @NotNull
    protected Object evaluateSequence(@NotNull PySequenceExpression expression) {
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(4);
        }
        if (expression instanceof PyDictLiteralExpression) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (PyKeyValueExpression keyValue : ((PyDictLiteralExpression)expression).getElements()) {
                this.addRecordFromDict(result, keyValue.getKey(), keyValue.getValue());
            }
            HashMap<Object, Object> hashMap = result;
            if (hashMap == null) {
                PyEvaluator.$$$reportNull$$$0(5);
            }
            return hashMap;
        }
        List list = ContainerUtil.map((Object[])expression.getElements(), element -> this.myEvaluateCollectionItems ? this.evaluate((PyExpression)element) : element);
        if (list == null) {
            PyEvaluator.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public Object applyPlus(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs instanceof String && rhs instanceof String) {
            return (String)lhs + rhs;
        }
        if (lhs instanceof List && rhs instanceof List) {
            return ContainerUtil.concat((List)((List)lhs), (List)((List)rhs));
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            BigInteger first = PyEvaluator.toBigInteger((Number)lhs);
            BigInteger second = PyEvaluator.toBigInteger((Number)rhs);
            return PyEvaluator.fromBigInteger(first.add(second));
        }
        return null;
    }

    @Nullable
    protected Object evaluateReference(@NotNull PyReferenceExpression expression) {
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(7);
        }
        if (!expression.isQualified()) {
            if (this.myNamespace != null) {
                return this.myNamespace.get(expression.getReferencedName());
            }
            if (!this.myEnableResolve) {
                return null;
            }
            TypeEvalContext context = TypeEvalContext.codeInsightFallback(expression.getProject());
            ResolveResult[] results = expression.getReference(PyResolveContext.defaultContext(context)).multiResolve(false);
            if (results.length != 1) {
                return null;
            }
            Object result = results[0].getElement();
            if (result instanceof PyTargetExpression) {
                result = ((PyTargetExpression)result).findAssignedValue();
            }
            if (result instanceof PyExpression) {
                return this.evaluate((PyExpression)result);
            }
        }
        return null;
    }

    @Nullable
    protected Object evaluateCall(@NotNull PyCallExpression expression) {
        Object evaluatedQualifier;
        PyExpression callee;
        if (expression == null) {
            PyEvaluator.$$$reportNull$$$0(8);
        }
        PyExpression[] args2 = expression.getArguments();
        if (expression.isCalleeText("replace") && args2.length == 2 && (callee = expression.getCallee()) instanceof PyQualifiedExpression && (evaluatedQualifier = this.evaluate(((PyQualifiedExpression)callee).getQualifier())) instanceof String) {
            Iterator oldSubstring = this.evaluate(args2[0]);
            Object newSubstring = this.evaluate(args2[1]);
            if (oldSubstring instanceof String && newSubstring instanceof String) {
                return ((String)evaluatedQualifier).replace((String)((Object)oldSubstring), (String)newSubstring);
            }
        }
        if (this.myEnableResolve && NameResolverTools.isCalleeShortCut(expression, PythonFQDNNames.DICT_CLASS)) {
            Collection tuples = PsiTreeUtil.findChildrenOfType((PsiElement)expression, PyTupleExpression.class);
            if (!tuples.isEmpty()) {
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                for (PyTupleExpression tuple : tuples) {
                    PsiElement[] tupleElements = tuple.getChildren();
                    if (tupleElements.length != 2) {
                        return null;
                    }
                    PyExpression key = PyUtil.as(tupleElements[0], PyExpression.class);
                    PyExpression value = PyUtil.as(tupleElements[1], PyExpression.class);
                    if (key == null) continue;
                    this.addRecordFromDict(result, key, value);
                }
                return result;
            }
            PyExpression[] arguments = expression.getArguments();
            if (arguments.length > 0) {
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                for (PyExpression argument : arguments) {
                    PyKeywordArgument keywordArgument;
                    String keyword;
                    if (!(argument instanceof PyKeywordArgument) || (keyword = (keywordArgument = (PyKeywordArgument)argument).getKeyword()) == null) continue;
                    this.addRecordFromDict(result, keyword, keywordArgument.getValueExpression());
                }
                return result;
            }
        }
        return null;
    }

    private void addRecordFromDict(@NotNull Map<Object, Object> result, @NotNull PyExpression key, @Nullable PyExpression value) {
        if (result == null) {
            PyEvaluator.$$$reportNull$$$0(9);
        }
        if (key == null) {
            PyEvaluator.$$$reportNull$$$0(10);
        }
        result.put(this.myEvaluateKeys ? this.evaluate(key) : key, this.myEvaluateCollectionItems ? this.evaluateOrGet(value) : value);
    }

    private void addRecordFromDict(@NotNull Map<Object, Object> result, @NotNull String key, @Nullable PyExpression value) {
        if (result == null) {
            PyEvaluator.$$$reportNull$$$0(11);
        }
        if (key == null) {
            PyEvaluator.$$$reportNull$$$0(12);
        }
        result.put(key, this.myEvaluateCollectionItems ? this.evaluateOrGet(value) : value);
    }

    @NotNull
    private static BigInteger toBigInteger(@NotNull Number value) {
        if (value == null) {
            PyEvaluator.$$$reportNull$$$0(13);
        }
        BigInteger bigInteger = value instanceof Integer ? BigInteger.valueOf(((Integer)value).intValue()) : (value instanceof Long ? BigInteger.valueOf((Long)value) : (BigInteger)value);
        if (bigInteger == null) {
            PyEvaluator.$$$reportNull$$$0(14);
        }
        return bigInteger;
    }

    @NotNull
    private static Number fromBigInteger(@NotNull BigInteger value) {
        int intValue;
        if (value == null) {
            PyEvaluator.$$$reportNull$$$0(15);
        }
        if (BigInteger.valueOf(intValue = value.intValue()).equals(value)) {
            Integer n = intValue;
            if (n == null) {
                PyEvaluator.$$$reportNull$$$0(16);
            }
            return n;
        }
        long longValue = value.longValue();
        if (BigInteger.valueOf(longValue).equals(value)) {
            Long l = longValue;
            if (l == null) {
                PyEvaluator.$$$reportNull$$$0(17);
            }
            return l;
        }
        BigInteger bigInteger = value;
        if (bigInteger == null) {
            PyEvaluator.$$$reportNull$$$0(18);
        }
        return bigInteger;
    }

    @Nullable
    public static <T> T evaluate(@Nullable PyExpression expression, @NotNull Class<T> resultType) {
        if (resultType == null) {
            PyEvaluator.$$$reportNull$$$0(19);
        }
        return PyUtil.as(new PyEvaluator().evaluate(expression), resultType);
    }

    @Nullable
    public static <T> T evaluateNoResolve(@Nullable PyExpression expression, @NotNull Class<T> resultType) {
        if (resultType == null) {
            PyEvaluator.$$$reportNull$$$0(20);
        }
        PyEvaluator evaluator = new PyEvaluator();
        evaluator.enableResolve(false);
        return PyUtil.as(evaluator.evaluate(expression), resultType);
    }

    @Nullable
    public static Boolean evaluateAsBoolean(@Nullable PyExpression expression) {
        return PyEvaluator.evaluateAsBoolean(PyEvaluator.prepareEvaluatorForBoolean(true), expression);
    }

    @Nullable
    public static Boolean evaluateAsBooleanNoResolve(@Nullable PyExpression expression) {
        return PyEvaluator.evaluateAsBoolean(PyEvaluator.prepareEvaluatorForBoolean(false), expression);
    }

    public static boolean evaluateAsBoolean(@Nullable PyExpression expression, boolean defaultValue) {
        return (Boolean)ObjectUtils.notNull((Object)PyEvaluator.evaluateAsBoolean(expression), (Object)defaultValue);
    }

    public static boolean evaluateAsBooleanNoResolve(@Nullable PyExpression expression, boolean defaultValue) {
        return (Boolean)ObjectUtils.notNull((Object)PyEvaluator.evaluateAsBooleanNoResolve(expression), (Object)defaultValue);
    }

    @NotNull
    private static PyEvaluator prepareEvaluatorForBoolean(boolean enableResolve) {
        PyEvaluator evaluator = new PyEvaluator();
        evaluator.setEvaluateCollectionItems(false);
        evaluator.setEvaluateKeys(false);
        evaluator.enableResolve(enableResolve);
        PyEvaluator pyEvaluator = evaluator;
        if (pyEvaluator == null) {
            PyEvaluator.$$$reportNull$$$0(21);
        }
        return pyEvaluator;
    }

    @Nullable
    private static Boolean evaluateAsBoolean(@NotNull PyEvaluator evaluator, @Nullable PyExpression expression) {
        Object result;
        if (evaluator == null) {
            PyEvaluator.$$$reportNull$$$0(22);
        }
        if ((result = evaluator.evaluate(expression)) instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Integer) {
            return (Integer)result != 0;
        }
        if (result instanceof String) {
            return !((String)result).isEmpty();
        }
        if (result instanceof Collection) {
            return !((Collection)result).isEmpty();
        }
        if (result instanceof Map) {
            return !((Map)result).isEmpty();
        }
        return null;
    }

    @Nullable
    private Object evaluateOrGet(@Nullable PyExpression expression) {
        Object result = this.evaluate(expression);
        if (result != null) {
            return result;
        }
        return this.myAllowExpressionsAsValues ? expression : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyEvaluator";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyEvaluator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSequence";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toBigInteger";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fromBigInteger";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEvaluatorForBoolean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNumeric";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBinary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBoolean";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSequence";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCall";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addRecordFromDict";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toBigInteger";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fromBigInteger";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNoResolve";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAsBoolean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

