/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJavaClassType
implements PyClassLikeType {
    private final PsiClass myClass;
    private final boolean myDefinition;

    public PyJavaClassType(PsiClass aClass, boolean definition) {
        this.myClass = aClass;
        this.myDefinition = definition;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyJavaClassType.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            PyJavaClassType.$$$reportNull$$$0(1);
        }
        if (resolveContext == null) {
            PyJavaClassType.$$$reportNull$$$0(2);
        }
        return this.resolveMember(name, location, direction, resolveContext, true);
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        PsiMethod[] methods;
        if (name == null) {
            PyJavaClassType.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            PyJavaClassType.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            PyJavaClassType.$$$reportNull$$$0(5);
        }
        if ((methods = this.myClass.findMethodsByName(name, inherited)).length > 0) {
            ResolveResultList resultList = new ResolveResultList();
            for (PsiMethod method : methods) {
                resultList.poke((PsiElement)method, 0);
            }
            return resultList;
        }
        PsiField field = this.myClass.findFieldByName(name, inherited);
        if (field != null) {
            return ResolveResultList.to((PsiElement)field);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor(location);
        this.myClass.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial(), null, location);
        return processor2.getResult();
    }

    @Override
    @Nullable
    public String getName() {
        if (this.myClass != null) {
            return this.myClass.getName();
        }
        return null;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    @Override
    public boolean isCallable() {
        return this.myDefinition;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(6);
        }
        if (this.myDefinition) {
            return new PyJavaClassType(this.myClass, false);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(7);
        }
        if (callSite == null) {
            PyJavaClassType.$$$reportNull$$$0(8);
        }
        return this.getReturnType(context);
    }

    @Override
    public boolean isDefinition() {
        return this.myDefinition;
    }

    @Override
    @NotNull
    public PyClassLikeType toInstance() {
        PyJavaClassType pyJavaClassType = this.myDefinition ? new PyJavaClassType(this.myClass, false) : this;
        if (pyJavaClassType == null) {
            PyJavaClassType.$$$reportNull$$$0(9);
        }
        return pyJavaClassType;
    }

    @Override
    @NotNull
    public PyClassLikeType toClass() {
        return this.myDefinition ? this : new PyJavaClassType(this.myClass, true);
    }

    @Override
    @Nullable
    public String getClassQName() {
        return this.myClass.getQualifiedName();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(10);
        }
        ArrayList<PyClassLikeType> result = new ArrayList<PyClassLikeType>();
        for (PsiClass cls : this.myClass.getSupers()) {
            result.add(new PyJavaClassType(cls, this.myDefinition));
        }
        ArrayList<PyClassLikeType> arrayList = result;
        if (arrayList == null) {
            PyJavaClassType.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public void visitMembers(@NotNull Processor<? super PsiElement> processor2, boolean inherited, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyJavaClassType.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(13);
        }
        for (PsiMethod psiMethod : this.myClass.getAllMethods()) {
            processor2.process((Object)psiMethod);
        }
        for (PsiMethod psiMethod : this.myClass.getAllFields()) {
            processor2.process((Object)psiMethod);
        }
        if (!inherited) {
            return;
        }
        for (PyClassLikeType type : this.getAncestorTypes(context)) {
            if (type == null) continue;
            type.visitMembers(processor2, false, context);
        }
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(14);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiMethod psiMethod : this.myClass.getAllMethods()) {
            result.add(psiMethod.getName());
        }
        for (PsiMethod psiMethod : this.myClass.getAllFields()) {
            result.add(psiMethod.getName());
        }
        if (inherited) {
            for (PyClassLikeType type : this.getAncestorTypes(context)) {
                if (type == null) continue;
                result.addAll(type.getMemberNames(false, context));
            }
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            PyJavaClassType.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(16);
        }
        ArrayList<PyClassLikeType> result = new ArrayList<PyClassLikeType>();
        LinkedList<PsiClass> deque = new LinkedList<PsiClass>();
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        deque.addAll(Arrays.asList(this.myClass.getSupers()));
        while (!deque.isEmpty()) {
            PsiClass current = (PsiClass)deque.pollFirst();
            if (current == null || !visited.add(current)) continue;
            result.add(new PyJavaClassType(current, this.myDefinition));
            deque.addAll(Arrays.asList(current.getSupers()));
        }
        ArrayList<PyClassLikeType> arrayList = result;
        if (arrayList == null) {
            PyJavaClassType.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid();
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        if (context == null) {
            PyJavaClassType.$$$reportNull$$$0(18);
        }
        return null;
    }

    public PsiClass getPsiClass() {
        return this.myClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PyJavaClassType)) {
            return false;
        }
        PyJavaClassType type = (PyJavaClassType)o;
        if (this.myDefinition != type.myDefinition) {
            return false;
        }
        return !(this.myClass != null ? !this.myClass.equals(type.myClass) : type.myClass != null);
    }

    public int hashCode() {
        int result = this.myClass != null ? this.myClass.hashCode() : 0;
        result = 31 * result + (this.myDefinition ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyJavaClassType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyJavaClassType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitMembers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

