/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.base.Preconditions;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportResolver;
import com.jetbrains.python.psi.resolve.Priority;
import com.jetbrains.python.psi.resolve.PyNamespacePackageUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContextImpl;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil$$special$;
import com.jetbrains.python.psi.resolve.PyThirdPartySdkDetector;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001aH\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u001a#\u0010\u000f\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u00190\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\b\u001a\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\bH\u0002\u001a\u000e\u0010&\u001a\u00020#2\u0006\u0010%\u001a\u00020\b\u001a\u0010\u0010'\u001a\u00020#2\u0006\u0010%\u001a\u00020\bH\u0002\u001a(\u0010(\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010,\u001a\u00020#2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u001a\u0010-\u001a\u00020#2\u0006\u0010%\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u00101\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u00108\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u00109\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010:\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u0010<\u001a\u00020#*\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u00a8\u0006="}, d2={"cachePrefix", "Lcom/intellij/psi/util/QualifiedName;", "context", "Lcom/jetbrains/python/psi/resolve/PyQualifiedNameResolveContext;", "checkAccess", "", "filterTopPriorityResults", "", "Lcom/intellij/psi/PsiElement;", "resolved", "module", "Lcom/intellij/openapi/module/Module;", "filterTopPriorityResultsWithFallback", "primaryResults", "fallbackResults", "foreignResults", "name", "findCache", "Lcom/jetbrains/python/psi/resolve/PythonPathCache;", "firstResultWithFallback", "results", "Ljava/util/SortedMap;", "Lcom/jetbrains/python/psi/resolve/Priority;", "", "priority", "Lorg/jetbrains/annotations/Nullable;", "fromFoothold", "foothold", "fromModule", "fromSdk", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isAcceptRootAsTopLevelPackage", "", "isInProvidedSdk", "element", "isInSkeletons", "isInTypeShed", "isSameDirectoryOrRelativeImportResult", "directory", "Lcom/intellij/psi/PsiDirectory;", "result", "isSameDirectoryResult", "isUserFile", "relativeResultsForStubsFromRoots", "relativeResultsFromSkeletons", "resolveInRoot", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolveModuleAt", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "resolveModuleFromRoots", "resolveQualifiedName", "resolveTopLevelMember", "resolveWithRelativeLevel", "resolvedElementPriority", "resultsFromRoots", "topResultIs", "intellij.python.psi.impl"})
@JvmName(name="PyResolveImportUtil")
public final class PyResolveImportUtil {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final List<PsiElement> resolveQualifiedName(@NotNull QualifiedName name, @NotNull PyQualifiedNameResolveContext context) {
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                PyResolveImportUtil.checkAccess();
                if (!context.isValid()) {
                    return CollectionsKt.emptyList();
                }
                relativeDirectory = context.getContainingDirectory();
                relativeResults = PyResolveImportUtil.resolveWithRelativeLevel(name, context);
                if (relativeDirectory == null) ** GOTO lbl-1000
                $this$any$iv = relativeResults;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-any-PyResolveImportUtil$resolveQualifiedName$foundRelativeImport$1 = false;
                        if (!PyResolveImportUtil.isSameDirectoryOrRelativeImportResult(name, relativeDirectory, it, context)) continue;
                        v0 = true;
                        break block13;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            foundRelativeImport = v1;
            cache = PyResolveImportUtil.findCache(context);
            mayCache = cache != null && foundRelativeImport == false;
            key = PyResolveImportUtil.cachePrefix(context).append(name);
            if (mayCache) {
                v2 = cache;
                v3 /* !! */  = cachedResults = v2 != null ? v2.get(key) : null;
                if (cachedResults != null) {
                    return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)relativeResults, (Iterable)cachedResults));
                }
            }
            foreignResults = PyResolveImportUtil.foreignResults(name, context);
            pythonResults = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])new List[]{relativeResults, PyResolveImportUtil.resolveModuleFromRoots(name, context), PyResolveImportUtil.relativeResultsFromSkeletons(name, context)})));
            $this$partition$iv = pythonResults;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (PsiElement)element$iv;
                $i$a$-partition-PyResolveImportUtil$resolveQualifiedName$1 = false;
                if (relativeDirectory == null) ** GOTO lbl-1000
                v4 = LanguageLevel.forElement((PsiElement)relativeDirectory);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"LanguageLevel.forElement(relativeDirectory)");
                if (v4.isPython2()) lbl-1000:
                // 2 sources

                {
                    v5 = false;
                } else {
                    v5 = PyResolveImportUtil.isSameDirectoryResult(it, context, name);
                }
                if (v5) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            var12_20 = new Pair(first$iv, second$iv);
            $i$a$-any-PyResolveImportUtil$resolveQualifiedName$foundRelativeImport$1 = (List)var12_20.component1();
            notSameDirectoryPython3Results = (List)var12_20.component2();
            v6 = results = relativeDirectory != null && PyUtil.isExplicitPackage(relativeDirectory) != false ? PyResolveImportUtil.filterTopPriorityResultsWithFallback(notSameDirectoryPython3Results, (List<? extends PsiElement>)sameDirectoryPython3Results, foreignResults, name, context) : PyResolveImportUtil.filterTopPriorityResultsWithFallback((List<? extends PsiElement>)sameDirectoryPython3Results, notSameDirectoryPython3Results, foreignResults, name, context);
            if (!mayCache) break block14;
            v7 = cache;
            if (v7 != null) {
                v7.put(key, results);
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PsiElement> resolveModuleFromRoots(QualifiedName name, PyQualifiedNameResolveContext context) {
        void $this$fold$iv;
        QualifiedName qualifiedName = name.removeTail(name.getComponentCount() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"name.removeTail(name.componentCount - 1)");
        QualifiedName head = qualifiedName;
        QualifiedName qualifiedName2 = name.removeHead(1);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"name.removeHead(1)");
        QualifiedName nameNoHead = qualifiedName2;
        List list = nameNoHead.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"nameNoHead.components");
        Iterable iterable = list;
        List initial$iv = CollectionsKt.distinct((Iterable)PyResolveImportUtil.resultsFromRoots(head, context));
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void component;
            void $this$filterIsInstance$iv;
            String string = (String)element$iv;
            List results = accumulator$iv;
            boolean bl = false;
            Sequence sequence = CollectionsKt.asSequence((Iterable)PyResolveImportUtil.filterTopPriorityResults(results, context.getModule()));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)$special$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            accumulator$iv = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)sequence2, (Function1)((Function1)new Function1<PsiFileSystemItem, Sequence<? extends PsiElement>>((String)component, context){
                final /* synthetic */ String $component;
                final /* synthetic */ PyQualifiedNameResolveContext $context$inlined;
                {
                    this.$component = string;
                    this.$context$inlined = pyQualifiedNameResolveContext;
                    super(1);
                }

                @NotNull
                public final Sequence<PsiElement> invoke(@NotNull PsiFileSystemItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    QualifiedName qualifiedName = QualifiedName.fromComponents((String[])new String[]{this.$component});
                    Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"QualifiedName.fromComponents(component)");
                    return CollectionsKt.asSequence((Iterable)PyResolveImportUtil.resolveModuleAt(qualifiedName, it, this.$context$inlined));
                }
            })));
        }
        return accumulator$iv;
    }

    @Nullable
    public static final PsiElement resolveTopLevelMember(@NotNull QualifiedName name, @NotNull PyQualifiedNameResolveContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyResolveImportUtil.checkAccess();
        String string = name.getLastComponent();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.lastComponent ?: return null");
        String memberName = string;
        QualifiedName qualifiedName = name.removeLastComponent();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"name.removeLastComponent()");
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filterIsInstance((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)PyResolveImportUtil.resolveQualifiedName(qualifiedName, context)), (Function1)resolveTopLevelMember.1.INSTANCE), PyFile.class), (Function1)((Function1)new Function1<PyFile, Sequence<? extends RatedResolveResult>>(memberName){
            final /* synthetic */ String $memberName;

            @NotNull
            public final Sequence<RatedResolveResult> invoke(@NotNull PyFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                List<RatedResolveResult> list = it.multiResolveName(this.$memberName);
                Intrinsics.checkNotNullExpressionValue(list, (String)"it.multiResolveName(memberName)");
                return CollectionsKt.asSequence((Iterable)list);
            }
            {
                this.$memberName = string;
                super(1);
            }
        })), (Function1)resolveTopLevelMember.3.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiElement> resolveModuleAt(@NotNull QualifiedName name, @Nullable PsiFileSystemItem item, @NotNull PyQualifiedNameResolveContext context) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyResolveImportUtil.checkAccess();
        List empty = CollectionsKt.emptyList();
        if (item == null || !item.isValid()) {
            return empty;
        }
        List list = name.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"name.components");
        Iterable iterable = list;
        List initial$iv = CollectionsKt.listOf((Object)item);
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            List list2;
            void component;
            String string = (String)element$iv;
            List seekers = accumulator$iv;
            boolean bl = false;
            if (component == null) {
                list2 = empty;
            } else {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = seekers;
                boolean $i$f$flatMap = false;
                Iterable iterable2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List<RatedResolveResult> children2;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(ResolveImportUtil.resolveChildren(it, (String)component, context.getFootholdFile(), !context.getWithMembers(), !context.getWithPlainDirectories(), context.getWithoutStubs(), context.getWithoutForeign()), (String)"ResolveImportUtil.resolv\u2026  context.withoutForeign)");
                    Collection $this$toTypedArray$iv = children2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    RatedResolveResult[] ratedResolveResultArray = thisCollection$iv.toArray(new RatedResolveResult[0]);
                    if (ratedResolveResultArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Iterable list$iv$iv = PyUtil.filterTopPriorityResults(ratedResolveResultArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            accumulator$iv = list2;
        }
        return accumulator$iv;
    }

    @NotNull
    public static final PyQualifiedNameResolveContext fromFoothold(@NotNull PsiElement foothold) {
        Intrinsics.checkNotNullParameter((Object)foothold, (String)"foothold");
        PsiFile psiFile = foothold.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(psiFile != null ? (PsiElement)psiFile : foothold));
        PsiManager psiManager = foothold.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"foothold.manager");
        return new PyQualifiedNameResolveContextImpl(psiManager, module, foothold, PythonSdkUtil.findPythonSdk(module), 0, false, false, false, false, false, 1008, null);
    }

    @NotNull
    public static final PyQualifiedNameResolveContext fromModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(module.project)");
        return new PyQualifiedNameResolveContextImpl(psiManager, module, null, PythonSdkUtil.findPythonSdk(module), 0, false, false, false, false, false, 1008, null);
    }

    @NotNull
    public static final PyQualifiedNameResolveContext fromSdk(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        return new PyQualifiedNameResolveContextImpl(psiManager, null, null, sdk, 0, false, false, false, false, false, 1008, null);
    }

    private static final QualifiedName cachePrefix(PyQualifiedNameResolveContext context) {
        boolean bl = false;
        List results = new ArrayList();
        if (context.getWithoutStubs()) {
            results.add("without-stubs");
        }
        if (context.getWithoutForeign()) {
            results.add("without-foreign");
        }
        if (context.getWithoutRoots()) {
            results.add("without-roots");
        }
        if (context.getWithMembers()) {
            results.add("with-members");
        }
        QualifiedName qualifiedName = QualifiedName.fromComponents((Collection)results);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"QualifiedName.fromComponents(results)");
        return qualifiedName;
    }

    private static final List<PsiElement> foreignResults(QualifiedName name, PyQualifiedNameResolveContext context) {
        List list;
        if (context.getWithoutForeign()) {
            list = CollectionsKt.emptyList();
        } else {
            ExtensionPointName<PyImportResolver> extensionPointName = PyImportResolver.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"PyImportResolver.EP_NAME");
            List list2 = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"PyImportResolver.EP_NAME.extensionList");
            list = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<PyImportResolver, PsiElement>(name, context){
                final /* synthetic */ QualifiedName $name;
                final /* synthetic */ PyQualifiedNameResolveContext $context;

                @Nullable
                public final PsiElement invoke(PyImportResolver it) {
                    return it.resolveImportReference(this.$name, this.$context, !this.$context.getWithoutRoots());
                }
                {
                    this.$name = qualifiedName;
                    this.$context = pyQualifiedNameResolveContext;
                    super(1);
                }
            }))));
        }
        return list;
    }

    private static final List<PsiElement> relativeResultsFromSkeletons(QualifiedName name, PyQualifiedNameResolveContext context) {
        PsiFile footholdFile = context.getFootholdFile();
        if (context.getWithoutRoots() && footholdFile != null) {
            QualifiedName containingName;
            VirtualFile virtualFile = footholdFile.getVirtualFile();
            if (virtualFile == null || FileIndexFacade.getInstance((Project)context.getProject()).isInContent(virtualFile)) {
                return CollectionsKt.emptyList();
            }
            PsiDirectory containingDirectory = context.getContainingDirectory();
            if (containingDirectory != null && (containingName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingDirectory, null)) != null && containingName.getComponentCount() > 0) {
                QualifiedName absoluteName = containingName.append(name);
                Sdk sdk = PythonSdkUtil.findPythonSdk((PsiElement)footholdFile);
                if (sdk == null) {
                    return CollectionsKt.emptyList();
                }
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"PythonSdkUtil.findPython\u2026le) ?: return emptyList()");
                Sdk sdk2 = sdk;
                VirtualFile virtualFile2 = PythonSdkUtil.findSkeletonsDir(sdk2);
                if (virtualFile2 == null) {
                    return CollectionsKt.emptyList();
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"PythonSdkUtil.findSkelet\u2026dk) ?: return emptyList()");
                VirtualFile skeletonsVirtualFile = virtualFile2;
                PsiDirectory skeletonsDir = context.getPsiManager().findDirectory(skeletonsVirtualFile);
                QualifiedName qualifiedName = absoluteName;
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"absoluteName");
                PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)skeletonsDir;
                PyQualifiedNameResolveContext pyQualifiedNameResolveContext = context.copyWithoutForeign();
                Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"context.copyWithoutForeign()");
                return PyResolveImportUtil.resolveModuleAt(qualifiedName, psiFileSystemItem, pyQualifiedNameResolveContext);
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<PsiElement> relativeResultsForStubsFromRoots(@NotNull QualifiedName name, @NotNull PyQualifiedNameResolveContext context) {
        QualifiedName absoluteName;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context.getFootholdFile() instanceof PyiFile) || context.getRelativeLevel() <= 0) {
            return CollectionsKt.emptyList();
        }
        PsiDirectory psiDirectory = context.getContainingDirectory();
        if (psiDirectory == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"context.containingDirectory ?: return emptyList()");
        PsiDirectory containingDirectory = psiDirectory;
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingDirectory, null);
        if (qualifiedName == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"QualifiedNameFinder.find\u2026ll) ?: return emptyList()");
        QualifiedName containingName = qualifiedName;
        if (containingName.getComponentCount() <= 0) {
            return CollectionsKt.emptyList();
        }
        QualifiedName qualifiedName2 = absoluteName = containingName.append(name);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"absoluteName");
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = context.copyWithRelative(-1).copyWithRoots();
        Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"context.copyWithRelative(-1).copyWithRoots()");
        return PyResolveImportUtil.resultsFromRoots(qualifiedName2, pyQualifiedNameResolveContext);
    }

    private static final List<PsiElement> resolveWithRelativeLevel(QualifiedName name, PyQualifiedNameResolveContext context) {
        PsiFile footholdFile = context.getFootholdFile();
        if (context.getRelativeLevel() >= 0 && footholdFile != null && !PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(footholdFile)) {
            return CollectionsKt.plus((Collection)PyResolveImportUtil.resolveModuleAt(name, (PsiFileSystemItem)context.getContainingDirectory(), context), (Iterable)PyResolveImportUtil.relativeResultsForStubsFromRoots(name, context));
        }
        return CollectionsKt.emptyList();
    }

    private static final List<PsiElement> resultsFromRoots(QualifiedName name, PyQualifiedNameResolveContext context) {
        if (context.getWithoutRoots()) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List moduleResults = new ArrayList();
        boolean bl2 = false;
        List sdkResults = new ArrayList();
        Sdk sdk = context.getEffectiveSdk();
        Module module = context.getModule();
        PsiFile footholdFile = context.getFootholdFile();
        boolean withoutStubs = context.getWithoutStubs();
        RootVisitor visitor2 = new RootVisitor(moduleResults, sdkResults, context, name, withoutStubs){
            final /* synthetic */ List $moduleResults;
            final /* synthetic */ List $sdkResults;
            final /* synthetic */ PyQualifiedNameResolveContext $context;
            final /* synthetic */ QualifiedName $name;
            final /* synthetic */ boolean $withoutStubs;

            public final boolean visitRoot(VirtualFile root, @Nullable Module module, @Nullable Sdk sdk, boolean isModuleSource) {
                List results;
                block4: {
                    block5: {
                        results = isModuleSource ? this.$moduleResults : this.$sdkResults;
                        Sdk sdk2 = sdk;
                        if (sdk2 == null) {
                            sdk2 = this.$context.getEffectiveSdk();
                        }
                        Sdk effectiveSdk = sdk2;
                        VirtualFile virtualFile = root;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
                        if (!virtualFile.isValid() || Intrinsics.areEqual((Object)root, (Object)PyUserSkeletonsUtil.getUserSkeletonsDirectory()) || effectiveSdk != null && PyTypeShed.INSTANCE.isInside(root) && !PyTypeShed.INSTANCE.maySearchForStubInRoot(this.$name, root, effectiveSdk)) {
                            return true;
                        }
                        if (!this.$withoutStubs) break block4;
                        if (PyTypeShed.INSTANCE.isInside(root)) break block5;
                        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.$context.getProject()).findDirectory(root);
                        if (psiDirectory == null) break block4;
                        PsiDirectory psiDirectory2 = psiDirectory;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiDirectory it = psiDirectory2;
                        boolean bl3 = false;
                        PsiDirectory psiDirectory3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory3, (String)"it");
                        if (!PyStubPackages.isInStubPackage((PsiElement)psiDirectory3)) break block4;
                    }
                    return true;
                }
                results.addAll(PyResolveImportUtil.access$resolveInRoot(this.$name, root, this.$context));
                if (PyResolveImportUtil.access$isAcceptRootAsTopLevelPackage(this.$context) && this.$name.matchesPrefix(QualifiedName.fromDottedString((String)root.getName()))) {
                    VirtualFile virtualFile = root.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root.parent");
                    results.addAll(PyResolveImportUtil.access$resolveInRoot(this.$name, virtualFile, this.$context));
                }
                return true;
            }
            {
                this.$moduleResults = list;
                this.$sdkResults = list2;
                this.$context = pyQualifiedNameResolveContext;
                this.$name = qualifiedName;
                this.$withoutStubs = bl;
            }
        };
        if (context.getVisitAllModules()) {
            RootVisitorHost.visitRootsInAllModules(context.getProject(), visitor2);
            if (sdk != null) {
                RootVisitorHost.visitSdkRoots(sdk, visitor2);
            } else if (footholdFile != null) {
                RootVisitorHost.visitSdkRoots(footholdFile, visitor2);
            }
        } else if (module != null) {
            boolean otherSdk = Intrinsics.areEqual((Object)sdk, (Object)context.getSdk()) ^ true;
            RootVisitorHost.visitRoots(module, otherSdk, visitor2);
            if (otherSdk && sdk != null) {
                RootVisitorHost.visitSdkRoots(sdk, visitor2);
            }
        } else if (footholdFile != null) {
            RootVisitorHost.visitRoots((PsiElement)footholdFile, visitor2);
        } else if (sdk != null) {
            RootVisitorHost.visitSdkRoots(sdk, visitor2);
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return CollectionsKt.plus((Collection)moduleResults, (Iterable)sdkResults);
    }

    private static final boolean isAcceptRootAsTopLevelPackage(PyQualifiedNameResolveContext context) {
        Module module = context.getModule();
        if (module != null) {
            Module module2 = module;
            boolean bl = false;
            boolean bl2 = false;
            Module it = module2;
            boolean bl3 = false;
            Ref ref = Ref.create((Object)false);
            PyModuleService.getInstance().forAllFacets(it, (Consumer<Object>)new Consumer(ref){
                final /* synthetic */ Ref $ref;

                public final void consume(Object it) {
                    if (it instanceof PythonPathContributingFacet && ((PythonPathContributingFacet)it).acceptRootAsTopLevelPackage()) {
                        this.$ref.set((Object)true);
                    }
                }
                {
                    this.$ref = ref;
                }
            });
            Object object = ref.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ref.get()");
            return (Boolean)object;
        }
        return false;
    }

    private static final List<PsiElement> resolveInRoot(QualifiedName name, VirtualFile root, PyQualifiedNameResolveContext context) {
        return root.isDirectory() ? PyResolveImportUtil.resolveModuleAt(name, (PsiFileSystemItem)context.getPsiManager().findDirectory(root), context) : CollectionsKt.emptyList();
    }

    private static final PythonPathCache findCache(PyQualifiedNameResolveContext context) {
        PythonPathCache pythonPathCache;
        if (context.getVisitAllModules()) {
            pythonPathCache = null;
        } else if (context.getModule() != null) {
            pythonPathCache = Intrinsics.areEqual((Object)context.getEffectiveSdk(), (Object)context.getSdk()) ^ true ? null : PythonModulePathCache.getInstance(context.getModule());
        } else if (context.getFootholdFile() != null) {
            PsiFile psiFile = context.getFootholdFile();
            Intrinsics.checkNotNull((Object)psiFile);
            Sdk sdk = PyBuiltinCache.findSdkForNonModuleFile((PsiFileSystemItem)psiFile);
            pythonPathCache = sdk != null ? PythonSdkPathCache.getInstance(context.getProject(), sdk) : null;
        } else {
            pythonPathCache = null;
        }
        return pythonPathCache;
    }

    private static final boolean isSameDirectoryResult(PsiElement element, PyQualifiedNameResolveContext context, QualifiedName name) {
        boolean sameDirectoryImportsEnabled;
        if (context.getRelativeLevel() != 0) {
            return false;
        }
        boolean bl = sameDirectoryImportsEnabled = !ResolveImportUtil.isAbsoluteImportEnabledFor(context.getFoothold());
        if (!sameDirectoryImportsEnabled || !(element instanceof PsiFileSystemItem)) {
            return false;
        }
        QualifiedName shortestImportableQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)element);
        if (shortestImportableQName != null) {
            return Intrinsics.areEqual((Object)name, (Object)shortestImportableQName) ^ true;
        }
        PsiDirectory psiDirectory = context.getContainingDirectory();
        if (psiDirectory == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"context.containingDirectory ?: return false");
        PsiDirectory footholdDir = psiDirectory;
        return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)footholdDir), (PsiElement)element, (boolean)true);
    }

    private static final boolean isSameDirectoryOrRelativeImportResult(QualifiedName name, PsiDirectory directory2, PsiElement result, PyQualifiedNameResolveContext context) {
        if (context.getRelativeLevel() > 0) {
            return true;
        }
        return PyUtil.isPackage(directory2, false, null) && PyResolveImportUtil.isSameDirectoryResult(result, context, name);
    }

    private static final void checkAccess() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        Preconditions.checkState((boolean)application.isReadAccessAllowed(), (String)"This method requires read access", (Object[])new Object[0]);
    }

    private static final List<PsiElement> filterTopPriorityResultsWithFallback(List<? extends PsiElement> primaryResults, List<? extends PsiElement> fallbackResults, List<? extends PsiElement> foreignResults2, QualifiedName name, PyQualifiedNameResolveContext context) {
        List allResults = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)primaryResults, (Iterable)fallbackResults), (Iterable)foreignResults2);
        if (name.getComponentCount() <= 0) {
            return allResults;
        }
        List<PsiElement> filteredPrimaryResults = PyResolveImportUtil.filterTopPriorityResults(primaryResults, context.getModule());
        Collection collection = filteredPrimaryResults;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return CollectionsKt.plus((Collection)filteredPrimaryResults, (Iterable)foreignResults2);
        }
        return CollectionsKt.plus((Collection)PyResolveImportUtil.filterTopPriorityResults(fallbackResults, context.getModule()), (Iterable)foreignResults2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PsiElement> filterTopPriorityResults(List<? extends PsiElement> resolved, Module module) {
        List list;
        List skeletons;
        void $this$groupByTo$iv;
        if (resolved.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = resolved;
        Map destination$iv = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            Priority key$iv = PyResolveImportUtil.resolvedElementPriority(it, module);
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get((Object)key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        SortedMap groupedResults = (SortedMap)destination$iv;
        List list2 = (List)groupedResults.remove((Object)Priority.SKELETON);
        if (list2 == null) {
            list2 = skeletons = CollectionsKt.emptyList();
        }
        if (PyResolveImportUtil.topResultIs(groupedResults, Priority.NAMESPACE_PACKAGE)) {
            Object v = groupedResults.get((Object)Priority.NAMESPACE_PACKAGE);
            Intrinsics.checkNotNull(v);
            return CollectionsKt.plus((Collection)((Collection)v), (Iterable)skeletons);
        }
        groupedResults.remove((Object)Priority.NAMESPACE_PACKAGE);
        if (groupedResults.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else if (PyResolveImportUtil.topResultIs(groupedResults, Priority.STUB_PACKAGE)) {
            list = PyResolveImportUtil.firstResultWithFallback(groupedResults, Priority.STUB_PACKAGE);
        } else if (PyResolveImportUtil.topResultIs(groupedResults, Priority.THIRD_PARTY_SDK)) {
            list = PyResolveImportUtil.firstResultWithFallback(groupedResults, Priority.THIRD_PARTY_SDK);
        } else {
            Collection collection = groupedResults.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"groupedResults.values");
            Object object = CollectionsKt.first((Iterable)collection);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupedResults.values.first()");
            list = CollectionsKt.listOf((Object)CollectionsKt.first((List)((List)object)));
        }
        List priorityResults = list;
        return CollectionsKt.plus((Collection)priorityResults, (Iterable)skeletons);
    }

    private static final boolean topResultIs(SortedMap<Priority, List<PsiElement>> $this$topResultIs, Priority priority) {
        return $this$topResultIs.containsKey((Object)priority) && $this$topResultIs.headMap(priority).isEmpty();
    }

    private static final List<PsiElement> firstResultWithFallback(SortedMap<Priority, List<PsiElement>> results, Priority priority) {
        Object v = results.get((Object)priority);
        Intrinsics.checkNotNull(v);
        PsiElement first = (PsiElement)CollectionsKt.first((List)((List)v));
        Collection<List<PsiElement>> collection = results.tailMap(priority).values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"results.tailMap(priority).values");
        PsiElement nextByPriority = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)collection), (int)1), (int)1)));
        return CollectionsKt.listOfNotNull((Object[])new PsiElement[]{first, nextByPriority});
    }

    private static final Priority resolvedElementPriority(PsiElement element, Module module) {
        return PyNamespacePackageUtil.isNamespacePackage(element) ? Priority.NAMESPACE_PACKAGE : (PyResolveImportUtil.isUserFile(element, module) ? (PyiUtil.isPyiFileOfPackage(element) ? Priority.USER_STUB : Priority.USER_CODE) : (PyStubPackages.isInStubPackage(element) ? Priority.STUB_PACKAGE : (PyResolveImportUtil.isInTypeShed(element) ? Priority.TYPESHED : (PyResolveImportUtil.isInSkeletons(element) ? Priority.SKELETON : (PyiUtil.isPyiFileOfPackage(element) ? Priority.PROVIDED_STUB : (PyStubPackages.isInInlinePackage(element, module) ? Priority.INLINE_PACKAGE : (PyResolveImportUtil.isInProvidedSdk(element) ? Priority.THIRD_PARTY_SDK : Priority.OTHER)))))));
    }

    public static final boolean isInSkeletons(@NotNull PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Sdk sdk = PythonSdkUtil.findPythonSdk(element);
        if (sdk == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"PythonSdkUtil.findPython\u2026(element) ?: return false");
        Sdk sdk2 = sdk;
        if (element instanceof PsiDirectory) {
            object = ((PsiDirectory)element).getVirtualFile();
        } else {
            PsiFile psiFile = element.getContainingFile();
            object = psiFile != null ? psiFile.getVirtualFile() : null;
        }
        if (object == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(if (element is PsiDirec\u2026tualFile) ?: return false");
        VirtualFile vFile = object;
        return PythonSdkUtil.isFileInSkeletons(vFile, sdk2);
    }

    private static final boolean isInProvidedSdk(PsiElement element) {
        return PyThirdPartySdkDetector.EP_NAME.extensions().anyMatch(new Predicate(element){
            final /* synthetic */ PsiElement $element;

            public final boolean test(PyThirdPartySdkDetector it) {
                return it.isInThirdPartySdk(this.$element);
            }
            {
                this.$element = psiElement;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUserFile(PsiElement element, Module module) {
        if (module == null) return false;
        if (!(element instanceof PsiFileSystemItem)) return false;
        VirtualFile virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile it = virtualFile;
        boolean bl3 = false;
        if (it == null) return false;
        if (!ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)it, (boolean)false)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInTypeShed(PsiElement element) {
        if (!PyiUtil.isPyiFileOfPackage(element)) return false;
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiFileSystemItem)) {
            psiElement = null;
        }
        PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)psiElement;
        if (psiFileSystemItem == null) return false;
        VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile it = virtualFile2;
        boolean bl3 = false;
        if (it == null) return false;
        if (!PyTypeShed.INSTANCE.isInside(it)) return false;
        return true;
    }

    public static final /* synthetic */ List access$resolveInRoot(QualifiedName name, VirtualFile root, PyQualifiedNameResolveContext context) {
        return PyResolveImportUtil.resolveInRoot(name, root, context);
    }

    public static final /* synthetic */ boolean access$isAcceptRootAsTopLevelPackage(PyQualifiedNameResolveContext context) {
        return PyResolveImportUtil.isAcceptRootAsTopLevelPackage(context);
    }
}

