/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import com.jetbrains.python.refactoring.classes.membersManager.ClassFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.InstanceFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.MethodsManager;
import com.jetbrains.python.refactoring.classes.membersManager.PropertiesManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.SuperClassesManager;
import com.jetbrains.python.refactoring.classes.membersManager.TypeSafeMovingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MembersManager<T extends PyElement>
implements Function<T, PyMemberInfo<T>> {
    private static final Collection<? extends MembersManager<? extends PyElement>> MANAGERS = Arrays.asList(new MethodsManager(), new SuperClassesManager(), new ClassFieldsManager(), new InstanceFieldsManager(), new PropertiesManager());
    @NotNull
    private final Class<T> myExpectedClass;

    protected MembersManager(@NotNull Class<T> expectedClass) {
        if (expectedClass == null) {
            MembersManager.$$$reportNull$$$0(0);
        }
        this.myExpectedClass = expectedClass;
    }

    @NotNull
    public static List<PyMemberInfo<PyElement>> getAllMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            MembersManager.$$$reportNull$$$0(1);
        }
        ArrayList<PyMemberInfo<PyElement>> result = new ArrayList<PyMemberInfo<PyElement>>();
        for (MembersManager<? extends PyElement> membersManager : MANAGERS) {
            result.addAll(MembersManager.transformSafely(pyClass, membersManager));
        }
        ArrayList<PyMemberInfo<PyElement>> arrayList = result;
        if (arrayList == null) {
            MembersManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PyMemberInfo<PyElement>> transformSafely(@NotNull PyClass pyClass, @NotNull MembersManager<?> manager) {
        if (pyClass == null) {
            MembersManager.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            MembersManager.$$$reportNull$$$0(4);
        }
        List<PyElement> membersCouldBeMoved = manager.getMembersCouldBeMoved(pyClass);
        manager.checkElementTypes(membersCouldBeMoved);
        Collection collection = Collections2.transform(membersCouldBeMoved, manager);
        if (collection == null) {
            MembersManager.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static void moveAllMembers(@NotNull Collection<? extends PyMemberInfo<PyElement>> memberInfos, @NotNull PyClass from, PyClass ... to) {
        if (memberInfos == null) {
            MembersManager.$$$reportNull$$$0(6);
        }
        if (from == null) {
            MembersManager.$$$reportNull$$$0(7);
        }
        if (to == null) {
            MembersManager.$$$reportNull$$$0(8);
        }
        ArrayList<? extends PyMemberInfo<PyElement>> memberInfosSorted = new ArrayList<PyMemberInfo<PyElement>>(memberInfos);
        memberInfosSorted.sort((o1, o2) -> PyDependenciesComparator.INSTANCE.compareAndStoreDependency(o1.getElementToStoreDependency(), o2.getElementToStoreDependency()));
        for (PyMemberInfo pyMemberInfo : memberInfosSorted) {
            TypeSafeMovingStrategy.moveCheckingTypesAtRunTime(from, pyMemberInfo.getMembersManager(), Collections.singleton(pyMemberInfo), to);
        }
        PyDependenciesComparator.clearDependencyInfo(ContainerUtil.map(memberInfos, o -> o.getElementToStoreDependency()));
    }

    void checkElementTypes(@NotNull Iterable<T> elements) {
        if (elements == null) {
            MembersManager.$$$reportNull$$$0(9);
        }
        for (PyElement pyElement : elements) {
            Preconditions.checkArgument((boolean)this.myExpectedClass.isAssignableFrom(pyElement.getClass()), (Object)String.format("Manager %s expected %s but got %s", this, this.myExpectedClass, pyElement));
        }
    }

    @Nullable
    public static PyMemberInfo<PyElement> findMember(@NotNull Collection<? extends PyMemberInfo<PyElement>> members2, @NotNull Predicate<? super PyMemberInfo<PyElement>> predicate) {
        if (members2 == null) {
            MembersManager.$$$reportNull$$$0(10);
        }
        if (predicate == null) {
            MembersManager.$$$reportNull$$$0(11);
        }
        for (PyMemberInfo<PyElement> pyMemberInfo : members2) {
            if (!predicate.apply(pyMemberInfo)) continue;
            return pyMemberInfo;
        }
        return null;
    }

    @Nullable
    public static PyMemberInfo<PyElement> findMember(@NotNull PyClass pyClass, @NotNull Predicate<? super PyMemberInfo<PyElement>> predicate) {
        if (pyClass == null) {
            MembersManager.$$$reportNull$$$0(12);
        }
        if (predicate == null) {
            MembersManager.$$$reportNull$$$0(13);
        }
        return MembersManager.findMember(MembersManager.getAllMembersCouldBeMoved(pyClass), predicate);
    }

    @NotNull
    public static PyMemberInfo<PyElement> findMember(@NotNull PyClass pyClass, @NotNull PyElement pyElement) {
        PyMemberInfo<PyElement> result;
        if (pyClass == null) {
            MembersManager.$$$reportNull$$$0(14);
        }
        if (pyElement == null) {
            MembersManager.$$$reportNull$$$0(15);
        }
        if ((result = MembersManager.findMember(pyClass, (Predicate<? super PyMemberInfo<PyElement>>)new FindByElement(pyElement))) != null) {
            PyMemberInfo<PyElement> pyMemberInfo = result;
            if (pyMemberInfo == null) {
                MembersManager.$$$reportNull$$$0(16);
            }
            return pyMemberInfo;
        }
        throw new IllegalArgumentException(String.format("Element %s not found in class %s or can't be moved", pyElement, pyClass));
    }

    @NotNull
    protected abstract List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass var1);

    protected Collection<? extends PyElement> getElementsToStoreReferences(@NotNull Collection<T> elements) {
        if (elements == null) {
            MembersManager.$$$reportNull$$$0(17);
        }
        return elements;
    }

    protected abstract Collection<PyElement> moveMembers(@NotNull PyClass var1, @NotNull Collection<PyMemberInfo<T>> var2, PyClass ... var3);

    @NotNull
    public abstract PyMemberInfo<T> apply(@NotNull T var1);

    protected static void deleteElements(@NotNull Collection<? extends PsiElement> pyElementsToDelete) {
        if (pyElementsToDelete == null) {
            MembersManager.$$$reportNull$$$0(18);
        }
        for (PsiElement psiElement : pyElementsToDelete) {
            psiElement.delete();
        }
    }

    @NotNull
    protected static <T extends PyElement> Collection<T> fetchElements(@NotNull Collection<? extends PyMemberInfo<T>> memberInfos) {
        if (memberInfos == null) {
            MembersManager.$$$reportNull$$$0(19);
        }
        Collection collection = memberInfos.stream().map(o -> (PyElement)o.getMember()).filter(o -> o != null).collect(Collectors.toList());
        if (collection == null) {
            MembersManager.$$$reportNull$$$0(20);
        }
        return collection;
    }

    public abstract boolean hasConflict(@NotNull T var1, @NotNull PyClass var2);

    @NotNull
    public static Collection<? extends PyElement> getAllDependencies(@NotNull PyClass classWhereMemberDeclared, @NotNull PyElement member, @Nullable PyClass destinationClass) {
        if (classWhereMemberDeclared == null) {
            MembersManager.$$$reportNull$$$0(21);
        }
        if (member == null) {
            MembersManager.$$$reportNull$$$0(22);
        }
        PyMemberInfo<PyElement> memberInfo = MembersManager.findMember(classWhereMemberDeclared, member);
        Collection<PyElement> elementsToCheckDependency = memberInfo.getMembersManager().getElementsToStoreReferences(Collections.singleton(member));
        MultiMap dependencies = new MultiMap();
        HashSet<PyElement> result = new HashSet<PyElement>();
        for (MembersManager<? extends PyElement> membersManager : MANAGERS) {
            for (PyElement elementToCheckDependency : elementsToCheckDependency) {
                dependencies.putAllValues(membersManager.getDependencies(elementToCheckDependency));
            }
        }
        if (destinationClass != null) {
            Iterator classesIterator = dependencies.keySet().iterator();
            while (classesIterator.hasNext()) {
                PyClass pyClass = (PyClass)classesIterator.next();
                if (!pyClass.equals(destinationClass) && !ArrayUtil.contains((Object)pyClass, (Object[])destinationClass.getSuperClasses(null))) continue;
                classesIterator.remove();
            }
        }
        for (MembersManager<? extends PyElement> membersManager : MANAGERS) {
            result.addAll(membersManager.getDependencies((MultiMap<PyClass, PyElement>)dependencies));
        }
        result.addAll(dependencies.values());
        HashSet<PyElement> hashSet = result;
        if (hashSet == null) {
            MembersManager.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    protected abstract MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement var1);

    @NotNull
    protected abstract Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/MembersManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyElementsToDelete";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classWhereMemberDeclared";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/MembersManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMembersCouldBeMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "transformSafely";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findMember";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllMembersCouldBeMoved";
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "transformSafely";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveAllMembers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkElementTypes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMember";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToStoreReferences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 16: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FindByElement
    extends NotNullPredicate<PyMemberInfo<PyElement>> {
        private final PyElement myPyElement;

        private FindByElement(PyElement pyElement) {
            this.myPyElement = pyElement;
        }

        @Override
        public boolean applyNotNull(@NotNull PyMemberInfo<PyElement> input) {
            if (input == null) {
                FindByElement.$$$reportNull$$$0(0);
            }
            return ((PyElement)input.getMember()).equals(this.myPyElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager$FindByElement", "applyNotNull"));
        }
    }
}

