/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.impl.ProcessStreamsSynchronizer;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ProcessControlWithMappings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.ProcessHandlerWithPyPositionConverter;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PyRemoteTracebackFilter;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.run.PythonRunConfigurationTargetEnvironmentAdjuster;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.run.TargetedPythonPaths;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonCommandLineState
extends CommandLineState {
    private static final Logger LOG = Logger.getInstance(PythonCommandLineState.class);
    public static final String GROUP_EXE_OPTIONS = "Exe Options";
    public static final String GROUP_DEBUGGER = "Debugger";
    public static final String GROUP_PROFILER = "Profiler";
    public static final String GROUP_COVERAGE = "Coverage";
    public static final String GROUP_MODULE = "Module";
    public static final String GROUP_SCRIPT = "Script";
    public static final String MODULE_PARAMETER = "-m";
    private final AbstractPythonRunConfiguration<?> myConfig;
    private Boolean myMultiprocessDebug = null;
    private boolean myRunWithPty = PtyCommandLine.isEnabled();

    public boolean isRunWithPty() {
        return this.myRunWithPty;
    }

    public boolean isDebug() {
        return "PyDebugRunner".equals(this.getEnvironment().getRunner().getRunnerId());
    }

    public static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException(PyBundle.message("runcfg.error.message.failed.to.find.free.socket.port", new Object[0]), (Throwable)e);
        }
        return serverSocket;
    }

    public PythonCommandLineState(AbstractPythonRunConfiguration<?> runConfiguration, ExecutionEnvironment env) {
        super(env);
        this.myConfig = runConfiguration;
    }

    @Nullable
    public PythonSdkFlavor getSdkFlavor() {
        return PythonSdkFlavor.getFlavor(this.myConfig.getInterpreterPath());
    }

    @Nullable
    public Sdk getSdk() {
        return this.myConfig.getSdk();
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            PythonCommandLineState.$$$reportNull$$$0(0);
        }
        if (runner == null) {
            PythonCommandLineState.$$$reportNull$$$0(1);
        }
        ExecutionResult executionResult = this.execute(executor, (CommandLinePatcher[])null);
        if (executionResult == null) {
            PythonCommandLineState.$$$reportNull$$$0(2);
        }
        return executionResult;
    }

    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers2) throws ExecutionException {
        return this.execute(executor, this.getDefaultPythonProcessStarter(), patchers2);
    }

    @NotNull
    public ExecutionResult execute(Executor executor) throws ExecutionException {
        ExecutionResult executionResult = this.execute(executor, (TargetEnvironmentRequest targetEnvironmentRequest, PythonExecution pythonScript) -> pythonScript);
        if (executionResult == null) {
            PythonCommandLineState.$$$reportNull$$$0(3);
        }
        return executionResult;
    }

    @NotNull
    public final List<String> getConfiguredInterpreterParameters() {
        String interpreterOptions = this.myConfig.getInterpreterOptions();
        if (!StringUtil.isEmptyOrSpaces((String)interpreterOptions)) {
            List list = ParametersListUtil.parse((String)interpreterOptions);
            if (list == null) {
                PythonCommandLineState.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonCommandLineState.$$$reportNull$$$0(5);
        }
        return list;
    }

    public ExecutionResult execute(Executor executor, PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(processStarter, patchers2);
        ConsoleView console = this.createAndAttachConsoleInEDT(this.myConfig.getProject(), processHandler, executor);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler));
    }

    @NotNull
    private ConsoleView createAndAttachConsoleInEDT(@NotNull Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        if (project == null) {
            PythonCommandLineState.$$$reportNull$$$0(6);
        }
        Ref consoleRef = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                consoleRef.set((Object)this.createAndAttachConsole(project, processHandler, executor));
            }
            catch (ExecutionException | RuntimeException e) {
                consoleRef.set((Object)e);
            }
        });
        if (consoleRef.get() instanceof ExecutionException) {
            throw (ExecutionException)((Object)consoleRef.get());
        }
        if (consoleRef.get() instanceof RuntimeException) {
            throw (RuntimeException)consoleRef.get();
        }
        ConsoleView consoleView = (ConsoleView)consoleRef.get();
        if (consoleView == null) {
            PythonCommandLineState.$$$reportNull$$$0(7);
        }
        return consoleView;
    }

    @NotNull
    public ExecutionResult execute(Executor executor, @NotNull PythonScriptTargetedCommandLineBuilder converter) throws ExecutionException {
        if (converter == null) {
            PythonCommandLineState.$$$reportNull$$$0(8);
        }
        ProcessHandler processHandler = this.startProcess(converter);
        ConsoleView console = this.createAndAttachConsoleInEDT(this.myConfig.getProject(), processHandler, executor);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler));
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = this.createConsoleBuilder(project).getConsole();
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler));
        this.addTracebackFilter(project, consoleView, processHandler);
        consoleView.attachToProcess(processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(9);
        }
        return consoleView2;
    }

    protected void addTracebackFilter(Project project, ConsoleView consoleView, ProcessHandler processHandler) {
        if (PythonSdkUtil.isRemote(this.myConfig.getSdk()) && processHandler instanceof ProcessControlWithMappings) {
            assert (processHandler instanceof ProcessControlWithMappings);
            consoleView.addMessageFilter((Filter)new PyRemoteTracebackFilter(project, this.myConfig.getWorkingDirectory(), (ProcessControlWithMappings)processHandler));
        } else {
            consoleView.addMessageFilter((Filter)new PythonTracebackFilter(project, this.myConfig.getWorkingDirectorySafe()));
        }
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler));
    }

    private TextConsoleBuilder createConsoleBuilder(Project project) {
        if (this.isDebug()) {
            return new PyDebugConsoleBuilder(project, PythonSdkUtil.findSdkByPath(this.myConfig.getInterpreterPath()));
        }
        return TextConsoleBuilderFactory.getInstance().createBuilder(project);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(this.getDefaultPythonProcessStarter(), new CommandLinePatcher[0]);
        if (processHandler == null) {
            PythonCommandLineState.$$$reportNull$$$0(10);
        }
        return processHandler;
    }

    @NotNull
    protected ProcessHandler startProcess(PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        GeneralCommandLine commandLine = this.generateCommandLine(patchers2);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().patchCommandLine((RunConfigurationBase)this.myConfig, this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId());
        ProcessHandler processHandler = processStarter.start(this.myConfig, commandLine);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler, this.getRunnerSettings());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(11);
        }
        return processHandler2;
    }

    @NotNull
    protected ProcessHandler startProcess(@NotNull PythonScriptTargetedCommandLineBuilder builder) throws ExecutionException {
        PythonRunConfigurationTargetEnvironmentAdjuster adjuster;
        if (builder == null) {
            PythonCommandLineState.$$$reportNull$$$0(12);
        }
        TargetEnvironmentRequest targetEnvironmentRequest = this.createTargetEnvironmentRequest();
        Sdk sdk = this.getSdk();
        if (sdk != null && (adjuster = PythonRunConfigurationTargetEnvironmentAdjuster.findTargetEnvironmentRequestAdjuster(sdk)) != null) {
            adjuster.adjust(targetEnvironmentRequest, this.myConfig);
        }
        PythonExecution pythonScript = this.buildPythonExecutionFinal(targetEnvironmentRequest);
        PythonExecution realPythonExecution = builder.build(targetEnvironmentRequest, pythonScript);
        EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
        TargetEnvironment targetEnvironment = targetEnvironmentRequest.prepareEnvironment(TargetProgressIndicator.EMPTY);
        List<String> interpreterParameters = this.getConfiguredInterpreterParameters();
        TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine(realPythonExecution, targetEnvironment, this.myConfig.getSdk(), interpreterParameters);
        ProcessHandler processHandler = PythonCommandLineState.doStartProcess(targetEnvironment, targetedCommandLine, (ProgressIndicator)progressIndicator);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfig, processHandler, this.getRunnerSettings());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(13);
        }
        return processHandler2;
    }

    @NotNull
    private PythonExecution buildPythonExecutionFinal(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(14);
        }
        PythonExecution pythonExecution = this.buildPythonExecution(targetEnvironmentRequest);
        pythonExecution.setWorkingDir(this.getPythonExecutionWorkingDir(targetEnvironmentRequest));
        PythonCommandLineState.initEnvironment(this.myConfig.getProject(), pythonExecution, this.myConfig, this.isDebug(), targetEnvironmentRequest);
        this.customizePythonExecutionEnvironmentVars(targetEnvironmentRequest, pythonExecution.getEnvs(), this.myConfig.isPassParentEnvs());
        PythonExecution pythonExecution2 = pythonExecution;
        if (pythonExecution2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(15);
        }
        return pythonExecution2;
    }

    @Nullable
    protected Function<TargetEnvironment, String> getPythonExecutionWorkingDir(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        String workingDir;
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(16);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(workingDir = this.myConfig.getWorkingDirectory()))) {
            return TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((TargetEnvironmentRequest)targetEnvironmentRequest, (String)workingDir);
        }
        return null;
    }

    @NotNull
    protected final PythonProcessStarter getDefaultPythonProcessStarter() {
        PythonProcessStarter pythonProcessStarter = (config, commandLine) -> {
            ProcessHandler processHandler;
            Sdk sdk = PythonSdkUtil.findSdkByPath(this.myConfig.getInterpreterPath());
            if (PythonSdkUtil.isRemote(sdk)) {
                PyRemotePathMapper pathMapper = this.createRemotePathMapper();
                processHandler = this.createRemoteProcessStarter().startRemoteProcess(sdk, commandLine, this.myConfig.getProject(), pathMapper);
            } else {
                EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)commandLine);
                processHandler = this.doCreateProcess(commandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            }
            return processHandler;
        };
        if (pythonProcessStarter == null) {
            PythonCommandLineState.$$$reportNull$$$0(17);
        }
        return pythonProcessStarter;
    }

    @NotNull
    private static ProcessHandler doStartProcess(@NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (targetEnvironment == null) {
            PythonCommandLineState.$$$reportNull$$$0(18);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(19);
        }
        if (progressIndicator == null) {
            PythonCommandLineState.$$$reportNull$$$0(20);
        }
        ProcessHandler processHandler = PythonCommandLineState.doCreateProcess(targetEnvironment, commandLine, progressIndicator);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(21);
        }
        return processHandler2;
    }

    @Nullable
    private PyRemotePathMapper createRemotePathMapper() {
        if (this.myConfig.getMappingSettings() == null) {
            return null;
        }
        return PyRemotePathMapper.fromSettings(this.myConfig.getMappingSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    protected PyRemoteProcessStarter createRemoteProcessStarter() {
        return new PyRemoteProcessStarter();
    }

    @NotNull
    public final GeneralCommandLine generateCommandLine(CommandLinePatcher @Nullable [] patchers2) {
        return PythonCommandLineState.applyPatchers(this.generateCommandLine(), patchers2);
    }

    @NotNull
    private static GeneralCommandLine applyPatchers(@NotNull GeneralCommandLine commandLine, CommandLinePatcher @Nullable [] patchers2) {
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(22);
        }
        if (patchers2 != null) {
            for (CommandLinePatcher patcher : patchers2) {
                if (patcher == null) continue;
                patcher.patchCommandLine(commandLine);
            }
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(23);
        }
        return generalCommandLine;
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine);
    }

    @NotNull
    private static ProcessHandler doCreateProcess(@NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (targetEnvironment == null) {
            PythonCommandLineState.$$$reportNull$$$0(24);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(25);
        }
        if (progressIndicator == null) {
            PythonCommandLineState.$$$reportNull$$$0(26);
        }
        Process process2 = targetEnvironment.createProcess(commandLine, progressIndicator);
        String commandLineString = StringUtil.join((String[])new String[]{commandLine.getCommandPresentation(targetEnvironment), " "});
        return new ProcessHandlerWithPyPositionConverter(process2, commandLineString, commandLine.getCharset(), targetEnvironment);
    }

    @NotNull
    public GeneralCommandLine generateCommandLine() {
        SdkAdditionalData data = null;
        if (this.myConfig.getSdk() != null) {
            data = this.myConfig.getSdk().getSdkAdditionalData();
        }
        GeneralCommandLine commandLine = PythonCommandLineState.createPythonCommandLine(this.myConfig.getProject(), data, this.myConfig, this.isDebug(), this.myRunWithPty);
        this.buildCommandLineParameters(commandLine);
        this.customizeEnvironmentVars(commandLine.getEnvironment(), this.myConfig.isPassParentEnvs());
        ProcessStreamsSynchronizer.redirectErrorStreamIfNeeded((GeneralCommandLine)commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(27);
        }
        return generalCommandLine;
    }

    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(28);
        }
        throw new UnsupportedOperationException("The implementation of Run Configuration based on Targets API is absent");
    }

    @NotNull
    public static GeneralCommandLine createPythonCommandLine(Project project, @Nullable SdkAdditionalData data, PythonRunParams config, boolean isDebug, boolean runWithPty) {
        GeneralCommandLine commandLine = PythonCommandLineState.generalCommandLine(runWithPty);
        commandLine.withCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
        PythonCommandLineState.createStandardGroups(commandLine);
        PythonCommandLineState.initEnvironment(project, data, commandLine, config, isDebug);
        PythonCommandLineState.setRunnerPath(project, commandLine, config);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(29);
        }
        return generalCommandLine;
    }

    private static GeneralCommandLine generalCommandLine(boolean runWithPty) {
        return runWithPty ? new PtyCommandLine().withConsoleMode(false) : new GeneralCommandLine();
    }

    public static void createStandardGroups(GeneralCommandLine commandLine) {
        ParametersList params = commandLine.getParametersList();
        params.addParamsGroup(GROUP_EXE_OPTIONS);
        params.addParamsGroup(GROUP_DEBUGGER);
        params.addParamsGroup(GROUP_PROFILER);
        params.addParamsGroup(GROUP_COVERAGE);
        params.addParamsGroup(GROUP_MODULE);
        params.addParamsGroup(GROUP_SCRIPT);
    }

    protected static void initEnvironment(Project project, SdkAdditionalData data, GeneralCommandLine commandLine, PythonRunParams runParams, boolean isDebug) {
        HashMap env = Maps.newHashMap();
        PythonCommandLineState.setupEncodingEnvs(env, commandLine.getCharset());
        if (runParams.getEnvs() != null) {
            env.putAll(runParams.getEnvs());
        }
        PythonCommandLineState.addCommonEnvironmentVariables(PythonCommandLineState.getInterpreterPath(project, runParams), env);
        PythonCommandLineState.setupVirtualEnvVariables(runParams, env, runParams.getSdkHome());
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(env);
        commandLine.withParentEnvironmentType(runParams.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        PythonCommandLineState.buildPythonPath(project, commandLine, runParams, isDebug);
        for (PythonCommandLineEnvironmentProvider envProvider : PythonCommandLineEnvironmentProvider.EP_NAME.getExtensionList()) {
            envProvider.extendEnvironment(project, data, commandLine, runParams);
        }
    }

    public static void initEnvironment(@NotNull Project project, @NotNull PythonExecution commandLine, @NotNull PythonRunParams runParams, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (project == null) {
            PythonCommandLineState.$$$reportNull$$$0(30);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(31);
        }
        if (runParams == null) {
            PythonCommandLineState.$$$reportNull$$$0(32);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(33);
        }
        PythonCommandLineState.initEnvironment(project, commandLine, runParams, false, targetEnvironmentRequest);
    }

    private static void initEnvironment(@NotNull Project project, @NotNull PythonExecution commandLine, @NotNull PythonRunParams runParams, boolean isDebug, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (project == null) {
            PythonCommandLineState.$$$reportNull$$$0(34);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(35);
        }
        if (runParams == null) {
            PythonCommandLineState.$$$reportNull$$$0(36);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(37);
        }
        HashMap env = Maps.newHashMap();
        if (runParams.getEnvs() != null) {
            env.putAll(runParams.getEnvs());
        }
        PythonCommandLineState.addCommonEnvironmentVariables(PythonCommandLineState.getInterpreterPath(project, runParams), env);
        PythonCommandLineState.setupVirtualEnvVariables(runParams, env, runParams.getSdkHome());
        Map map2 = ContainerUtil.map2Map(env.entrySet(), e -> Pair.create((Object)((String)e.getKey()), (Object)TargetEnvironmentFunctions.constant((Object)((String)e.getValue()))));
        PythonScripts.extendEnvs(commandLine, map2, targetEnvironmentRequest.getTargetPlatform());
        Charset charset = commandLine.getCharset();
        if (charset != null) {
            PythonCommandLineState.setupEncodingEnvs(commandLine, charset);
        }
        PythonCommandLineState.buildPythonPath(project, commandLine, runParams, isDebug, targetEnvironmentRequest);
    }

    private static void setupVirtualEnvVariables(PythonRunParams myConfig, Map<String, String> env, String sdkHome) {
        Sdk sdk = PythonSdkUtil.findSdkByPath(sdkHome);
        if (sdk != null && (Registry.is((String)"python.activate.virtualenv.on.run") && PythonSdkUtil.isVirtualEnv(sdkHome) || PythonSdkUtil.isConda(sdk))) {
            Map<String, String> environment = PySdkUtil.activateVirtualEnv(sdk);
            env.putAll(environment);
            for (Map.Entry<String, String> e : myConfig.getEnvs().entrySet()) {
                if (!environment.containsKey(e.getKey())) continue;
                if ("PATH".equals(e.getKey())) {
                    env.put(e.getKey(), PythonEnvUtil.addToPathEnvVar(env.get("PATH"), e.getValue(), true));
                    continue;
                }
                env.put(e.getKey(), e.getValue());
            }
        }
    }

    protected static void addCommonEnvironmentVariables(@Nullable String homePath, Map<String, String> env) {
        PythonEnvUtil.setPythonUnbuffered(env);
        if (homePath != null) {
            PythonEnvUtil.resetHomePathChanges(homePath, env);
        }
        env.put("PYCHARM_HOSTED", "1");
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
    }

    public void customizePythonExecutionEnvironmentVars(@NotNull TargetEnvironmentRequest targetEnvironment, @NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs) {
        if (targetEnvironment == null) {
            PythonCommandLineState.$$$reportNull$$$0(38);
        }
        if (envs == null) {
            PythonCommandLineState.$$$reportNull$$$0(39);
        }
    }

    private static void setupEncodingEnvs(Map<String, String> envs, Charset charset) {
        PythonEnvUtil.setupEncodingEnvs(envs, charset);
    }

    private static void setupEncodingEnvs(@NotNull PythonExecution pythonExecution, @NotNull Charset charset) {
        if (pythonExecution == null) {
            PythonCommandLineState.$$$reportNull$$$0(40);
        }
        if (charset == null) {
            PythonCommandLineState.$$$reportNull$$$0(41);
        }
        pythonExecution.addEnvironmentVariable("PYTHONIOENCODING", charset.name());
    }

    public static void buildPythonPath(@NotNull Project project, @NotNull GeneralCommandLine commandLine, @NotNull PythonRunParams config, boolean isDebug) {
        if (project == null) {
            PythonCommandLineState.$$$reportNull$$$0(42);
        }
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(43);
        }
        if (config == null) {
            PythonCommandLineState.$$$reportNull$$$0(44);
        }
        Module module = PythonCommandLineState.getModule(project, config);
        PythonCommandLineState.buildPythonPath(module, commandLine, config.getSdkHome(), config.isPassParentEnvs(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug);
    }

    public static void buildPythonPath(@NotNull Project project, @NotNull PythonExecution pythonScript, @NotNull PythonRunParams config, boolean isDebug, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (project == null) {
            PythonCommandLineState.$$$reportNull$$$0(45);
        }
        if (pythonScript == null) {
            PythonCommandLineState.$$$reportNull$$$0(46);
        }
        if (config == null) {
            PythonCommandLineState.$$$reportNull$$$0(47);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(48);
        }
        Module module = PythonCommandLineState.getModule(project, config);
        PythonCommandLineState.buildPythonPath(module, pythonScript, config.getSdkHome(), config.isPassParentEnvs(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug, targetEnvironmentRequest);
    }

    public static void buildPythonPath(@Nullable Module module, @NotNull GeneralCommandLine commandLine, @Nullable String sdkHome, boolean passParentEnvs, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Sdk pythonSdk2;
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(49);
        }
        if ((pythonSdk2 = PythonSdkUtil.findSdkByPath(sdkHome)) != null) {
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.addAll(PythonCommandLineState.getAddedPaths(pythonSdk2));
            pathList.addAll(PythonCommandLineState.collectPythonPath(module, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug));
            PythonCommandLineState.initPythonPath(commandLine, passParentEnvs, pathList, sdkHome);
        }
    }

    public static void buildPythonPath(@Nullable Module module, @NotNull PythonExecution pythonScript, @Nullable String sdkHome, boolean passParentEnvs, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        Sdk pythonSdk2;
        if (pythonScript == null) {
            PythonCommandLineState.$$$reportNull$$$0(50);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(51);
        }
        if ((pythonSdk2 = PythonSdkUtil.findSdkByPath(sdkHome)) != null) {
            ArrayList<Function<TargetEnvironment, String>> pathList = new ArrayList<Function<TargetEnvironment, String>>();
            pathList.addAll(TargetedPythonPaths.getAddedPaths(targetEnvironmentRequest, pythonSdk2));
            pathList.addAll(TargetedPythonPaths.collectPythonPath(targetEnvironmentRequest, module, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug));
            PythonCommandLineState.initPythonPath(pythonScript, passParentEnvs, pathList, sdkHome, targetEnvironmentRequest);
        }
    }

    public static void initPythonPath(@NotNull GeneralCommandLine commandLine, boolean passParentEnvs, @NotNull List<String> pathList, String interpreterPath) {
        PythonSdkFlavor flavor;
        if (commandLine == null) {
            PythonCommandLineState.$$$reportNull$$$0(52);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(53);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(interpreterPath)) != null) {
            flavor.initPythonPath(commandLine, passParentEnvs, pathList);
        } else {
            PythonEnvUtil.initPythonPath(commandLine.getEnvironment(), passParentEnvs, pathList);
        }
    }

    public static void initPythonPath(@NotNull PythonExecution pythonScript, boolean passParentEnvs, @NotNull List<Function<TargetEnvironment, String>> pathList, @Nullable String interpreterPath, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        PythonSdkFlavor flavor;
        if (pythonScript == null) {
            PythonCommandLineState.$$$reportNull$$$0(54);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(55);
        }
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(56);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(interpreterPath)) != null) {
            LOG.warn("Python interpreter flavor is not taken into account while initializing Python path");
        }
        TargetedPythonPaths.initPythonPath(pythonScript.getEnvs(), passParentEnvs, pathList, targetEnvironmentRequest);
    }

    @NotNull
    public static List<String> getAddedPaths(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PythonCommandLineState.$$$reportNull$$$0(57);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        SdkAdditionalData sdkAdditionalData = pythonSdk2.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> addedPaths = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile file : addedPaths) {
                PythonCommandLineState.addToPythonPath(file, pathList);
            }
        }
        ArrayList<String> arrayList = pathList;
        if (arrayList == null) {
            PythonCommandLineState.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    private static void addToPythonPath(VirtualFile file, Collection<String> pathList) {
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                PythonCommandLineState.addIfNeeded(realFile, pathList);
            }
        } else {
            PythonCommandLineState.addIfNeeded(file, pathList);
        }
    }

    private static void addIfNeeded(@NotNull VirtualFile file, @NotNull Collection<String> pathList) {
        if (file == null) {
            PythonCommandLineState.$$$reportNull$$$0(59);
        }
        if (pathList == null) {
            PythonCommandLineState.$$$reportNull$$$0(60);
        }
        PythonCommandLineState.addIfNeeded(pathList, file.getPath());
    }

    protected static void addIfNeeded(Collection<String> pathList, String path) {
        String filePath;
        HashSet vals = Sets.newHashSet(pathList);
        if (!vals.contains(filePath = FileUtil.toSystemDependentName((String)path))) {
            pathList.add(filePath);
        }
    }

    @VisibleForTesting
    public static Collection<String> collectPythonPath(Project project, PythonRunParams config, boolean isDebug) {
        Module module = PythonCommandLineState.getModule(project, config);
        return PythonCommandLineState.collectPythonPath(module, config.getSdkHome(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module, @Nullable String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        LinkedHashSet pythonPath = Sets.newLinkedHashSet(PythonCommandLineState.collectPythonPath(module, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug && PythonSdkFlavor.getFlavor(sdkHome) instanceof JythonSdkFlavor) {
            pythonPath.add(PythonHelpersLocator.getHelperPath("pycharm"));
            pythonPath.add(PythonHelpersLocator.getHelperPath("pydev"));
        }
        LinkedHashSet linkedHashSet = pythonPath;
        if (linkedHashSet == null) {
            PythonCommandLineState.$$$reportNull$$$0(61);
        }
        return linkedHashSet;
    }

    @Nullable
    private static Module getModule(Project project, PythonRunParams config) {
        String name = config.getModuleName();
        return StringUtil.isEmpty((String)name) ? null : ModuleManager.getInstance((Project)project).findModuleByName(name);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module) {
        return PythonCommandLineState.collectPythonPath(module, true, true);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module, boolean addContentRoots, boolean addSourceRoots) {
        LinkedHashSet<String> pythonPathList = new LinkedHashSet<String>();
        if (module != null) {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            if (addContentRoots) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module).getContentRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getContentRoots());
                }
            }
            if (addSourceRoots) {
                PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)module).getSourceRoots());
                for (Module dependency : dependencies) {
                    PythonCommandLineState.addRoots(pythonPathList, ModuleRootManager.getInstance((Module)dependency).getSourceRoots());
                }
            }
            PythonCommandLineState.addLibrariesFromModule(module, pythonPathList);
            PythonCommandLineState.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                PythonCommandLineState.addLibrariesFromModule(dependency, pythonPathList);
                PythonCommandLineState.addRootsFromModule(dependency, pythonPathList);
            }
        }
        LinkedHashSet<String> linkedHashSet = pythonPathList;
        if (linkedHashSet == null) {
            PythonCommandLineState.$$$reportNull$$$0(62);
        }
        return linkedHashSet;
    }

    private static void addLibrariesFromModule(Module module, Collection<String> list) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            String name;
            if (!(entry instanceof LibraryOrderEntry) || (name = ((LibraryOrderEntry)entry).getLibraryName()) != null && name.endsWith(" interpreter library")) continue;
            for (VirtualFile root : ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    PythonCommandLineState.addToPythonPath(root, list);
                    continue;
                }
                if (!(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                PythonCommandLineState.addToPythonPath(root, list);
            }
        }
    }

    private static void addRootsFromModule(Module module, Collection<String> pythonPathList) {
        Facet[] facets;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path = extension.getCompilerOutputPath();
            if (path != null) {
                pythonPathList.add(path.getPath());
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(pathForTests.getPath());
            }
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
            List<String> more_paths;
            if (!(facet instanceof PythonPathContributingFacet) || (more_paths = ((PythonPathContributingFacet)facet).getAdditionalPythonPath()) == null) continue;
            pythonPathList.addAll(more_paths);
        }
    }

    private static void addRoots(Collection<String> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            PythonCommandLineState.addToPythonPath(root, pythonPathList);
        }
    }

    protected static void setRunnerPath(Project project, GeneralCommandLine commandLine, PythonRunParams config) {
        String interpreterPath = PythonCommandLineState.getInterpreterPath(project, config);
        if (StringUtil.isNotEmpty((String)interpreterPath)) {
            commandLine.setExePath(FileUtil.toSystemDependentName((String)interpreterPath));
        }
    }

    @Nullable
    public static String getInterpreterPath(Project project, PythonRunParams config) {
        Module module;
        Sdk sdk;
        String sdkHome = config.getSdkHome();
        if ((config.isUseModuleSdk() || StringUtil.isEmpty((String)sdkHome)) && (sdk = PythonSdkUtil.findPythonSdk(module = PythonCommandLineState.getModule(project, config))) != null) {
            sdkHome = sdk.getHomePath();
        }
        return sdkHome;
    }

    protected String getInterpreterPath() throws ExecutionException {
        String interpreterPath = this.myConfig.getInterpreterPath();
        if (interpreterPath == null) {
            throw new ExecutionException(PyBundle.message("runcfg.error.message.cannot.find.python.interpreter", new Object[0]));
        }
        return interpreterPath;
    }

    @NotNull
    private TargetEnvironmentRequest createTargetEnvironmentRequest() {
        Sdk sdk = this.getSdk();
        if (sdk == null) {
            throw new IllegalStateException("SDK is not defined for Run Configuration");
        }
        TargetEnvironmentRequest environmentRequest = PythonInterpreterTargetEnvironmentFactory.findTargetEnvironmentRequest(sdk);
        if (environmentRequest == null) {
            throw new IllegalStateException("Cannot find execution environment for SDK " + sdk);
        }
        TargetEnvironmentRequest targetEnvironmentRequest = environmentRequest;
        if (targetEnvironmentRequest == null) {
            PythonCommandLineState.$$$reportNull$$$0(63);
        }
        return targetEnvironmentRequest;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
    }

    public boolean isMultiprocessDebug() {
        if (this.myMultiprocessDebug != null) {
            return this.myMultiprocessDebug;
        }
        return PyDebuggerOptionsProvider.getInstance(this.myConfig.getProject()).isAttachToSubprocess();
    }

    public void setMultiprocessDebug(boolean multiprocessDebug) {
        this.myMultiprocessDebug = multiprocessDebug;
    }

    public void setRunWithPty(boolean runWithPty) {
        this.myRunWithPty = runWithPty;
    }

    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler handler) {
        return new UrlFilter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 6: 
            case 30: 
            case 34: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 16: 
            case 28: 
            case 33: 
            case 37: 
            case 48: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 18: 
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 35: 
            case 43: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParams";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonExecution";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 46: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonScript";
                break;
            }
            case 53: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredInterpreterParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsoleInEDT";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecutionFinal";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPythonProcessStarter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartProcess";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPatchers";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCommandLine";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createPythonCommandLine";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedPaths";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPythonPath";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetEnvironmentRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsoleInEDT";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecutionFinal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutionWorkingDir";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doStartProcess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyPatchers";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProcess";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "initEnvironment";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecutionEnvironmentVars";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setupEncodingEnvs";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonPath";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getAddedPaths";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PythonProcessStarter {
        @NotNull
        public ProcessHandler start(@NotNull AbstractPythonRunConfiguration<?> var1, @NotNull GeneralCommandLine var2) throws ExecutionException;
    }
}

