/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.newProject.steps.PyAddNewEnvironmentPanel;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddSdkDialogFlowAction;
import com.jetbrains.python.sdk.add.PyAddSdkStateListener;
import com.jetbrains.python.sdk.add.PyAddSdkView;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import icons.PythonIcons;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020#H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020#H\u0016J\b\u0010.\u001a\u00020,H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "Ljavax/swing/JPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkView;", "()V", "actions", "", "Lcom/jetbrains/python/sdk/add/PyAddSdkDialogFlowAction;", "", "getActions", "()Ljava/util/Map;", "component", "Ljava/awt/Component;", "getComponent", "()Ljava/awt/Component;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "nameExtensionComponent", "Ljavax/swing/JComponent;", "getNameExtensionComponent", "()Ljavax/swing/JComponent;", "newProjectPath", "", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "addStateListener", "stateListener", "Lcom/jetbrains/python/sdk/add/PyAddSdkStateListener;", "complete", "getOrCreateSdk", "next", "", "onSelected", "previous", "validateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "Companion", "intellij.python.community.impl"})
public abstract class PyAddSdkPanel
extends JPanel
implements PyAddSdkView {
    @NotNull
    private final Icon icon;
    @Nullable
    private final Sdk sdk;
    @Nullable
    private final JComponent nameExtensionComponent;
    @Nullable
    private String newProjectPath;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Map<PyAddSdkDialogFlowAction, Boolean> getActions() {
        return MapsKt.mapOf(PyAddSdkDialogFlowAction.OK.enabled());
    }

    @Override
    @NotNull
    public Component getComponent() {
        return this;
    }

    @Override
    public void addStateListener(@NotNull PyAddSdkStateListener stateListener) {
        Intrinsics.checkNotNullParameter((Object)stateListener, (String)"stateListener");
    }

    @NotNull
    public Void previous() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void next() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public void complete() {
    }

    @Override
    @NotNull
    public abstract String getPanelName();

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public Sdk getSdk() {
        return this.sdk;
    }

    @Nullable
    public JComponent getNameExtensionComponent() {
        return this.nameExtensionComponent;
    }

    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        return this.getSdk();
    }

    @Override
    public void onSelected() {
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.emptyList();
    }

    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public PyAddSdkPanel() {
        Icon icon = PythonIcons.Python.Python;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PythonIcons.Python.Python");
        this.icon = icon;
    }

    @JvmStatic
    @Nullable
    public static final ValidationInfo validateEnvironmentDirectoryLocation(@NotNull TextFieldWithBrowseButton field) {
        return Companion.validateEnvironmentDirectoryLocation(field);
    }

    @JvmStatic
    @Nullable
    protected static final ValidationInfo validateSdkComboBox(@NotNull PySdkPathChoosingComboBox field, @NotNull PyAddSdkView view) {
        return Companion.validateSdkComboBox(field, view);
    }

    @JvmStatic
    @Nullable
    public static final ValidationInfo validateSdkComboBox(@NotNull PySdkPathChoosingComboBox field, @NlsContexts.Button @NotNull String defaultButtonName) {
        return Companion.validateSdkComboBox(field, defaultButtonName);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0005J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSdkPanel$Companion;", "", "()V", "getDefaultButtonName", "", "view", "Lcom/jetbrains/python/sdk/add/PyAddSdkView;", "validateEnvironmentDirectoryLocation", "Lcom/intellij/openapi/ui/ValidationInfo;", "field", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "validateSdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "defaultButtonName", "intellij.python.community.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final ValidationInfo validateEnvironmentDirectoryLocation(@NotNull TextFieldWithBrowseButton field) {
            String string;
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            String string2 = field.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.text");
            String text2 = string2;
            File file = new File(text2);
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                string = PySdkBundle.message("python.venv.location.field.empty", new Object[0]);
            } else if (file.exists() && !file.isDirectory()) {
                string = PySdkBundle.message("python.venv.location.field.not.directory", new Object[0]);
            } else if (PySdkExtKt.isNotEmptyDirectory(file)) {
                string = PySdkBundle.message("python.venv.location.directory.not.empty", new Object[0]);
            } else {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when {\n        StringUti\u2026se -> return null\n      }");
            String message = string;
            return new ValidationInfo(message, (JComponent)field);
        }

        @JvmStatic
        @Nullable
        protected final ValidationInfo validateSdkComboBox(@NotNull PySdkPathChoosingComboBox field, @NotNull PyAddSdkView view) {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return this.validateSdkComboBox(field, this.getDefaultButtonName(view));
        }

        @JvmStatic
        @Nullable
        public final ValidationInfo validateSdkComboBox(@NotNull PySdkPathChoosingComboBox field, @NlsContexts.Button @NotNull String defaultButtonName) {
            ValidationInfo validationInfo;
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
            Sdk sdk = field.getSelectedSdk();
            if (sdk == null) {
                validationInfo = new ValidationInfo(PySdkBundle.message("python.sdk.field.is.empty", new Object[0]), (JComponent)((Object)field));
            } else if (sdk instanceof PySdkToInstall) {
                String message = ((PySdkToInstall)sdk).getInstallationWarning(defaultButtonName);
                validationInfo = new ValidationInfo(message).asWarning().withOKEnabled();
            } else {
                validationInfo = null;
            }
            return validationInfo;
        }

        @NlsContexts.Button
        private final String getDefaultButtonName(PyAddSdkView view) {
            String string;
            Container container = view.getComponent().getParent();
            if ((container != null ? container.getParent() : null) instanceof PyAddNewEnvironmentPanel) {
                String string2 = IdeBundle.message((String)"new.dir.project.create", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"new.dir.project.create\")");
            } else {
                String string3 = CommonBundle.getOkButtonText();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"CommonBundle.getOkButtonText()");
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

